    <?php
        $this->load->view('admin/master/header_2');
        $modul=$this->uri->segment(3);
        $menuid=$this->uri->segment(4);

        setlocale(LC_ALL, 'id_ID.UTF-8');
    ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo $this->session->flashdata('mdt') ?>
            Payment List
            <small>Control panel</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>admin/home/index/8"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Payment</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Filter</h3>
                            <hr>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-remove"></i></button>
                            </div>
                            <div class="col-md-3">
                                <label>DATE START</label>
                                <div class="form-group">
                                    <div class="form-line">
                                        <input
                                        type="date"
                                        class="form-control date_from"
                                        name="date_start"
                                        value="<?php echo $date_from; ?>"
                                        />
                                    </div>
                                </div>  
                            </div>
                            <div class="col-md-3">
                                <label>DATE END</label>
                                <div class="form-group">
                                    <div class="form-line">
                                        <input
                                        type="date"
                                        class="form-control date_to"
                                        name="date_end"
                                        value="<?php echo $date_to; ?>"
                                        />
                                    </div>
                                </div>  
                            </div>
                            <div class="col-md-3">
                                <label>ACCOUNT</label>
                                <div class="form-group">
                                    <div class="form-line">
                                        <select name="account" class="form-control account" id="account">
                                            <option value="All" selected="selected">
                                                All
                                            </option>
                                            <?php
                                                $data_account_admin=$this->master_model->select_in('ms_account','ID, name',"WHERE publish=1 ORDER BY name ASC");
                                                for($a=0; $a < count($data_account_admin); $a++)
                                                {
                                                    echo'
                                                        <option value="'.$data_account_admin[$a]->ID.'">
                                                            '.$data_account_admin[$a]->name.'
                                                        </option>
                                                    ';
                                                }
                                            ?>
                                        </select>
                                    </div>
                                </div>  
                            </div>
                            <div class="col-md-3">
                                <label>PAYMENT</label>
                                <div class="form-group">
                                    <div class="form-line">
                                        <select name="account" class="form-control status" id="status">
                                            <option value="All" selected="selected">
                                                All
                                            </option>
                                            <option value="0">Material</option>
                                            <option value="1">Labour</option>
                                        </select>
                                    </div>
                                </div>  
                            </div>
                            <div class="col-md-12">
                                <label>CARI</label>
                                <div class="form-group">
                                    <div class="form-line">
                                        <input type="text" name="cari" class="form-control" placeholder="Search By Payment">
                                    </div>
                                </div>  
                            </div>
                            <div class="col-md-12">
                                <label></label>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary waves-effect">SEARCH</button>
                                    <a class="btn btn-success export" onClick="clickME()" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing">Export to Excel</a>
                                    <a href="<?php echo base_url();?>admin/finance/payment_insert_labour/<?php echo $menuid;?>" class="btn btn-info btn-fill">Add New Payment Labour</a>
                                    <a href="<?php echo base_url();?>admin/finance/payment_insert/<?php echo $menuid;?>"  class="btn btn-info btn-fill">Add New Payment Material</a>
                                </div>  
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Data Payment</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-remove"></i></button>
                        </div>
                    </div>
                    <div class="box-body get_payment">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Payment No</th>
                                    <th>Payment Date</th>
                                    <th>Admin Account</th>
                                    <th>Supplier Account</th>
                                    <th>Ammount</th>
                                    <th>Admin</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Cancel</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                  for($a=0; $a < count($data_payment); $a++)
                                  {
                                      $b=$a+1;
                                      $ID = $data_payment[$a]->ID;

                                      if($data_payment[$a]->status=='Active')
                                      {
                                        $text='class="text-blue"';
                                      }elseif($data_payment[$a]->status=='Canceled')
                                      {
                                        $text='class="text-red"';
                                      }elseif($data_payment[$a]->status=='Verified')
                                      {
                                        $text='class="text-aqua"';
                                      }

                                      $id_admin=$data_payment[$a]->id_admin;

                                      $data_admin=$this->master_model->select_in('user','name',"WHERE ID=$id_admin");

                                      $account_admin=$data_payment[$a]->account_admin;

                                      $data_account_admin=$this->master_model->select_in('ms_account','name',"WHERE ID=$account_admin");
                                ?>

                                <tr>
                                    <td>
                                        <?php
                                            echo $b;
                                        ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo base_url();?>admin/finance/payment_detail/<?php echo $menuid.'/'.$ID.'/'.$data_payment[$a]->pay_type;?>" class="text-blue">
                                            <?php echo $data_payment[$a]->payment_no;?>
                                        </a>
                                    </td>
                                    <td><?php echo date('d M Y', strtotime($data_payment[$a]->pay_date));?> </td>
                                    <td>
                                        <?php echo $data_account_admin[0]->name;?>
                                    </td>
                                    <td>
                                         <?php echo $data_payment[$a]->supplier_name;?>
                                    </td>

                                    <td>
                                        <?php echo money_format('%.2n', $data_payment[$a]->grandtotal). "\n";?>
                                    </td>
                                    <td>
                                        <?php echo $data_admin[0]->name;?>
                                        <small><?php echo date('d M Y H:i', strtotime($data_payment[$a]->pay_date));?></small>
                                    </td>
                                    <td>
                                        <?php
                                            if($data_payment[$a]->pay_type==0)
                                            {
                                                echo'<span class="text-green">Material</span>';
                                            }else
                                            {
                                                echo'<span class="text-orange">Labour</span>';
                                            }
                                        ?>
                                    </td>
                                    <td <?php echo $text;?>>
                                        <?php echo $data_payment[$a]->status;?>
                                    </td>
                                    <td style="text-align:center">
                                        <?php
                                            if($data_payment[$a]->status=='Canceled')
                                            {
                                                echo'';
                                            }else
                                            {
                                        ?>
                                            <a href="<?php echo base_url();?>admin/finance/delete_payment/<?php echo $menuid.'/'.$ID.'/'.$data_payment[$a]->pay_type;?>" oonClick="return confirm('\Are you sure want to close this payment?')" class="text-red">
                                                <i class="fa fa-times" aria-hidden="true"></i>
                                            </a>
                                        <?php
                                            }
                                        ?>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                        <div class="hidden">
                            <?php echo $this->pagination->create_links(); ?>    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script type="text/javascript">
    $('.date_purchase').daterangepicker();
</script>
    <?php $this->load->view('admin/master/footer_2');?>
