<?php
use Illuminate\Support\Collection;
use Symfony\Component\VarDumper\VarDumper;

if (!function_exists('dd')) {
    function dd($var)
    {
        foreach (func_get_args() as $var) {
            VarDumper::dump($var);
        }
        die();
    }
}

if (!function_exists('crop')){
    function crop($width,$height,$quality,$dir,$post,$new_name,$x,$y,$w,$h)
{
    $targ_w = $width;
    $targ_h = $height;
    $jpeg_quality = $quality;
    $src = $_POST[''.$post.''];
    $img_r = imagecreatefromjpeg($src);
    $dst_r = ImageCreateTrueColor( $targ_w, $targ_h );
    $info=pathinfo($src);
    $name=$new_name.".$info[extension]";
    $new=$dir.$name;
    imagecopyresampled($dst_r,$img_r,0,0,$x,$y,
    $targ_w,$targ_h,$w,$h);
    imagejpeg($dst_r,$new,$jpeg_quality);
}
 
if(isset($_POST['crop'])){
    $width=300;
    $height=600;
    $quality=300;
    $post='source';
    //$dir="assets/thumb/";
    $dir="assets/img/upload/thumb/";
    $info=pathinfo($dir.$_POST['source']);

    $new_name=substr($_POST['version_id'],0,-4);
    //$new_name='crop_'.$_POST['version_id'];
    //$new_name=$_POST['version_id'].'_thumb';
    $x=$_POST['x'];
    $y=$_POST['y'];
    $w=$_POST['w'];
    $h=$_POST['h'];
    crop($width,$height,$quality,$dir,$post,$new_name,$x,$y,$w,$h);
    //redirect('admin/version/edit5/');
    //redirect('admin/versions/edit5/'.$_POST['version_id']);
    redirect('https://www.solusiprogram.net/cl/buana/sopro/admin/cards');
    }
}

if (!function_exists('getRequestHeaders')) {
    function getRequestHeaders()
    {
        $headers = array();
        foreach ($_SERVER as $key => $value) {
            if (substr($key, 0, 5) != 'HTTP_') {
                continue;
            }
            $header           = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
            $headers[$header] = $value;
        }
        return $headers;
    }
}

if (!function_exists('machineColor')) {
    function machineColor($sisa)
    {
        $color = '';
        if ($sisa < 0) {
            $color = 'bg-purple';
        } else if ($sisa > 0 && $sisa < 1000000) {
            $color = 'bg-orange';
        } else {
            $color = 'bg-blue';
        }

        return $color;
    }
}

if (!function_exists('diffHours')) {
    function diffHours($date1)
    {
        if ($date1 != null) {
            $now      = new DateTime();
            $dateTo   = new DateTime($date1);
            $interval = $now->diff($dateTo);
            $elapsed  = $interval->format('%y years %m months %a days %h hours %i minutes %s seconds');
            $day      = abs($interval->format('%a'));
            $h        = abs($interval->format('%h'));

            return $h;
        }

        return 0;
    }
}

if (!function_exists('isWeekend')) {
    function isWeekend($date)
    {
        return (date('N', strtotime($date)) >= 6);
    }
}

if (!function_exists('satuang_singkatan')) {
    function satuang_singkatan($satuan)
    {
        $satuan = strtolower($satuan);
        switch ($satuan) {
            case 'lusin':
                return 'LS';
                break;

            default:
                return $satuan;
                break;
        }

        return $hasil;
    }
}

if (!function_exists('genum')) {
    function genum($id)
    {
        $length = strlen($id);
        $hasil  = '';
        switch ($length) {
            case 1:
                $hasil .= '00' . $id;
                break;

            case 2:
                $hasil .= '0' . $id;
                break;

            default:
                $hasil .= $id;
                break;
        }

        return $hasil;
    }
}

if (!function_exists('genum2')) {
    function genum2($id)
    {
        $length = strlen($id);
        $hasil  = '';
        switch ($length) {
            case 1:
                $hasil .= '000' . $id;
                break;

            case 2:
                $hasil .= '00' . $id;
                break;

            case 3:
                $hasil .= '0' . $id;
                break;

            default:
                $hasil .= $id;
                break;
        }

        return $hasil;
    }
}

if (!function_exists('limitString')) {
    function limitString($string, $min = 500)
    {
        // strip tags to avoid breaking any html
        $string = strip_tags($string);
        if (strlen($string) > $min) {

            // truncate string
            $stringCut = substr($string, 0, $min);
            $endPoint  = strrpos($stringCut, ' ');

            //if the string doesn't contain any space then it will cut without word basis.
            $string = $endPoint ? substr($stringCut, 0, $endPoint) : substr($stringCut, 0);
            $string .= '...';
        }

        return $string;
    }
}

if (!function_exists('generateRandomString')) {
    function generateRandomString(int $length = 10): string
    {
        $characters       = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString     = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

if (!function_exists('getNewVersionImage')) {
    function getNewVersionImage($card): string
    {
        if (isset($card->versions)) {
            $versions        = new Collection($card->versions);
            $version_terbaru = $versions->max('v_name');
            $version         = $versions->firstWhere('v_name', $version_terbaru);
            return base_url('assets/img/upload/version/' . $version->image);
        }

        return 'https://dubsism.files.wordpress.com/2017/12/image-not-found.png';
    }
}

if (!function_exists('versionLink')) {
    function versionLink($card)
    {
        $res = [
            'image'  => 'https://dubsism.files.wordpress.com/2017/12/image-not-found.png',
            'detail' => base_url('admin/versions/create/' . $card->id),
        ];
        if (isset($card->versions)) {
            $versions        = new Collection($card->versions);
            $version_terbaru = $versions->max('v_name');
            $version         = $versions->firstWhere('v_name', $version_terbaru);
            $res             = [
                'image'  => base_url('assets/img/upload/version/' . $version->image),
                'detail' => base_url('admin/versions/edit/' . $card->id),
            ];
        }

        return (object) $res;
    }
}

if (!function_exists('wo_status_color')) {
    function wo_status_color(string $status): string
    {
        switch ($status) {
            case 'done':
                return 'label label-danger';
                break;
            case 'process':
                return 'label label-warning';
                break;
            case 'pending':
                return 'label label-success';
                break;
            default:
                return 'label label-default';
                break;
        }
    }
}

if (!function_exists('wo_status_color_icon')) {
    function wo_status_color_icon(string $status): string
    {
        switch ($status) {
            case 'done':
                return 'col-green';
                break;
            case 'process':
                return 'col-orange';
                break;
            case 'pending':
                return 'col-red';
                break;
            default:
                return 'col-grey';
                break;
        }
    }
}

if (!function_exists('dataTest')) {
    function dataTest(string $var): int
    {
        return 2;
    }
}

if (!function_exists('datePlusMonths')) {
    function datePlusMonths(int $val): string
    {
        return date('Y-m-d', strtotime('+' . $val . ' months'));
    }
}

if (!function_exists('dateMinMonths')) {
    function dateMinMonths(int $val): string
    {
        return date('Y-m-d', strtotime('-' . $val . ' months'));
    }
}

if (!function_exists('dateMinMonthss')) {
    function dateMinMonthss(int $val): string
    {
        return date('Y-m-d H:i:s', strtotime('-' . $val . ' months'));
    }
}

if (!function_exists('fullDateDetail')) {
    function fullDateDetail($date): string
    {
        return $date == null ? '' : date('l jS F Y h:i:s ', strtotime($date));
    }
}

if (!function_exists('humanDate')) {
    function humanDate($date): string
    {
        return $date == null ? '' : date('d M Y', strtotime($date));
    }
}

if (!function_exists('humanDate2')) {
    function humanDate2($date): string
    {
        return $date == null ? '' : date('l, d-m-Y  h:i:s a', strtotime($date));
    }
}

if (!function_exists('thousandSeparator')) {
    function thousandSeparator($num): string
    {
        if ($num == null) {
            return 0;
        }
        $output = $num;
        return number_format($output, 0, '.', ',');
    }
}

if (!function_exists('date_min_one_week')) {
    function date_min_one_week()
    {
        return date('Y-m-d', strtotime(date('Y-m-d') . ' -1 week'));
    }
}

if (!function_exists('date_plus_one_week')) {
    function date_plus_one_week()
    {
        return date('Y-m-d', strtotime(date('Y-m-d') . ' +1 week'));
    }
}

if (!function_exists('date_min_two_week')) {
    function date_min_two_week()
    {
        return date('Y-m-d', strtotime(date('Y-m-d') . ' -2 week'));
    }
}

if (!function_exists('getBrowser')) {
    function getBrowser()
    {
        $u_agent  = $_SERVER['HTTP_USER_AGENT'];
        $bname    = 'Unknown';
        $platform = 'Unknown';
        $version  = '';

        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        } elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        } elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }

        // Next get the name of the useragent yes seperately and for good reason
        if (preg_match('/MSIE/i', $u_agent) && !preg_match('/Opera/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub    = 'MSIE';
        } elseif (preg_match('/Firefox/i', $u_agent)) {
            $bname = 'Mozilla Firefox';
            $ub    = 'Firefox';
        } elseif (preg_match('/OPR/i', $u_agent)) {
            $bname = 'Opera';
            $ub    = 'Opera';
        } elseif (preg_match('/Chrome/i', $u_agent) && !preg_match('/Edge/i', $u_agent)) {
            $bname = 'Google Chrome';
            $ub    = 'Chrome';
        } elseif (preg_match('/Safari/i', $u_agent) && !preg_match('/Edge/i', $u_agent)) {
            $bname = 'Apple Safari';
            $ub    = 'Safari';
        } elseif (preg_match('/Netscape/i', $u_agent)) {
            $bname = 'Netscape';
            $ub    = 'Netscape';
        } elseif (preg_match('/Edge/i', $u_agent)) {
            $bname = 'Edge';
            $ub    = 'Edge';
        } elseif (preg_match('/Trident/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub    = 'MSIE';
        }

        // finally get the correct version number
        $known   = ['Version', $ub, 'other'];
        $pattern = '#(?<browser>' . join('|', $known) .
            ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }
        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent, 'Version') < strripos($u_agent, $ub)) {
                $version = $matches['version'][0];
            } else {
                $version = $matches['version'][1];
            }
        } else {
            $version = $matches['version'][0];
        }

        // check if we have a number
        if ($version == null || $version == '') {$version = '?';}

        return (object) [
            'userAgent' => $u_agent,
            'name'      => $bname,
            'version'   => $version,
            'platform'  => $platform,
            'pattern'   => $pattern,
        ];
    }
}

if (!function_exists('getIP')) {
    function getIP(): string
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }
}
