<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

//error_reporting(E_ALL); ini_set('display_errors', '1');
include './application/controllers/authcontroller' . EXT;

class transaction extends Authcontroller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/master_model');
        $this->load->library('upload');
        $this->load->library('Jurnal');
        $this->load->library('PHPExcel');
        $this->load->library('PHPExcel/IOFactory');
        $this->load->helper('download');

    }

    /*SELECT b.code_inventory, SUM(a.in_qty - a.qty_use - a.qty_waste - a.qty_retur) AS qty_avail, SUM((a.in_qty - a.qty_use - a.qty_waste - a.qty_retur)*a.price) AS total_price FROM `ts_stock_detail` a LEFT JOIN ts_purchase_detail b ON a.id_purchase_detail = b.ID WHERE b.code_inventory='MITC45MC' GROUP BY b.code_inventory */

    public function hapus_table_master()
    {
        $user_id = $this->session->userdata('id_admin');

        if ($user_id == 1) {
            if (isset($_COOKIE['sopro_test_mode'])) {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro_test.ac_reconcile');
                $this->db->query('TRUNCATE solusipr_sopro_test.config_global');
                $this->db->query('TRUNCATE solusipr_sopro_test.key');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_account');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_brand');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_customer');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_filter');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_inventory');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_inventory_category');
                // $this->db->query('TRUNCATE solusipr_sopro_test.ms_menu');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_model');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_promo');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_service');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_spareparts');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_supplier');
                $this->db->query('TRUNCATE solusipr_sopro_test.opname_soin');

                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table</div>');
                    redirect('admin/master/inventory_category/30');
                }

            } else {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro.ac_reconcile');
                $this->db->query('TRUNCATE solusipr_sopro.config_global');
                $this->db->query('TRUNCATE solusipr_sopro.key');
                $this->db->query('TRUNCATE solusipr_sopro.ms_account');
                $this->db->query('TRUNCATE solusipr_sopro.ms_brand');
                $this->db->query('TRUNCATE solusipr_sopro.ms_customer');
                $this->db->query('TRUNCATE solusipr_sopro.ms_filter');
                $this->db->query('TRUNCATE solusipr_sopro.ms_inventory');
                $this->db->query('TRUNCATE solusipr_sopro.ms_inventory_category');
                // $this->db->query('TRUNCATE solusipr_sopro.ms_menu');
                $this->db->query('TRUNCATE solusipr_sopro.ms_model');
                $this->db->query('TRUNCATE solusipr_sopro.ms_promo');
                $this->db->query('TRUNCATE solusipr_sopro.ms_service');
                $this->db->query('TRUNCATE solusipr_sopro.ms_spareparts');
                $this->db->query('TRUNCATE solusipr_sopro.ms_supplier');
                $this->db->query('TRUNCATE solusipr_sopro.opname_soin');
                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table Master</div>');
                    redirect('admin/master/inventory_category/30');
                }
            }

        } else {

            $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
            redirect('admin/master/inventory_category/30');
        }
        // echo $user_id;
        // echo "string1sda";
        // die();
    }

    public function hapus_table_transaksi()
    {
        $user_id = $this->session->userdata('id_admin');

        if ($user_id == 1) {
            if (isset($_COOKIE['sopro_test_mode'])) {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro_test.tbl_cek_barcode');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment_labour');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_production');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase_invoice');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_spk');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_stock_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_verification');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_verification_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_design');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_labour');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_labour_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_material');

                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table</div>');
                    redirect('admin/master/inventory_category/30');
                }

            } else {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro.tbl_cek_barcode');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment_labour');
                $this->db->query('TRUNCATE solusipr_sopro.ts_production');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase_invoice');
                $this->db->query('TRUNCATE solusipr_sopro.ts_spk');
                $this->db->query('TRUNCATE solusipr_sopro.ts_stock_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_verification');
                $this->db->query('TRUNCATE solusipr_sopro.ts_verification_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_design');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_labour');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_labour_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_material');
                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table Transaksi</div>');
                    redirect('admin/master/inventory_category/30');
                }
            }

        } else {

            $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
            redirect('admin/master/inventory_category/30');
        }
        // echo $user_id;
        // echo "string1sda";
        // die();
    }

    public function hapus_table()
    {
        $user_id = $this->session->userdata('id_admin');

        if ($user_id == 1) {
            if (isset($_COOKIE['sopro_test_mode'])) {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro_test.ac_reconcile');
                $this->db->query('TRUNCATE solusipr_sopro_test.config_global');
                $this->db->query('TRUNCATE solusipr_sopro_test.key');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_account');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_brand');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_customer');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_filter');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_inventory');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_inventory_category');
                // $this->db->query('TRUNCATE solusipr_sopro_test.ms_menu');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_model');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_promo');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_service');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_spareparts');
                $this->db->query('TRUNCATE solusipr_sopro_test.ms_supplier');
                $this->db->query('TRUNCATE solusipr_sopro_test.opname_soin');
                $this->db->query('TRUNCATE solusipr_sopro_test.tbl_cek_barcode');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_payment_labour');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_production');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_purchase_invoice');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_spk');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_stock_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_verification');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_verification_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_design');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_labour');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_labour_detail');
                $this->db->query('TRUNCATE solusipr_sopro_test.ts_workorder_material');

                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table</div>');
                    redirect('admin/master/inventory_category/30');
                }

            } else {

                $this->db->trans_start();
                $this->db->query('TRUNCATE solusipr_sopro.ac_reconcile');
                $this->db->query('TRUNCATE solusipr_sopro.config_global');
                $this->db->query('TRUNCATE solusipr_sopro.key');
                $this->db->query('TRUNCATE solusipr_sopro.ms_account');
                $this->db->query('TRUNCATE solusipr_sopro.ms_brand');
                $this->db->query('TRUNCATE solusipr_sopro.ms_customer');
                $this->db->query('TRUNCATE solusipr_sopro.ms_filter');
                $this->db->query('TRUNCATE solusipr_sopro.ms_inventory');
                $this->db->query('TRUNCATE solusipr_sopro.ms_inventory_category');
                // $this->db->query('TRUNCATE solusipr_sopro.ms_menu');
                $this->db->query('TRUNCATE solusipr_sopro.ms_model');
                $this->db->query('TRUNCATE solusipr_sopro.ms_promo');
                $this->db->query('TRUNCATE solusipr_sopro.ms_service');
                $this->db->query('TRUNCATE solusipr_sopro.ms_spareparts');
                $this->db->query('TRUNCATE solusipr_sopro.ms_supplier');
                $this->db->query('TRUNCATE solusipr_sopro.opname_soin');
                $this->db->query('TRUNCATE solusipr_sopro.tbl_cek_barcode');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_payment_labour');
                $this->db->query('TRUNCATE solusipr_sopro.ts_production');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_purchase_invoice');
                $this->db->query('TRUNCATE solusipr_sopro.ts_spk');
                $this->db->query('TRUNCATE solusipr_sopro.ts_stock_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_verification');
                $this->db->query('TRUNCATE solusipr_sopro.ts_verification_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_design');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_labour');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_labour_detail');
                $this->db->query('TRUNCATE solusipr_sopro.ts_workorder_material');
                $this->db->trans_complete();
                if ($this->db->trans_status() === false) {
                    //echo "Failed";
                    $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
                    redirect('admin/master/inventory_category/30');
                } else {
                    //echo "Success";
                    $this->session->set_flashdata('message', '<div class="alert alert-success">Success Delete Value Table</div>');
                    redirect('admin/master/inventory_category/30');
                }
            }

        } else {

            $this->session->set_flashdata('message', '<div class="alert alert-danger">Failed</div>');
            redirect('admin/master/inventory_category/30');
        }

        // echo $user_id;
        // echo "string1sda";
        // die();

    }

    public function purchase($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $before = strtotime(date('Y-m-d'));
        $before = strtotime('-30 day', $before);
        $before = date('Y-m-d', $before);

        $today = date('Y-m-d');

        $jumlah_data = $this->master_model->jumlah_data_purchase();
        $this->load->library('pagination');
        $config['base_url']   = base_url() . 'admin/transaction/purchase/' . $menuid;
        $config['total_rows'] = $jumlah_data;
        $config['per_page']   = 10;
        $from                 = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_purchase'] = $this->master_model->data_purchase($config['per_page'], $from);

        //old code
        // $data['data_purchase'] = $this->master_model->select_in('ts_purchase a', '*', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");

        // baru start code Azhari
        $data['data_purchase'] = $this->db->query('
            SELECT ts_purchase.ID,
               ts_purchase.purchase_no,
               ts_purchase.date_in,
               ts_purchase.date_required,
               ts_purchase.id_supplier,
               ts_purchase.payment_term,
               ts_purchase.ship_via,
               ts_purchase.ref_no,
               ts_purchase.ammount,
               ts_purchase.id_admin,
               ts_purchase.status,
               ts_purchase.note,
               ts_purchase.sort,
               ms_supplier.name
            FROM ts_purchase
            INNER JOIN ms_supplier ON ms_supplier.ID = ts_purchase.id_supplier WHERE ts_purchase.date_in >= date_add(date(now()),INTERVAL-30 day) and ts_purchase.date_in <= date(now()) ORDER BY ID DESC')
        ->result();

        // echo "<pre>";
        // print_r($data);die();
        //end code
        $this->load->view('admin/transaction/purchase', $data);
    }

    public function status_get_po($before, $today, $menuid, $param)
    {
        $status = $this->input->post('status');

        if ($status == 'All') {
            // $data_purchase = $this->db->query('
            // SELECT ts_purchase.ID,
            //    ts_purchase.purchase_no,
            //    ts_purchase.date_in,
            //    ts_purchase.date_required,
            //    ts_purchase.id_supplier,
            //    ts_purchase.payment_term,
            //    ts_purchase.ship_via,
            //    ts_purchase.ref_no,
            //    ts_purchase.ammount,
            //    ts_purchase.id_admin,
            //    ts_purchase.status,
            //    ts_purchase.note,
            //    ts_purchase.sort,
            //    ms_supplier.name
            // FROM ts_purchase
            // INNER JOIN ms_supplier ON ms_supplier.ID = ts_purchase.id_supplier WHERE ts_purchase.date_in >= '".$before."' AND date_in <= '".$today."'  ORDER BY ID DESC')
            // ->result();


            $data_purchase = $this->master_model->select_in('ts_purchase', '*', "WHERE date_in BETWEEN '$before' AND '$today'  ORDER BY ID DESC");
        } else {
            // $data_purchase = $this->db->query('
            // SELECT ts_purchase.ID,
            //    ts_purchase.purchase_no,
            //    ts_purchase.date_in,
            //    ts_purchase.date_required,
            //    ts_purchase.id_supplier,
            //    ts_purchase.payment_term,
            //    ts_purchase.ship_via,
            //    ts_purchase.ref_no,
            //    ts_purchase.ammount,
            //    ts_purchase.id_admin,
            //    ts_purchase.status,
            //    ts_purchase.note,
            //    ts_purchase.sort,
            //    ms_supplier.name
            // FROM ts_purchase
            // INNER JOIN ms_supplier ON ms_supplier.ID = ts_purchase.id_supplier WHERE status='".$status."' AND ts_purchase.date_in >= '".$before."' AND date_in <= '".$today."' ORDER BY ID DESC')
            // ->result();

            $data_purchase = $this->master_model->select_in('ts_purchase', '*', "WHERE status='$status' AND (date_in BETWEEN '$before' AND '$today') ORDER BY ID DESC");
        }

        $count_purchase = count($data_purchase);

        echo '
			<table id="' . $param . '" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Purchase</th>
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Ammount</th>
                        <th>Status</th>
                        <th>Admin</th>
                        <th>Edit</th>
                        <th>Delete</th>
                    </tr>
                </thead>
                <tbody>
		';
        if ($count_purchase == 0) {
            echo '
				<tr>
					<td colspan="9">
						No data available in table
					</td>
				</tr>
			';
        } else {
            for ($a = 0; $a < count($data_purchase); $a++) {
                $b  = $a + 1;
                $ID = $data_purchase[$a]->ID;

                $id_admin = $data_purchase[$a]->id_admin;

                $data_admin = $this->master_model->select_in('user', 'name', "WHERE ID=$id_admin");

                $status = $data_purchase[$a]->status;

                if ($status == 'Pending') {
                    $text = 'class="text-red"';
                } elseif ($status == 'Process') {
                    $text = 'class="text-green"';
                } elseif ($status == 'Close') {
                    $text = 'class="text-blue"';
                }
                echo '
					<tr>
						<td>
							' . $b . '
						</td>
						<td>
							' . $data_purchase[$a]->purchase_no . '
						</td>
						<td>
							' . date('d M Y', strtotime($data_purchase[$a]->date_in)) . '
						</td>
						<td>
							' . $data_purchase[$a]->supplier_name . '
						</td>
						<td>' . str_replace(',', '.', number_format($data_purchase[$a]->ammount)) . '</td>
						<td>
							<span ' . $text . '>
								' . $status . '
							</span>
						</td>
						<td>
							' . $data_admin[0]->name . '
						</td>
						<td style="text-align:center">
							';
                if ($data_purchase[$a]->status != 'Close') {
                    echo '
                        				<a href="' . base_url() . 'admin/transaction/purchase_edit/' . $menuid . '/' . $ID . '" class="edit text-green" style="cursor:pointer">
		                                    <i class="fa fa-edit"></i>
		                                </a>
                        			';
                } else {
                    echo '-';
                }
                echo '
						</td>
						<td style="text-align:center">
							<script>
								$(document).ready(function()
								{
									$(".delete' . $a . '").click(function(e)
									{
										var ID = $(this).attr("alt");

										$.ajax({
											 type: "POST",
											 dataType: "html",
											 url: "' . base_url() . 'admin/transaction/delete_purchase/' . $menuid . '",
											 data:"ID="+ID,
											 success: function(msg)
											 {
												$(".get_purchase").html(msg);

												var x = document.getElementById("snackbar2")
												x.className = "show";
												setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
											 }
										});
									});
								});
							</script>
							';
                if ($data_purchase[$a]->status != 'Close') {
                    echo '
                        				<a alt="' . $ID . '" class="text-red delete' . $a . '" style="cursor:pointer">
		                                    <i class="fa fa-trash-o"></i>
		                                </a>
                        			';
                } else {
                    echo '-';
                }
                echo '
						</td>
					</tr>
				';
            }
        }

        echo '
			</tbody>
			</table>


			<script>

			  $(function ()
			  {
			    $("#' . $param . '").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
    }

    public function insert_purchase($menuid)
    {
        //print_array($this->input->post());
        //exit;

        //$date=$this->input->post('date');
        //$date=date('Y-m-d', strtotime($date));

        $id_admin = $this->session->userdata('id_admin');
        $code_s = $this->input->post('supplier_code');

        $data_suppliyer = $this->master_model->mst_get_data('ms_supplier', 'code', $code_s);
        $id_suppliyer = $data_suppliyer[0]->ID;

        //$required_date=$this->input->post('required_date');
        //$required_date=date('Y-m-d', strtotime($required_date));

        $ID   = $this->master_model->mst_last_id('ts_purchase');
        $data = array(
            'ID'            => $ID,
            'purchase_no'   => $this->input->post('purchase'),
            'date_in'       => date('Y-m-d', strtotime($this->input->post('date'))),
            'date_required' => date('Y-m-d', strtotime($this->input->post('required_date'))),
            'id_supplier'  => $id_suppliyer,
            // 'supplier_code' => $this->input->post('supplier_code'),
            // 'supplier_name' => $this->input->post('supplier_name'),
            'payment_term'  => $this->input->post('payment_term'),
            'ship_via'      => $this->input->post('ship_via'),
            'ref_no'        => $this->input->post('ref_no'),
            'id_admin'      => $id_admin,
            'status'        => $this->input->post('status'),
            'note'          => $this->input->post('note'),
            'sort'          => $ID,
        );

        // echo "<pre>";
        // print_r($data);
        //die();
            $this->db->insert('ts_purchase', $data);

        $code     = $this->input->post('code');
        $item     = $this->input->post('item');
        $qty      = $this->input->post('qty');
        $price    = str_replace(',', '', str_replace('.', '', $this->input->post('price')));
        $subtotal = $this->input->post('subtotal');

        $ammount = 0;
        for ($a = 0; $a < count($code); $a++) {
            if ($code[$a] != '') {
                $id_detail   = $this->master_model->mst_last_id('ts_purchase_detail');
                $id_inventory[$a]   = $this->master_model->check_data_inventory_2($code[$a]);

                $data_detail = array
                    (
                    'ID'             => $id_detail,
                    'id_purchase'    => $ID,
                    'id_inventory'   => $id_inventory[$a],
                    // 'code_inventory' => $code[$a],
                    // 'name_inventory' => $item[$a],
                    'qty'            => $qty[$a],
                    'price'          => $price[$a],
                    'gross_ammount'  => $subtotal[$a],
                    'in_qty'         => 0,
                    'status'         => 'Pending',
                    'sort'           => $id_detail,
                );
                     $this->db->insert('ts_purchase_detail', $data_detail);
                    //print_r($data_detail);
                $ammount = $ammount + $subtotal[$a];
            }
        }

        //die();
        $data_po_ammount = array
            (
            'ammount' => $ammount,
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_purchase', $data_po_ammount);

        redirect('admin/transaction/purchase/' . $menuid . '/added');
    }

    public function purchase_edit($menuid, $ID)
    {

        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $data['data_purchase'] = $this->master_model->mst_data_edit('ts_purchase', $ID);

        // echo "<pre>";
        // print_r($data);die();

        $this->load->view('admin/transaction/purchase_edit', $data);

    }

    public function purchase_preview($menuid, $ID)
    {

        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $data['data_purchase'] = $this->master_model->mst_data_edit('ts_purchase', $ID);
        // echo "<pre>";
        // print_r($data['data_purchase']);
        // die();

        $this->load->view('admin/transaction/purchase_edit', $data);

    }

    public function update_purchase($menuid, $ID)
    {
        $data_input = $this->input->post('id_supplier');
        //print_array($this->input->post());
        //exit;
        // $id_supplier = $this->db->query('SELECT ID from ms_supplier')->row();
        $id_supplier = $this->master_model->select_in('ms_supplier', '*', "WHERE code = '$data_input'");

        // echo"<pre>";
        // print_r($id_supplier);
        // exit();

        $data = array(
            'purchase_no'   => $this->input->post('purchase'),
            'date_in'       => date('Y-m-d', strtotime($this->input->post('date'))),
            'date_required' => date('Y-m-d', strtotime($this->input->post('required_date'))),
            'id_supplier' => $id_supplier[0]->ID,
            // 'supplier_name' => $this->input->post('supplier_name'),
            'payment_term'  => $this->input->post('payment_term'),
            'ship_via'      => $this->input->post('ship_via'),
            'ref_no'        => $this->input->post('ref_no'),
            'status'        => $this->input->post('status'),
            'note'          => $this->input->post('note'),
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_purchase', $data);

        $id_purchase_detail = $this->input->post('id_purchase_detail');
        $code               = $this->input->post('code');
        $item               = $this->input->post('item');
        $qty                = $this->input->post('qty');
        $price              = $this->input->post('price');

        // echo "<pre>";
        // print_r($qty);die();

        $ammount = 0;
        for ($a = 0; $a < count($id_purchase_detail); $a++) {
            if ($code[$a] != '') {
                $id_inventory = $this->master_model->select_in('ms_inventory', '*', "WHERE code = '$code[$a]'");

                if ($id_purchase_detail[$a] != 1111111) {
                    $data_detail = array
                        (
                        // 'code_inventory' => $code[$a],
                        'id_inventory'   => $id_inventory[0]->ID,
                        // 'name_inventory' => $item[$a],
                        'qty'            => $qty[$a],
                        'price'          => $price[$a],
                        'gross_ammount'  => $qty[$a] * $price[$a],
                    );
                    $this->db->where('ID', $id_purchase_detail[$a]);
                    $this->db->update('ts_purchase_detail', $data_detail);
                } else {
                    $id_detail   = $this->master_model->mst_last_id('ts_purchase_detail');
                    $data_detail = array
                        (
                        'ID'             => $id_detail,
                        'id_purchase'    => $ID,
                        'code_inventory' => $code[$a],
                        'name_inventory' => $item[$a],
                        'qty'            => $qty[$a],
                        'price'          => $price[$a],
                        'gross_ammount'  => $qty[$a] * $price[$a],
                        'in_qty'         => 0,
                        'status'         => 'Pending',
                        'sort'           => $id_detail,
                    );
                    $this->db->insert('ts_purchase_detail', $data_detail);
                }
            }

            $ammount = $ammount + ($qty[$a] * $price[$a]);
        }

        $data_po_ammount = array
            (
            'ammount' => $ammount,
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_purchase', $data_po_ammount);

        redirect('admin/transaction/purchase/' . $menuid . '/updated');
    }

    public function delete_purchase($menuid)
    {
        $ID = $this->input->post('ID');

        // print_r($ID);die();

        $this->db->where('ID', $ID);
        $this->db->delete('ts_purchase');

        $this->db->where('id_purchase', $ID);
        $this->db->delete('ts_purchase_detail');

        // $get_po      = $this->master_model->select_in('ts_purchse', 'purchase_no', "WHERE ID=$ID");
        // $purchase_no = $get_po[0]->purchase_no;

        // $this->db->where('purchase_no', $purchase_no);
        // $this->db->delete('ts_stock');

        //redirect('admin/transaction/purchase/'.$menuid);
        // $data['data_purchase'] = $this->master_model->mst_data('ts_purchase');
        redirect('admin/transaction/purchase/' . $menuid);
    }

    public function purchase_insert($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $data['data_purchase'] = $this->master_model->mst_data('ts_purchase');

        $this->load->view('admin/transaction/purchase_insert', $data);
    }

    public function get_supplier($menuid)
    {
        $code          = $this->input->get('code');
        $data_supplier = $this->master_model->select_in('ms_supplier', 'id','code', "WHERE code LIKE '%$code%'");
        for ($c = 0; $c < count($data_supplier); $c++) {
            $code = $data_supplier[$c]->code;
            $id = $data_supplier[$c]->ID;
            echo '
				<option value="' . $id . '">'.$code.'</option>
			';
        }
    }

    public function get_supplier_2($menuid)
    {
        $name          = $this->input->get('name');
        $data_supplier = $this->master_model->select_in('ms_supplier', 'name', "WHERE name LIKE '%$name%'");
        for ($c = 0; $c < count($data_supplier); $c++) {
            $name = $data_supplier[$c]->name;
            echo '
				<option value="' . $name . '">
			';
        }
    }

    public function supplier_get_detail($menuid)
    {
        $code = $this->input->post('code');

        $check_code = $this->master_model->mst_check('ms_supplier', 'code', $code);
        if ($check_code == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_supplier = $this->master_model->select_in('ms_supplier', 'name, payment_term, status', "WHERE code = '$code'");
        echo $data_supplier[0]->name . '%' . $data_supplier[0]->payment_term . '%' . $check . '%' . $data_supplier[0]->status;
    }

    public function supplier_get_detail_2($menuid)
    {
        $name = $this->input->post('name');

        $check_name = $this->master_model->mst_check('ms_supplier', 'name', $name);
        if ($check_name == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_supplier = $this->master_model->select_in('ms_supplier', 'code, payment_term, status', "WHERE name = '$name'");
        echo $data_supplier[0]->code . '%' . $data_supplier[0]->payment_term . '%' . $check . '%' . $data_supplier[0]->status;
    }

    public function get_code_inventory($menuid)
    {
        $code           = $this->input->get('code');
        $data_inventory = $this->master_model->select_in('ms_inventory', 'code', "WHERE code LIKE '%$code%' AND type='Material'");
        for ($c = 0; $c < count($data_inventory); $c++) {
            $code = $data_inventory[$c]->code;
            echo '
				<option value="' . $code . '">
			';
        }
    }

    public function get_code_inventory_2($menuid)
    {
        $code           = $this->input->get('code');
        $data_inventory = $this->master_model->select_in('ms_inventory', 'code', "WHERE code LIKE '%$code%' AND type='Service'");
        //print_array($data_inventory);

        for ($c = 0; $c < count($data_inventory); $c++) {
            $code = $data_inventory[$c]->code;
            echo '
				<option value="' . $code . '">
			';
        }
    }

    public function inventory_get_detail($menuid, $supplier)
    {
        $code = $this->input->post('code');

        $check_code = $this->master_model->mst_check_3('ms_inventory', "code='$code' AND type='Material'");
        if ($check_code == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }

        $check_purchase_code = $this->master_model->mst_check_join('b.ID', 'ts_purchase', 'ts_purchase_detail', 'ON a.ID = b.id_purchase', "WHERE a.id_supplier='$supplier' AND b.id_inventory='$code'");

        if ($check_purchase_code == false) {
            $price = 0;
        } else {
            $data_purchase = $this->master_model->mst_left_join('b.price', 'ts_purchase', 'ts_purchase_detail', 'ON a.ID = b.id_purchase', '', "WHERE a.supplier_code='$supplier' AND b.code_inventory='$code' ORDER BY b.ID DESC LIMIT 1");
            $price         = $data_purchase[0]->price;
        }

        $data_inventory = $this->master_model->select_in('ms_inventory', 'name', "WHERE code = '$code' AND type='Material'");
        echo $data_inventory[0]->name . '%1%' . $price . '%' . $check;
    }

    public function inventory_get_detail_2($menuid)
    {
        $code = $this->input->post('code');

        $check_code = $this->master_model->mst_check_3('ms_inventory', "code='$code' AND type='Service'");
        if ($check_code == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_inventory = $this->master_model->select_in('ms_inventory', 'name', "WHERE code = '$code' AND type='Service'");
        echo $data_inventory[0]->name . '%' . $check;
    }

    public function inventory_get_detail_3($menuid)
    {
        $code = $this->input->post('code');

        $inventory_get_unit = $this->master_model->select_in('ms_inventory', 'unit', "WHERE code='$code'");
        $unit               = $inventory_get_unit[0]->unit;

        $check_code = $this->master_model->mst_check_3('ms_inventory', "code='$code' AND type='Material'");
        if ($check_code == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_inventory = $this->master_model->select_in('ms_inventory', 'name', "WHERE code = '$code' AND type='Material'");
        echo $data_inventory[0]->name . '%<div class="input-group"><input type="text" name="plan[]" class="form-control pull-left" placeholder="Plan" value="0"/><span class="input-group-addon">' . $unit . '</span></div>%' . $check;
    }

    public function get_name_inventory($menuid)
    {
        $code           = $this->input->get('name');
        $data_inventory = $this->master_model->select_in('ms_inventory', 'name', "WHERE name LIKE '%$name%' AND type='Material'");
        for ($c = 0; $c < count($data_inventory); $c++) {
            $name = $data_inventory[$c]->name;
            echo '
				<option value="' . $name . '">
			';
        }
    }

    public function get_name_inventory_2($menuid)
    {
        $code           = $this->input->get('name');
        $data_inventory = $this->master_model->select_in('ms_inventory', 'name', "WHERE name LIKE '%$name%' AND type='Service'");
        for ($c = 0; $c < count($data_inventory); $c++) {
            $name = $data_inventory[$c]->name;
            echo '
				<option value="' . $name . '">
			';
        }
    }

    public function inventory_name_get_detail($menuid)
    {
        $name = $this->input->post('name');

        $check_name = $this->master_model->mst_check_3('ms_inventory', "name='$name' AND type='Material'");
        if ($check_name == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_inventory = $this->master_model->select_in('ms_inventory', 'code', "WHERE name = '$name' AND type='Material'");
        echo $data_inventory[0]->code . '%1%' . $check;
    }

    public function inventory_name_get_detail_2($menuid)
    {
        $name = $this->input->post('name');

        $check_name = $this->master_model->mst_check_3('ms_inventory', "name='$name' AND type='Service'");
        if ($check_name == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_inventory = $this->master_model->select_in('ms_inventory', 'code', "WHERE name = '$name' AND type='Service'");
        echo $data_inventory[0]->code . '%' . $check;
    }

    public function inventory_name_get_detail_3($menuid)
    {
        $name = $this->input->post('name');

        $inventory_get_unit = $this->master_model->select_in('ms_inventory', 'unit', "WHERE name='$name'");
        $unit               = $inventory_get_unit[0]->unit;

        $check_name = $this->master_model->mst_check_3('ms_inventory', "name='$name' AND type='Material'");
        if ($check_name == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }
        $data_inventory = $this->master_model->select_in('ms_inventory', 'code', "WHERE name = '$name' AND type='Material'");
        echo $data_inventory[0]->code . '%<div class="input-group"><input type="text" name="plan[]" class="form-control pull-left" placeholder="Plan" value="0"/><span class="input-group-addon">' . $unit . '</span></div>%' . $check;
    }

    public function inventory_get_qty($menuid)
    {
        $code = $this->input->post('code');

        $check_name = $this->master_model->mst_check_3('ms_inventory', "code='$code' AND type='Material'");

        // print_r($check_name);die();
        if ($check_name == false) {
            echo 0;
        } else {
            echo $qty_avail = $check_name[0]->stock_balance;
        }
    }

    public function inventory_name_get_qty($menuid)
    {
        $name = $this->input->post('name');

        $get_code = $this->master_model->select_in('ms_inventory', 'code', "WHERE name='$name'");
        $code     = $get_code[0]->code;

        $check_name = $this->master_model->mst_check_3('ms_inventory', "code='$code' AND type='Material'");
        if ($check_name == false) {
            echo 0;
        } else {
            echo $qty_avail = $check_name[0]->stock_balance;
        }
    }

    public function qty_subtotal($price, $menuid)
    {
        $qty = $this->input->post('qty');

        echo '
			' . str_replace(',', '.', number_format($qty * $price)) . '
			<input type="hidden" name="subtotal[]" value="' . $qty * $price . '">
		';
    }

    public function price_subtotal($qty, $menuid)
    {
        $price = str_replace(',', '', str_replace('.', '', $this->input->post('price')));

        echo '
			' . str_replace(',', '.', number_format($qty * $price)) . '
			<input type="hidden" name="subtotal[]" value="' . $qty * $price . '">
		';
    }

    public function search_purchase($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $jumlah_data = $this->master_model->jumlah_data_purchase();
        $this->load->library('pagination');
        $config['base_url']   = base_url() . 'admin/transaction/purchase/' . $menuid;
        $config['total_rows'] = $jumlah_data;
        $config['per_page']   = 10;
        $from                 = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_purchase'] = $this->master_model->data_purchase($config['per_page'], $from);

        // $data['data_purchase'] = $this->master_model->select_in('ts_purchase a', '*', "WHERE a.purchase_no LIKE '%$cari%'");
        $data['data_purchase'] = $this->db->query('
                SELECT ts_purchase.ID,
                       ts_purchase.purchase_no,
                       ts_purchase.date_in,
                       ts_purchase.date_required,
                       ts_purchase.id_supplier,
                       ts_purchase.payment_term,
                       ts_purchase.ship_via,
                       ts_purchase.ref_no,
                       ts_purchase.ammount,
                       ts_purchase.id_admin,
                       ts_purchase.status,
                       ts_purchase.note,
                       ts_purchase.sort,
                       ms_supplier.name
                FROM ts_purchase
                INNER JOIN ms_supplier ON ms_supplier.ID = ts_purchase.id_supplier WHERE ts_purchase.purchase_no LIKE \'%'.$cari. '%\'
            ')->result();
        // echo "<pre>";
        // print_r($data['data_purchase']);
        // die();
        //end code
        $this->load->view('admin/transaction/purchase', $data);
    }

    public function search_purchase_invoice($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $jumlah_data = $this->master_model->jumlah_data_purchase();
        $this->load->library('pagination');
        $config['base_url'] = base_url() . 'admin/transaction/purchase_invoice/' . $menuid;
        $config['per_page'] = 10;
        $from               = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_purchase'] = $this->master_model->data_purchase($config['per_page'], $from);

        $data['data_purchase'] = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE purchase_invoice_no LIKE '%$cari%' OR purchase_no LIKE '%$cari%' ORDER BY ID DESC");
        $this->load->view('admin/transaction/purchase_invoice', $data);
        //$data['data_purchase'] = $this->master_model->select_in('ts_purchase a','*', "WHERE a.purchase_no LIKE '%$cari%'");
        // print_r($data['data_purchase']);
        // die();
        //end code
        //$this->load->view('admin/transaction/purchase', $data);
    }

    public function purchase_invoice($menuid)
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $before = strtotime(date('Y-m-d'));
        $before = strtotime('-30 day', $before);
        $before = date('Y-m-d', $before);

        $today = date('Y-m-d');

        $jumlah_data = $this->master_model->jumlah_data_purchase_invoice();
        $this->load->library('pagination');
        $config['base_url']   = base_url() . 'admin/transaction/purchase_invoice/' . $menuid;
        $config['total_rows'] = $jumlah_data;
        $config['per_page']   = 10;
        $from                 = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_purchase'] = $this->master_model->data_purchase_invoice($config['per_page'], $from);

        //$data['data_purchase']= $this->master_model->select_in('ts_purchase_invoice', '*', "ORDER BY ID DESC");
        //WHERE date_in BETWEEN '$before' AND '$today'
        //new script
        $data['data_purchase'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code, b.status as statustype', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");
        //end script

        $this->load->view('admin/transaction/purchase_invoice', $data);
    }

    public function purchase_invoice_get($before, $today, $menuid)
    {
        $val = $this->input->get('val');
        if ($val == null) {
            $val = $this->input->post('val');
        }
        //echo $val;
        //exit;

        setlocale(LC_ALL, 'id_ID.UTF-8');

        if ($val == 'Date') {
            $data_purchase = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE date_in BETWEEN '$before' AND '$today' ORDER BY ID DESC");
        } else {
            $data_purchase = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE supplier_code LIKE '%$val%' OR supplier_name LIKE '%$val%' ORDER BY ID DESC");
        }

        $count = count($data_purchase);

        echo '<br><br><br><br>
			<table id="example2" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Purchase Invoice</th>
                        <th>Purchase Order</th>
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Ammount</th>
                        <th>Paid</th>
                        <th>Due</th>
                        <th>Admin</th>
                        <th>Edit</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
		';

        for ($a = 0; $a < count($data_purchase); $a++) {
            $b  = $a + 1;
            $ID = $data_purchase[$a]->ID;

            $purchase_no = $data_purchase[$a]->purchase_no;
            $id_admin    = $data_purchase[$a]->id_admin;
            $get_admin   = $this->master_model->select_in('user', 'name', "WHERE ID='$id_admin'");

            $supplier_code = $data_purchase[$a]->supplier_code;
            echo '
					<tr>
						<td>
							' . $b . '
						</td>
						<td>
							<a  href="' . base_url() . 'admin/transaction/purchase_invoice_detail/' . $menuid . '/' . $ID . '" class="text-blue" style="cursor:pointer" >
								' . $data_purchase[$a]->purchase_invoice_no . '
							</a>
						</td>
						<td>
							<a  href="' . base_url() . 'admin/transaction/purchase_invoice_detail/' . $menuid . '/' . $ID . '" style="cursor:pointer">
								' . $data_purchase[$a]->purchase_no . '
							</a>
						</td>
						<td>
							' . date('d M Y', strtotime($data_purchase[$a]->date_in)) . '
						</td>
						<td>
							' . $data_purchase[$a]->supplier_name . '
						</td>
						<td>' . money_format('%.2n', $data_purchase[$a]->ammount) . "\n" . '</td>
						<td>
							';
            if ($data_purchase[$a]->paid == 0) {
                echo money_format('%.2n', $data_purchase[$a]->paid) . "\n";
            } else {
                echo '
										<script>
											$(function()
											{
												$(".history_material' . $a . '").click(function()
												{
													 var ID = $(this).attr("alt");

													 //alert(ID);
													 //return false;

													 $.ajax({
														type: "POST",
														dataType: "html",
														url: "' . base_url() . 'admin/finance/payment_history/' . $menuid . '/' . $data_purchase[$a]->purchase_invoice_no . '",
														data: "ID="+ID,
														success: function(data)
														{
															$(".edit-content").html(data);
														}
													});
												});
											});
										</script>
										<a alt="' . $ID . '" class="history_material' . $a . ' text-blue" style="cursor: pointer" data-toggle="modal" data-target="#edit-modal">
											' . money_format('%.2n', $data_purchase[$a]->paid) . "\n" . '
										</a>
									';
            }
            echo '
						</td>
						<td>
							';
            $payment_term = $data_purchase[$a]->due;

            $date_in = strtotime($data_purchase[$a]->date_in);
            $due     = strtotime('+' . $payment_term . ' day', $date_in);
            $due     = date('d M Y', $due);

            echo $due;
            echo '
						</td>
						<td>
							' . $get_admin[0]->name . '
						</td>
						<td style="text-align:center">
							<a href="' . base_url() . 'admin/transaction/purchase_invoice_detail/' . $menuid . '/' . $ID . '" class="text-green" style="cursor:pointer">
								<i class="fa fa-edit"></i>
							</a>
						</td>

						<td style="text-align:center">
	                            	<a href="https://my.jurnal.id/purchases/' . $data_purchase[$a]->id_jurnal_invoice . '" target="_blank" style="cursor:pointer">
	                                   #' . $data_purchase[$a]->id_jurnal_invoice . '
	                                </a>
	                            </td>

					</tr>
				';
        }

        echo '
			</tbody>
			</table>


			<script>

			  $(function ()
			  {
			    $("#example2").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
    }

    public function purchase_invoice_detail($menuid, $ID)
    {
        // $data['data_purchase'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");
        $data['data_edit'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code', "WHERE a.ID = $ID");
        //$data['data_edit'] = $this->master_model->mst_data_edit('ts_purchase_invoice ', $ID);
        // echo "string";
        // echo "<pre>";
        // print_r($data['data_edit']);
        // die;

        $this->load->view('admin/transaction/purchase_invoice_detail', $data);
    }

    public function edit_purchase_invoice($menuid, $ID)
    {

        $ref_no       = $this->input->post('ref_no');
        $payment_term = $this->input->post('payment_term');

        $data = array
            (
            'ref_no' => $ref_no,
            'due'    => $payment_term,
            'note'   => $this->input->post('note'),
        );
        // echo "<pre>";
        // print_r($data);
        // die();
        $this->db->where('ID', $ID);
        $this->db->update('ts_purchase_invoice', $data);

        redirect('admin/transaction/purchase_invoice/' . $menuid);
    }

    public function stock2($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $today = date('Y-m-d');

        $data['date_from'] = $this->input->post('date_from') == null ? date('Y-m-d', strtotime('-' . 1 . ' months')) : $this->input->post('date_from');
        // $date_to   = $this->input->get('date_to') == null ? date('Y-m-d') : $this->input->get('date_to');

        $before_date = strtotime(date('Y-m-d'));
        $before      = strtotime('-30 day', $before_date);
        $before      = date('Y-m-d', $before);

        //$data['data_stock']= $this->master_model->select_in('ts_purchase_invoice','*',"WHERE date_in BETWEEN '$before' AND '$today' ORDER BY ID DESC");

        // $data['data_stock']= $this->master_model->select_in('ts_purchase_invoice','*','ORDER BY ID DESC limit '.$offset.',200' );

        $data['data_stock'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.stock_no, a.ID, a.id_admin, a.date_in, a.purchase_no, b.name as supplier_name, b.status', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");

        $this->load->view('admin/transaction/stock', $data);
    }

    public function stock($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $today = date('Y-m-d');

        $data['date_from'] = $this->input->post('date_from') == null ? date('Y-m-d', strtotime('-' . 1 . ' months')) : $this->input->post('date_from');
        // $date_to   = $this->input->get('date_to') == null ? date('Y-m-d') : $this->input->get('date_to');

        $before_date = strtotime(date('Y-m-d'));
        $before      = strtotime('-30 day', $before_date);
        $before      = date('Y-m-d', $before);

        //$data['data_stock']= $this->master_model->select_in('ts_purchase_invoice','*',"WHERE date_in BETWEEN '$before' AND '$today' ORDER BY ID DESC");

        // $data['data_stock']= $this->master_model->select_in('ts_purchase_invoice','*','ORDER BY ID DESC limit '.$offset.',200' );

        $data['data_stock'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.stock_no, a.ID, a.id_admin, a.date_in, a.purchase_no, b.name as supplier_name, b.status', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");

        $this->load->view('admin/transaction/stock2', $data);
    }

    // // if (!function_exists('dateMinMonths')) {
    //     function dateMinMonths(int $val): string
    //     {
    //         return date('Y-m-d', strtotime('-' . $val . ' months'));
    //     }
    // // }

    public function search_stock($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $data['data_stock'] = $this->master_model->select_in('ts_purchase_invoice a', 'a.*', "WHERE a.purchase_no LIKE '%$cari%' OR a.stock_no LIKE '%$cari%'");

        $this->load->view('admin/transaction/stock', $data);
    }

    public function status_get_stock($before, $today, $menuid)
    {
        $val = $this->input->get('val');
        //echo $val;
        //exit;

        if ($val == 'Date') {
            $data_stock = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE date_in BETWEEN '$before' AND '$today'");
        } else {
            $data_stock = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE supplier_code LIKE '%$val%' OR supplier_name LIKE '%$val%'");
        }

        $count = count($data_stock);

        echo '
			<table id="example2" class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th>No.</th>
                  <th>Transaction No</th>
                  <th>Supplier</th>
                  <th>Date</th>
                  <th>PO No</th>
                  <th>Admin</th>
                  <th>Edit</th>
                  <th>Delete</th>
              </tr>
          </thead>
          <tbody>
		';

        for ($a = 0; $a < count($data_stock); $a++) {
            $b          = $a + 1;
            $ID         = $data_stock[$a]->ID;
            $id_admin   = $data_stock[$a]->id_admin;
            $data_admin = $this->master_model->select_in('user', 'name', "WHERE ID=$id_admin");
            echo '
					<tr>
						<td>
							' . $b . '
						</td>
						<td>
							<a href="' . base_url() . 'admin/transaction/stock_edit/' . $menuid . '/' . $ID . '" class="edit text-blue" style="cursor:pointer">
								' . $data_stock[$a]->stock_no . '
							</a>
						</td>
						<td>
            	' . $data_stock[$a]->supplier_name . '
            </td>
						<td>
							' . date('d M Y', strtotime($data_stock[$a]->date_in)) . '
	          </td>
						<td>
							' . $data_stock[$a]->purchase_no . '
						</td>
						<td>' . $data_admin[0]->name . '</td>
						<td style="text-align:center">
						   <a href="' . base_url() . 'admin/transaction/stock_edit/' . $menuid . '/' . $ID . '" class="edit text-green" style="cursor:pointer">
								<i class="fa fa-edit"></i>
							</a>
						</td>
						<td style="text-align:center">
							<a href="' . base_url() . 'admin/transaction/delete_stock/' . $menuid . '/' . $ID . '" onclick="return confirm(\'Apakah anda ingin menghapus data ini?\')"  class="text-red">
								<i class="fa fa-trash-o"></i>
							</a>
						</td>

					</tr>
				';
        }

        echo '
			</tbody>
			</table>


			<script>

			  $(function ()
			  {
			    $("#example2").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
    }

    public function stock_insert($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $this->load->view('admin/transaction/stock_insert');
    }

    public function stock_edit($menuid, $ID)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        // $data['data_edit'] = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE ID=$ID");

        $data['data_edit'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code', "WHERE a.ID = $ID");

        // echo "<pre>";
        // print_r($data);die();

        $this->load->view('admin/transaction/stock_edit', $data);
    }

    public function stock_edit2($menuid, $ID)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        // $data['data_edit'] = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE ID=$ID");

        $data['data_edit'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code', "WHERE a.ID = $ID");

        // echo "<pre>";
        // print_r($data);die();

        $this->load->view('admin/transaction/stock_edit2', $data);
    }

    public function get_purchase_number($menuid)
    {
        $number        = $this->input->get('number');
        $data_purchase = $this->master_model->select_in('ts_purchase', 'purchase_no', "WHERE purchase_no LIKE '%$number%'");
        for ($c = 0; $c < count($data_purchase); $c++) {
            $purchase_no = $data_purchase[$c]->purchase_no;
            echo '
				<option value="' . $purchase_no . '">
			';
        }
    }

    public function purchase_get_customer($menuid)
    {
        $number = $this->input->post('number');

        $check_po = $this->master_model->mst_check('ts_purchase', 'purchase_no', $number);
        if ($check_po == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }

        $purchase_get_customer = $this->master_model->select_in('ts_purchase', 'supplier_code, supplier_name', "WHERE purchase_no='$number'");

        echo $purchase_get_customer[0]->supplier_code . '%' . $purchase_get_customer[0]->supplier_name . '%' . $check;
    }

    public function supplier_get_po($menuid)
    {
        $name = $this->input->post('name');
          $check_po = $this->master_model->mst_check_new($name);
          // print_r($check_po);
          // die();
        // $check_po = $this->master_model->mst_check('ts_purchase', 'supplier_name', $name);
        if ($check_po == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }

        echo '
			<label>PO No.</label>
			<script>
				$(document).ready(function()
				{
					$(".purchase_get_detail").change(function(e)
					{
						var number = $(this).val();
						var type = $("#type").val();



						if(type=="")
						{
							var x = document.getElementById("snackbar3")
							x.className = "show";
							setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
						}else
						{
							$.ajax({
								 type: "POST",
								 dataType: "html",
								 url: "' . base_url() . 'admin/transaction/purchase_get_detail/"+type+"/' . $menuid . '",
								 data:"number="+number,
								 success: function(msg)
								 {
									$(".purchase_detail").html(msg);
								 }
							});
						}
					});

					$(".purchase_get_status").change(function(e)
					{
						var number = $(this).val();

						$.ajax({
							 type: "POST",
							 dataType: "html",
							 url: "' . base_url() . 'admin/transaction/purchase_get_status/' . $menuid . '",
							 data:"number="+number,
							 success: function(msg)
							 {
								$(".status_po").html(msg);
							 }
						});
					});
				});
			</script>
			<select name="purchase" class="form-control purchase_get_detail purchase_get_status ajax" required>
				<option value="">
					Choose purchase number
				</option>
				';
        $data_purchase = $this->master_model->select_in('ts_purchase a left join ms_supplier b ON a.id_supplier=b.ID', 'purchase_no', "WHERE b.name='$name' AND a.status <> 'Close'");
        // $data_purchase = $this->master_model->select_in('ts_purchase', 'purchase_no', "WHERE supplier_name='$name' AND status <> 'Close'");
        for ($a = 0; $a < count($data_purchase); $a++) {
            echo '
							<option value="' . $data_purchase[$a]->purchase_no . '">
								' . $data_purchase[$a]->purchase_no . '
							</option>
						';
        }
        echo '
			</select>
			<script type="text/javascript">
				//$(document).ajaxStart(function() { Pace.restart(); });
				$(".ajax").change(function(){
					$.ajax({url: "#", success: function(result)
					{
						$(".ajax-content").html("<hr>Ajax Request Completed !");
					}});
				});
			</script>
		';
    }

    public function supplier_get_po_2($menuid)
    {
        $code = $this->input->post('code');
        $check_po = $this->master_model->mst_check_new($name);
        // $check_po = $this->master_model->mst_check('ts_purchase', 'supplier_code', $code);
        if ($check_po == false) {
            $check = 'not exist';
        } else {
            $check = 'exist';
        }

        echo '
			<label>PO No.</label>
			<script>
				$(document).ready(function()
				{
					$(".purchase_get_detail").change(function(e)
					{
						var number = $(this).val();
						var type = $("#type").val();

						//alert(type);
						//return false;

						if(type=="")
						{
							var x = document.getElementById("snackbar")
							x.className = "show";
							x.innerHTML = "Po number does not empty!";
							setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
						}else
						{
							$.ajax({
								 type: "POST",
								 dataType: "html",
								 url: "' . base_url() . 'admin/transaction/purchase_get_detail/"+type+"/' . $menuid . '",
								 data:"number="+number,
								 success: function(msg)
								 {
									$(".purchase_detail").html(msg);
								 }
							});
						}
					});

					$(".purchase_get_status").change(function(e)
					{
						var number = $(this).val();

						$.ajax({
							 type: "POST",
							 dataType: "html",
							 url: "' . base_url() . 'admin/transaction/purchase_get_status/' . $menuid . '",
							 data:"number="+number,
							 success: function(msg)
							 {
								$(".status_po").html(msg);
							 }
						});
					});
				});
			</script>
			<select name="purchase" class="form-control purchase_get_detail purchase_get_status ajax" required>
				<option value="">
					Choose purchase number
				</option>
				';
        $data_purchase = $this->master_model->select_in('ts_purchase a left join ms_supplier b ON a.id_supplier=b.ID', 'purchase_no', "WHERE b.code='$name' AND a.status <> 'Close'");
        //$data_purchase = $this->master_model->select_in('ts_purchase', 'purchase_no', "WHERE supplier_code='$code' AND status <> 'Close'");
        for ($a = 0; $a < count($data_purchase); $a++) {
            echo '
							<option value="' . $data_purchase[$a]->purchase_no . '">
								' . $data_purchase[$a]->purchase_no . '
							</option>
						';
        }
        echo '
			</select>
			<script type="text/javascript">
				//$(document).ajaxStart(function() { Pace.restart(); });
				$(".ajax").change(function(){
					$.ajax({url: "#", success: function(result)
					{
						$(".ajax-content").html("<hr>Ajax Request Completed !");
					}});
				});
			</script>
		';
    }

    public function purchase_get_status($menuid)
    {
        $number     = $this->input->post('number');
        $get_status = $this->master_model->select_in('ts_purchase', 'status', "WHERE purchase_no='$number'");

        echo '
			<label>Status PO</label>
			<br>
            ' . $get_status[0]->status . '
		';
    }

    public function purchase_get_detail($type, $menuid)
    {
        $number = $this->input->post('number');

        $check_po = $this->master_model->mst_check('ts_purchase', 'purchase_no', $number);

        if ($check_po == false) {
            echo '
				<thead>
					<th style="text-align:center">
							<span></span>
                            <div class="switch">
                               <label><input type="checkbox" id="checkAll" class="check_all" /><span class="lever"></span></label>
                            </div>
							//<input type="checkbox" id="checkAll" class="check_all"/>
							<script type="text/javascript">
								$(".check_all").click(function ()
								{
									if ($(this).is(":checked"))
									{
										$(".in_qty_all").removeAttr("disabled");
									}else
									{
										$(".in_qty_all").attr("disabled", true);
									}

									$("input:checkbox").prop("checked", $(this).prop("checked"));
								});
							</script>
						</th>
					<tr>
						<th>No.</th>
						<th>Code</th>
						<th>Item</th>
						<th>Order Qty</th>
						<th>Available Qty</th>
						<th>In Qty</th>
						<th>Left Qty</th>

					</tr>
				</thead>

				<tbody>
					<tr>
						<td colspan="9">
							No data available in table
							<script type="text/javascript">
								var x = document.getElementById("snackbar2")
								x.className = "show";
								setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
							</script>
						</td>
					</tr>
				</tbody>

				<tfoot>
					<tr>
						<td colspan="5">
							<strong>Note : </strong>
							<input type="text" class="form-control" />
						</td>
						<td colspan="4" valign="middle">
							<button type="submit" class="btn btn-info btn-fill pull-right" id="save" style="margin-top:10px;">SAVE</button>
							<a href="' . base_url() . 'admin/transaction/stock/' . $menuid . '" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
							<button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
						</td>
					</tr>
				</tfoot>
			';
        } else {
            echo '
				<thead>
					<tr>
						<th style="text-align:center" style="display: none">
						<span></span>
                            <div class="switch" style="display: none">
                               <label><input type="checkbox" id="check_All" class="check_all" checked/><span class="lever"></span></label>
                            </div>

						</th>
						<th>No.</th>

						<th>Code</th>
						<th>Item</th>
						<th>Order Qty</th>
						<th>Available Qty</th>
						<th style="width:150px;">In Qty</th>
						<th>Left Qty</th>

					</tr>
				</thead>

				<tbody>
			';
            $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$number'");
            $ID              = $get_id_purchase[0]->ID;

            $data_purchase_detail = $this->master_model->select_in('ts_purchase_detail a left join ms_inventory b ON a.id_inventory = b.ID', 'a.ID, a.qty, a.in_qty, b.code as code_inventory, b.name as name_inventory', "WHERE id_purchase=$ID");
            for ($a = 0; $a < count($data_purchase_detail); $a++) {
                $b = $a + 1;

                $id_detail = $data_purchase_detail[$a]->ID;
                $qty       = $data_purchase_detail[$a]->qty;
                $in_qty    = $data_purchase_detail[$a]->in_qty;
                $code      = $data_purchase_detail[$a]->code_inventory;
                $qty_unit  = $qty - $in_qty;

                if ($in_qty == 0) {
                    $order_qty = $qty;
                    $real_qty  = 'id="real_qty_' . $b . '"';
                } else {
                    $order_qty = $qty - $in_qty;
                    $real_qty  = '';
                }

                if ($in_qty == $qty) {
                    $disabled = 'disabled="disabled"';
                } else {
                    $disabled = '';
                }

                $data_inventory = $this->master_model->select_in('ms_inventory', 'unit', "WHERE code='$code'");
                $unit           = $data_inventory[0]->unit;
                echo '
					<tr>
						<td align="center">
							<span></span>
                            <div class="switch" style="display: none">
                               <label><input type="checkbox" id="check_' . $b . '" ' . $disabled . ' checked/><span class="lever"></span></label>
                            </div>


							<script type="text/javascript">
								$("#check_All").click(function ()
								{
									if ($(this).is(":checked"))
									{
										//alert("da")
										
										$("#add_qty_' . $b . '").val(' . $qty_unit . ');
										$("#in_qty_total_' . $b . '").text(0);
									}else
									{
										//$("#in_qty_' . $b . '").attr("disabled", true);
										$("#add_qty_' . $b . '").attr("disabled", true);
										$("#add_qty_' . $b . '").val("");
										$("#in_qty_total_' . $b . '").text(0);
									}
								});

								$("#check_' . $b . '").click(function ()
								{
									if ($(this).is(":checked"))
									{
										//alert("da")
										//$("#in_qty_' . $b . '").removeAttr("disabled");
										$("#add_qty_' . $b . '").removeAttr("disabled");
										$(".check_fill_' . $b . '").val(1);
										$("#add_qty_' . $b . '").val(' . $qty_unit . ');
										$("#in_qty_total_' . $b . '").text(0);
									}else
									{
										//$("#in_qty_' . $b . '").attr("disabled", true);
										$("#add_qty_' . $b . '").attr("disabled", true);
										$("#add_qty_' . $b . '").val("");
										$("#in_qty_total_' . $b . '").text(0);
									}
								});
							</script>

							<input type="hidden" value="0" name="check[]" class="check_fill_' . $b . '">
						</td>
						<td>
							<script type="text/javascript">
							$(document).on("keyup", ".add_qty_' . $b . '", function(){
								//alert("eda")
								value = $(this).val() == "" ? 0 : parseInt($(this).val());
								qty_avail = $(this).attr("isi-qty-avail");
								qty_order = $(this).attr("isi-order-qty");

								//console.log(qty_avail)
								if (value > qty_avail) {
								alert("Exceeds available in qty");
								$(this).val(qty_avail)
									cal = 0;
								} else {
									cal = qty_avail - value
								}
								$("#in_qty_total_' . $b . '").text(cal);
								console.log(cal)

								});
							</script>

							<script type="text/javascript">

								$(".check_all").click(function ()
								{
									var qty=' . $qty . ';
									var in_qty=' . $in_qty . ';

									if(in_qty==qty)
									{
									}else
									{
										$("#check_' . $b . '").prop("checked", $(this).prop("checked"));

										if($(this).is(":checked"))
										{
											//$(".in_qty_all_' . $b . '").removeAttr("disabled");
											$("#add_qty_' . $b . '").removeAttr("disabled");
											$(".check_fill_' . $b . '").val(1);
										}else
										{
											//$(".in_qty_all_' . $b . '").attr("disabled", true);
											$("#add_qty_' . $b . '").attr("disabled", true);
											$(".check_fill_' . $b . '").val(0);
										}
									}
								});
							</script>
							' . $b . '
						</td>

						<td>
							' . $data_purchase_detail[$a]->code_inventory . '
						</td>
						<td>
							' . $data_purchase_detail[$a]->name_inventory . '
						</td>
						<td align="center">
							<input type="hidden" name="order_qty[]" value="' . $data_purchase_detail[$a]->qty . '">
							' . $data_purchase_detail[$a]->qty . ' ' . $unit . '
						</td>
						<td align="center" ' . $real_qty . '>

							' . $qty_unit . '
						</td>
						<td align="center">
							<script>

								$(document).ready(function(){
									$(".in_qty_' . $b . '").focusout(function(e)
									{
										var in_qty = $(this).val();
										var qty = ' . $order_qty . ';

										var real_qty=qty-in_qty;

										if(in_qty > qty)
										{
											var x = document.getElementById("snackbar")
											x.className = "show";
											setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

											$("#in_qty_' . $b . '").val(qty);
											var in_qty_total=parseInt(qty)+parseInt(' . $data_purchase_detail[$a]->in_qty . ');
										}else
										{
											var in_qty_total=parseInt(in_qty)+parseInt(' . $data_purchase_detail[$a]->in_qty . ');
										}

										$("#real_qty_' . $b . '").html(real_qty);
										$("#in_qty_total_' . $b . '").html(in_qty_total);
										$("#in_qty_total_2_' . $b . '").val(in_qty_total);
									});
								});
							</script>


							<input type="hidden" name="qtyxx[]" style="width:150px;" id="in_qty_2_' . $b . '" class="form-control in_qty_' . $b . ' in_qty_all_' . $b . ' pull-left in_qty_focus_' . $b . ' in_qty_fills_' . $b . '" placeholder="In Qty" value="0"/>


							<span id="result' . $b . '"></span>

							<script>

								//$(function(){
									$(".add_qty_' . $b . '").click(function()
									{
									   var ID = $(this).attr("alt");
									   var in_qty = $(".in_qty_fills_' . $b . '").val();

									   var in_qty=in_qty.replace(/, /g, "-");


									   //alert(in_qty);

									   $.ajax({
											type: "POST",
											dataType: "html",
											url: "' . base_url() . 'admin/transaction/add_qty/' . $menuid . '/' . $ID . '/"+in_qty,
											data: "ID="+ID,
											success: function(data)
											{
												$(".modal-content").html(data);
											}
										});
									});
								//});
							</script>


						<input type="text" name="qty[]" style="text-align: right;" alt="' . $b . '--' . $id_detail . '" class="add_qty_' . $b . '" isi-qty-avail="' . $qty_unit . '" isi-order-qty="' . $data_purchase_detail[$a]->qty . '" id="add_qty_' . $b . '" ' . $disabled . '/>

							<input type="hidden" name="id_detail[]" value="' . $data_purchase_detail[$a]->ID . '" ' . $disabled . '/>
							<input type="hidden" name="in_qty_total[]" id="in_qty_total_2_' . $b . '" value="' . $data_purchase_detail[$a]->in_qty . '" ' . $disabled . '/>

							<style type="text/css">
								a[disabled="disabled"] {
									pointer-events: none;
								}
							</style>
						</td>
						<td align="center" id="in_qty_total_' . $b . '">
							0
						</td>

					</tr>
				';
            }
            echo '
				</tbody>
				<tfoot>
					<tr>
						<td colspan="5">
							<strong>Note : </strong>
							<input type="text" name="note" class="form-control" />
						</td>
						<td colspan="4" valign="middle">
							<button type="submit" class="btn btn-info btn-fill pull-right" id="save" style="margin-top:10px;">Save</button>
							<a href="' . base_url() . 'admin/transaction/stock/' . $menuid . '" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
							<button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
						</td>
					</tr>
				</tfoot>
			';
        }
    }

    public function add_qty($menuid, $id_purchase, $in_qty_val = '')
    {
        $ID = $this->input->post('ID');

        $explode   = explode('--', $ID);
        $ID        = $explode[0];
        $id_detail = $explode[1];

        if ($in_qty_val == 0) {
            $data_in_qty = 1;

            $val_in_qty = 0;
            $data_in    = 0;
            //echo'Ke 0';
            //exit;
        } else {
            //$data_in_qty=str_replace('<span>','',str_replace('</span>','',$in_qty_val));
            $data_in     = explode('-', $in_qty_val);
            $data_in_qty = count($data_in);

            //print_array($data_in);

            $val_in_qty = $data_in;

            //echo'to '.$data_in_qty.'</br>';
            //exit;
        }

        $hidden_lot = 10 - $data_in_qty;

        $data_purchase_detail = $this->master_model->select_in('ts_purchase_detail', 'qty, in_qty, code_inventory', "WHERE id_purchase=$id_purchase AND ID=$id_detail");
        $qty                  = $data_purchase_detail[0]->qty;
        $in_qty               = $data_purchase_detail[0]->in_qty;
        $code                 = $data_purchase_detail[0]->code_inventory;

        $qty_unit = $qty - $in_qty;

        $data_inventory = $this->master_model->select_in('ms_inventory', 'unit', "WHERE code='$code'");
        $unit           = $data_inventory[0]->unit;
        echo '
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Available ' . $qty_unit . ' ' . $unit . '</h4>
            </div>
			<div class="modal-body">
				<table class="table table-bordered table-striped purchase_detail">
					<thead>
						<tr>
							<th>
								Lot
							</th>
							<th>
								Qty
							</th>
						</tr>
					</thead>
					<tbody>
						';
        $total_lot = 0;
        for ($a = 0; $a < 20; $a++) {
            $c = $a + 1;
            $b = $c - 1;

            if ($c > $data_in_qty) {
                $display    = 'style="display:none"';
                $val_in_qty = 0;
            } else {
                $display    = '';
                $val_in_qty = $data_in[$a];
            }

            $total_lot = $total_lot + $val_in_qty;
            echo '
									<tr id="row3' . $c . '" ' . $display . '>
										<td align="center">
											' . $c . '
										</td>
										<td>
											<script>
												//$(document).ready(function(){
													$(".in_qty_' . $c . '").focusout(function(e)
													{
														var row=' . $c . ';
														var in_qty = $(this).val();
														var qty=' . $qty . '-' . $in_qty . ';

														in_qty=in_qty.replace(/,/g , ".");

														if(in_qty > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $c . '").val(qty);
															var in_qty_total=+(qty+' . $in_qty . ');
														}else
														{
															$("#in_qty_' . $c . '").val(in_qty);
															var in_qty_total=in_qty+' . $in_qty . ';
														}

														var in_qty_total2=0;
														for(i=0; i < 20; i++)
														{
															var c=i+1;
															var item = $("#in_qty_"+c).val();
															item=item.replace(/,/g , ".");

															if(item != 0)
															{
																var in_qty_total2=parseFloat(item)+parseFloat(in_qty_total2);
															}
														}

														if(in_qty_total2 > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $c . '").val(0);
															//var in_qty_total=+(qty+' . $in_qty . ');

															//$("#total").html("Total : "+in_qty_total2+" ' . $unit . '");
														}else
														{
															$("#total").html("Total : "+parseFloat(in_qty_total2).toFixed(2)+" ' . $unit . '");
														}

														$("#triger_click").trigger("click");

													});
												//});
											</script>
											<div class="input-group">
												<input type="text" name="qty[]" id="in_qty_' . $c . '" class="form-control in_qty_' . $c . ' in_qty_all_' . $c . ' pull-left" placeholder="In Qty" value="' . $val_in_qty . '"/>
												<span class="input-group-addon">' . $unit . '</span>
											</div>
										</td>
									</tr>
								';
        }
        echo '
					</tbody>
					';
        ?>
					<tfoot>
						<tr>
							<td align="center">
								<a class="btn btn-primary addOption loading_btn" id="triger_click" onClick="clickME()" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing">
									Add Lot
								</a>
								<script>
									$('.loading_btn').on('click', function()
									{
										var $this = $(this);
										$this.button('loading');
										setTimeout(function()
										{
										   $this.button('reset');
										}, 500);
									});
								</script>
								<script>
									//$(document).ready(function(){
										var inc = 1;
										$(".addOption").on('click',function()
										{
											inc=inc+1;
											$("#row3"+inc+"").show();
										});
									//});
								</script>
							</td>
                            <td align="right" valign="middle">
                            	<strong id="total">Total : <?php echo $total_lot . ' ' . $unit; ?></strong>
                            </td>
						</tr>
					</tfoot>
					<?php
echo '
				</table>
			</div>
			<div class="modal-footer">
				<script>
					$("#save_item").click(function(e)
						{
							var result = "";
							var in_qty_total=0;
							var in_qty=' . $in_qty . ';

							for(i=0; i < 20; i++)
							{
								var c=i+1;
								var item = parseFloat($("#in_qty_"+c).val());

								if(item != 0)
								{
									//result += "<span>";
									result += item+", "
									//result += "</span>";
								}

								var in_qty_total=item+parseFloat(in_qty_total);
							}

							var result=result;
							var result2 = result.substring(0, result.length - 2);

							//var result=result.replace("<span>","");
							//var result=result.replace("</span>","");

							var show = document.getElementById("result' . $ID . '");
							show.innerHTML = result2+" ' . $unit . '";

							var real_qty=' . $qty . '-parseFloat(in_qty_total);

							$("#in_qty_2_' . $ID . '").val(result2);
							$(".in_qty_focus_' . $ID . '").focus();
							$("#real_qty_' . $ID . '").html(real_qty+" ' . $unit . '");
							$("#in_qty_total_' . $ID . '").html(in_qty_total+in_qty+" ' . $unit . '");
							$("#in_qty_total_2_' . $ID . '").val(in_qty_total+in_qty);
						});
				</script>
				<input type="submit" class="btn btn-info btn-fill pull-right" data-dismiss="modal" value="Save" id="save_item">
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
			</div>
		';
    }

    public function add_qty_2($menuid, $id_purchase)
    {
        $ID = $this->input->post('ID');

        $explode             = explode('--', $ID);
        $ID                  = $explode[0];
        $id_purchase_invoice = $explode[1];
        $id_purchase_detail  = $explode[2];

        //print_array($explode);
        //exit;

        ///$data_purchase = $this->master_model->select_in('ts_purchase','qty',"");

        $data_purchase_detail = $this->master_model->select_in_tabel($id_purchase_detail);

        // print_array($data_purchase_detail);
        // exit;

        $qty    = $data_purchase_detail[0]->qty;
        $in_qty = $data_purchase_detail[0]->in_qty;
        $code   = $data_purchase_detail[0]->code;

        $qty_unit = $qty - $in_qty;

        $data_inventory = $this->master_model->select_in('ms_inventory', 'unit', "WHERE code='$code'");
        $unit           = $data_inventory[0]->unit;

        $data_stock_detail = $this->master_model->select_in('ts_stock_detail', 'ID, in_qty', "WHERE id_purchase_invoice=$id_purchase_invoice AND id_purchase_detail=$id_purchase_detail ORDER BY ID ASC");

        $count_stock_detail = $this->master_model->select_in('ts_stock_detail', 'SUM(in_qty) AS total_in_qty', "WHERE id_purchase_invoice=$id_purchase_invoice AND id_purchase_detail=$id_purchase_detail");
        $total_in_qty       = $count_stock_detail[0]->total_in_qty;

        $count_data_stock_detail = count($data_stock_detail);
        $more_row                = 31 - $count_data_stock_detail;

        //$available = $qty - $total_in_qty;
        $available = $in_qty; //110
        //$available = $qty; //200
        //$available = $total_in_qty; //10
         //$available = $in_qty - $total_in_qty; //100
        $old_qty =  $in_qty - $total_in_qty;


        echo '
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Available ' . $available . ' ' . $unit . ', [' . $code . ']</h4>
            </div>
            <form action="' . base_url() . 'admin/transaction/edit_stock_process/' . $menuid . '/' . $id_purchase . '/' . $id_purchase_detail . '" method="post">
			<div class="modal-body">
				<table class="table table-bordered table-striped purchase_detail">
					<thead>
						<tr>
							<th>
								Lot
							</th>
							<th>
								Qty
							</th>
							<th>
								Status
							</th>
							<th>
								Action
							</th>
						</tr>
					</thead>
					<tbody>
						';
        $total = 0;
        for ($a = 0; $a < count($data_stock_detail); $a++) {
            $in_qty_stock = $data_stock_detail[$a]->in_qty;

            $c = $a + 1;

            $total = $total + $in_qty_stock;

            // $wo_number = $data_stock_detail[$a]->id_workorder_detail;
            // if ($wo_number != 0) {
            //     $disable = 'disabled="disabled"';
            // } else {
            //     $disable = '';
            // }

            echo '
									<tr id="row3' . $c . '">
										<td>
											' . $c . '
											<input name="in_id[]" type="hidden" id="in_id_' . $c . '" value="' . $data_stock_detail[$a]->ID . '"/>
											<input type="hidden" name="old_qty[]" id="in_qty_2' . $c . '" value="' . $old_qty . '">
                                            <input type="hidden" name="in_qty[]" id="in_qty_2' . $c . '" value="0"/>
											<input type="hidden" name="code_inventory[]" value="' . $code . '"/>
										</td>
										<td>
											<script>
												$(document).ready(function()
												{
													$(".in_qty_' . $c . '").focusout(function(e)
													{
														var row=' . $c . ';
														var in_qty = $(this).val();
														var qty=parseFloat(' . $available . ');

														in_qty=in_qty.replace(/,/g , ".");

														if(in_qty > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															x.innerHTML = "Qty should not be greather than total available!";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $c . '").val(qty);
														}else
														{
															$("#in_qty_' . $c . '").val(in_qty);
														}

														var in_qty_total2=0;

														var count_data_stock_detail = ' . $count_data_stock_detail . ';

														for(i=0; i < 31; i++)
														{
															var c=i+1;
															var item = $("#in_qty_"+c).val();
															item=item.replace(/,/g , ".");

															if(item != 0)
															{
																var in_qty_total2=parseFloat(item)+in_qty_total2;
															}
														}

														//alert(in_qty_total2);
														//return false;

														if(in_qty_total2 > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															x.innerHTML = "Qty should not be greather than total available!";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $c . '").val(0);
														}else
														{
															$("#total").html("Total : "+in_qty_total2+" ' . $unit . '");
														}

													});
												});
											</script>
											<div class="input-group">
												<input type="text" name="qty[]" id="in_qty_' . $c . '" class="form-control in_qty_' . $c . ' in_qty_all_' . $c . ' pull-left" placeholder="In Qty" value="' . $in_qty_stock . '" ' . $disable . '/>

												<span class="input-group-addon">' . $unit . '</span>
											</div>
										</td>
										<td align="center">
											';
            if ($data_stock_detail[$a]->id_workorder_detail == 0) {
                echo '<span class="text-red">Pending</span>';
            } else {
                echo '<span class="text-blue">Used</span>';
            }
            echo '
										</td>
										<td align="center">
											<script>
												$(document).ready(function()
												{
													$(".delete_' . $c . '").click(function(e)
													{
														$("#in_qty_' . $c . '").val(0);
														$("#in_qty_2' . $c . '").val(100000);
														var more_row = ' . $more_row . ';

														//alert(more_row);
														//return false;

														var in_qty_total2=0;
														for(i=0; i < 31; i++)
														{
															var c=i+1;
															var item = $("#in_qty_"+c).val();
															item=item.replace(/,/g , ".");

															if(item != 0)
															{
																var in_qty_total2=parseFloat(item)+in_qty_total2;
															}
														}

														$("#total").html("<strong>Total : "+in_qty_total2+" ' . $unit . '</strong>");
													});
												});
											</script>
											';
            if ($wo_number != 0) {
                echo '
														<a class="text-gray" disabled="disabled">
															<i class="fa fa-trash-o"></i>
														</a>
													';
            } else {
                echo '
														<a href="' . base_url() . 'admin/transaction/delete_stock_detail/' . $menuid . '/' . $id_purchase . '/' . $data_stock_detail[$a]->ID . '" class="text-red delete_' . $c . '" style="cursor:pointer">
															<i class="fa fa-trash-o"></i>
														</a>
													';
            }
            echo '
										</td>
									</tr>
								';
        }

        for ($f = 0; $f < $more_row; $f++) {
            $g = $f + $count_data_stock_detail;

            echo '
									<tr id="row3' . $g . '" style="display:none">
										<td>
											' . $g . '
											<input name="in_id[]" type="hidden" id="in_id_' . $g . '" value="0"/>
											<input type="hidden" name="in_qty[]" id="in_qty_2' . $g . '" value="10000"/>
											<input type="hidden" name="code_inventory[]" value="' . $code . '"/>
										</td>
										<td>
											<script>
												$(document).ready(function()
												{
													$(".in_qty_' . $g . '").focusout(function(e)
													{
														var row=' . $g . ';
														var in_qty = $(this).val();
														var qty=' . $available . ';

														in_qty=in_qty.replace(/,/g , ".");

														if(in_qty > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															x.innerHTML = "Qty should not be greather than total available!";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $g . '").val(qty);
														}else
														{
															$("#in_qty_' . $g . '").val(in_qty);
														}

														var in_qty_total2=0;
														for(i=0; i < 31; i++)
														{
															var c=i+1;
															var item = $("#in_qty_"+c).val();
															item=item.replace(/,/g , ".");

															if(item != 0)
															{
																var in_qty_total2=parseFloat(item)+parseFloat(in_qty_total2);
															}
														}

														//alert(in_qty_total2);
														//return false;

														if(in_qty_total2 > qty)
														{
															var x = document.getElementById("snackbar")
															x.className = "show";
															x.innerHTML = "Qty should not be greather than total available!";
															setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

															$("#in_qty_' . $g . '").val(0);
														}else
														{
															$("#total").html("Total : "+in_qty_total2+" ' . $unit . '");
														}

													});
												});
											</script>
											<div class="input-group">
												<input type="text" name="qty[]" id="in_qty_' . $g . '" class="form-control in_qty_' . $g . ' in_qty_all_' . $g . ' pull-left" placeholder="In Qty" value="0"/>
												<span class="input-group-addon">' . $unit . '</span>
											</div>

										</td>
										<td align="center">
											-
										</td>
										<td align="center">
											<script>
												$(document).ready(function()
												{
													$(".delete_' . $g . '").click(function(e)
													{
														$("#in_qty_' . $g . '").val(0);

														var in_qty_total2=0;
														for(i=0; i < 31; i++)
														{
															var c=i+1;
															var item = $("#in_qty_"+c).val();

															$("#in_id_"+c).val();

															item=item.replace(/,/g , ".");

															if(item != 0)
															{
																var in_qty_total2=parseFloat(item)+in_qty_total2;
															}
														}

														$("#total").html("<strong>Total : "+in_qty_total2+" ' . $unit . '</strong>");
													});
												});
											</script>
											<a class="text-red delete_' . $g . '" style="cursor:pointer">
												<i class="fa fa-trash-o"></i>
											</a>
										</td>
									</tr>
								';
        }
        echo '
					</tbody>
					';

        ?>
					<tfoot>
						<tr>
							<td>
								<!-- <a class="btn btn-primary addOption loading_btn" onClick="clickME()" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing">
									Add Lot
								</a> -->
								<script>
									$('.loading_btn').on('click', function()
									{
										var $this = $(this);
										$this.button('loading');
										setTimeout(function()
										{
										   $this.button('reset');
										}, 500);
									});
								</script>
								<script>
									//$(document).ready(function(){
										var inc = <?php echo $count_data_stock_detail; ?>;
										$(".addOption").on('click',function()
										{
											inc=inc+1;
											$("#row3"+inc+"").show();
											$("#in_id_"+inc+"").val(100000);
											$("#in_qty_2"+inc+"").val(1000000);
										});
									//	});
								</script>
							</td>
                            <td colspan="3" align="right" valign="middle">
                            	<strong id="total">Total : <?php echo $total . ' ' . $unit; ?></strong>
                            </td>
						</tr>
					</tfoot>
					<?php
echo '
				</table>
			</div>
			<div class="modal-footer">
					<script>
						$(document).ready(function()
						{
							$("#save_item").click(function(e)
							{
								var result = "";
								var in_qty_total=0;

								for(i=0; i < 31; i++)
								{
									var c=i+1;
									var item = parseFloat($("#in_qty_"+c).val());
									var in_id = parseFloat($("#in_id_"+c).val());
									var in_qty = parseFloat($("#in_qty_2"+c).val());

									if(item != 0)
									{
										result += "<span>";
										result += "<span>"+item+"</span>, "
										result += "</span>";
									}

									if(in_id != 0)
									{
										result2 += "<span>";
										result2 += "<span>"+in_id+"</span>, "
										result2 += "</span>";
									}

									if(in_qty != 10000)
									{
										result3 += "<span>";
										result3 += "<span>"+in_qty+"</span>, "
										result3 += "</span>";
									}

									var in_qty_total=item+in_qty_total;
								}

								var result2=result2;
								var result2 = result2.substring(0, result2.length - 9);

								var result3=result3;
								var result3 = result3.substring(0, result3.length - 9);

								var result=result;
								var result = result.substring(0, result.length - 9);

								var show = document.getElementById("result' . $ID . '");
  								show.innerHTML = result;

								var show2 = document.getElementById("result2' . $ID . '");

								var show3 = document.getElementById("result3' . $ID . '");

								$("#result3' . $ID . '").val(result2);

								$("#result4' . $ID . '").val(result3);

								var real_qty=' . $qty . '-in_qty_total;

								$("#in_qty_3_' . $ID . '").val(show.innerHTML = result);
								$("#real_qty_' . $ID . '").html(real_qty);
								$("#in_qty_total_' . $ID . '").html(parseInt(in_qty_total)+" ' . $unit . '");
								$("#in_qty_total_2_' . $ID . '").val(in_qty_total);
							});
						});
					</script>
				<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save_item"> <!--data-dismiss="modal"-->
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
			</div>
			</form>
		';
    }

    public function delete_stock_detail($menuid, $id_purchase, $id_stock_detail)
    {
        $this->db->where('ID', $id_stock_detail);
        $this->db->delete('ts_stock_detail');

        redirect('admin/transaction/stock_edit/' . $menuid . '/' . $id_purchase);
    }

    public function purchase_get_detail_2($menuid)
    {
        $number = $this->input->post('number');

        $check_po = $this->master_model->mst_check('ts_purchase', 'purchase_no', $number);

        if ($check_po == false) {
            echo '
				<thead>
					<tr>
						<th>No.</th>
						<th>Code</th>
						<th>Description</th>
						<th>Requested</th>
						<th>Actual</th>
						<th>Return</th>
						<th>Unit Price</th>
						<th>Gross Ammount</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td colspan="8">
							No data available in table
							<script>
								var x = document.getElementById("snackbar2")
								x.className = "show";
								setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
							</script>
						</td>
					</tr>
				</tbody>
			';
        } else {
            $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$number'");
            $ID              = $get_id_purchase[0]->ID;

            $check_purchase = $this->master_model->check_purchase($ID, 'Material');

            //$check_po=$this->master_model->mst_check('ts_purchase', 'purchase_no', $number);

            if ($check_purchase == false) {
                echo '
					<thead>
						<tr>
							<th>No.</th>
							<th>Code</th>
							<th>Description</th>
							<th>Requested</th>
							<th>Actual</th>
							<th>Return</th>
							<th>Unit Price</th>
							<th>Gross Ammount</th>
						</tr>
					</thead>
					<tbody>
					<tr>
						<td colspan="8">
							No data available in table
							<script>
								$(document).ready(function()
								{
									$("#tab_2").trigger("click");
								});
							</script>
						</td>
					</tr>
					</tbody>
				';
                ?>
					<tfoot>
						<tr>
							<td colspan="4">
								<strong>Note : </strong>
								<input type="text" class="form-control" />
							</td>
							<td colspan="4" valign="middle">
								<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save" style="margin-top:10px;">
								<a href="<?php echo base_url(); ?>admin/transaction/workorder/<?php echo $menuid; ?>" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
								<button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
							</td>
						</tr>
					</tfoot>
				<?php
} else {
                echo '
					<thead>
						<tr>
							<th>No.</th>
							<th>Code</th>
							<th>Description</th>
							<th>Requested</th>
							<th>Actual</th>
							<th>Return</th>
							<th>Unit Price</th>
							<th>Gross Ammount</th>
						</tr>
					</thead>
					<tbody>
				';
                $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$number'");
                $ID              = $get_id_purchase[0]->ID;

                $data_purchase_detail = $this->master_model->data_purchase_detail($ID, 'Material');

                $total = 0;
                for ($a = 0; $a < count($data_purchase_detail); $a++) {
                    $b     = $a + 1;
                    $total = $total + $data_purchase_detail[$a]->gross_ammount;
                    echo '
						<tr>
							<td>
								' . $b . '
							</td>
							<td>
								<input type="text" name="code_material[]" list="code" placeholder="Code" class="form-control" style="width:100px" required="required" value="' . $data_purchase_detail[$a]->code_inventory . '"/>

							</td>
							<td>
								<input type="text" name="desc_material[]" list="code" placeholder="Code" class="form-control" style="width:250px" required="required" value="' . $data_purchase_detail[$a]->name_inventory . '"/>
							</td>
							<td align="center">
								0
							</td>
							<td align="center">
								0
							</td>
							<td align="center">
								0
							</td>
							<td align="center">
								' . str_replace(',', '.', number_format($data_purchase_detail[$a]->price)) . '
							</td>
							<td align="right">
								' . str_replace(',', '.', number_format($data_purchase_detail[$a]->gross_ammount)) . '
							</td>
						</tr>
					';
                }
                ?>
					</tbody>
					<tfoot>
						<tr>
							<td colspan="7">
                            	<!--
								<a class="btn btn-primary addOption loading_btn" onClick="clickME()" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing">
									Add Row
								</a>
								<script>
									$('.loading_btn').on('click', function()
									{
										var $this = $(this);
										$this.button('loading');
										setTimeout(function()
										{
										   $this.button('reset');
										}, 500);
									});
								</script>
								<script>
									$(document).ready(function()
									{
										var inc = 1;
										$(".addOption").on('click',function()
										{
											inc=inc+1;
											$("#row3"+inc+"").show();
										});
									});
								</script>
                                -->
								<span class="pull-right">
									<strong>Total :</strong>
								</span>
							</td>
							<td align="right">
								<strong><?php echo str_replace(',', '.', number_format($total)); ?></strong>
                                <input type="hidden" name="total_material" value="<?php echo $total; ?>" />
							</td>
						</tr>
						<tr>
							<td colspan="4">
								<strong>Note : </strong>
								<input type="text" name="note_material" class="form-control" />
							</td>
							<td colspan="4" valign="middle">
								<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save" style="margin-top:10px;">
								<a href="<?php echo base_url(); ?>admin/transaction/workorder/<?php echo $menuid; ?>" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
								<button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
							</td>
						</tr>
					</tfoot>
				<?php
}
        }
    }

    public function purchase_get_service($menuid)
    {
        $number = $this->input->post('number');

        $check_po = $this->master_model->mst_check('ts_purchase', 'purchase_no', $number);

        if ($check_po == false) {
            echo '
				<thead>
					<tr>
						<th>No.</th>
						<th>Code</th>
						<th>Description</th>
						<th>Schedule Date</th>
						<th>Target Date</th>
						<th>Start Date</th>
						<th>End Date</th>
						<th>Requested</th>
						<th>Pending</th>
						<th>Process</th>
						<th>Done</th>
						<th>Bad</th>
						<th>Unit Price</th>
						<th>Gross Ammount</th>
					</tr>
				</thead>
				<tbody>
				<tr>
					<td colspan="14">
						No data available in table
					</td>
				</tr>
				</tbody>
			';
        } else {
            $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$number'");
            $ID              = $get_id_purchase[0]->ID;

            $check_purchase = $this->master_model->check_purchase($ID, 'Service');

            //$check_po=$this->master_model->mst_check('ts_purchase', 'purchase_no', $number);

            if ($check_purchase == false) {
                echo '
					<thead>
						<tr>
							<th>No.</th>
							<th>Code</th>
							<th>Description</th>
							<th>Schedule Date</th>
							<th>Target Date</th>
							<th>Start Date</th>
							<th>End Date</th>
							<th>Requested</th>
							<th>Pending</th>
							<th>Process</th>
							<th>Done</th>
							<th>Bad</th>
							<th>Unit Price</th>
							<th>Gross Ammount</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="14">
								No data available in table
								<script>
									/*
									var x = document.getElementById("snackbar2")
									x.className = "show";
									setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
									*/
								</script>
							</td>
						</tr>
					</tbody>
				';
                ?>
					<tfoot>
						<tr>
                            <td colspan="5">
                                <strong>Note : </strong>
                                <input type="text" class="form-control" />
                            </td>
                            <td colspan="9" valign="middle">
                                <input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save" style="margin-top:10px;">
                                <a href="<?php echo base_url(); ?>admin/transaction/workorder/<?php echo $menuid; ?>" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
                                <button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
                            </td>
                        </tr>
					</tfoot>
				<?php
} else {
                echo '
					<thead>
						<tr>
							<th>No.</th>
							<th>Code</th>
							<th>Description</th>
							<th>Schedule Date</th>
							<th>Target Date</th>
							<th>Start Date</th>
							<th>End Date</th>
							<th>Requested</th>
							<th>Pending</th>
							<th>Process</th>
							<th>Done</th>
							<th>Bad</th>
							<th>Unit Price</th>
							<th>Gross Ammount</th>
						</tr>
					</thead>
					<tbody>
					';
                $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$number'");
                $ID              = $get_id_purchase[0]->ID;

                $data_purchase_detail = $this->master_model->data_purchase_detail($ID, 'Service');

                $total = 0;
                for ($a = 0; $a < count($data_purchase_detail); $a++) {
                    $b     = $a + 1;
                    $total = $total + $data_purchase_detail[$a]->gross_ammount;
                    echo '
							<tr>
								<td>
									' . $b . '
								</td>
								<td>
									<input type="text" name="code[]" list="code" placeholder="Code" class="form-control" style="width:100px" required="required" value="' . $data_purchase_detail[$a]->code_inventory . '"/>
								</td>
								<td>
									<input type="text" name="desc[]" list="code" placeholder="Code" class="form-control" style="width:250px" required="required" value="' . $data_purchase_detail[$a]->name_inventory . '"/>
								</td>
								<td>
									<input type="text" placeholder="Schedule" id="datepicker3" class="form-control" style="width:100px" required="required"/>
								</td>
								<td>
									<input type="text" placeholder="Target" id="datepicker2" class="form-control" style="width:100px" required="required"/>
								</td>
								<td>
									-
								</td>
								<td>
									-
								</td>

								<td>
									0
								</td>

								<td>
									0
								</td>

								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									' . str_replace(',', '.', number_format($data_purchase_detail[$a]->gross_ammount)) . '
								</td>
							</tr>
						';
                }

                for ($a = 1; $a < 10; $a++) {
                    $b = $a + 1;
                    echo '
							<tr id="row2' . $b . '" style="display:none">
								<td>
									' . $b . '
								</td>
								<td>
									<input type="text" list="code" placeholder="Code" id="tags" class="form-control" style="width:100px" required="required"/>
								</td>
								<td>
									<input type="text" name="code" list="name" placeholder="Description" id="name_product" class="form-control" style="width:250px"/>
								</td>
								<td>
									<input type="text" list="code" placeholder="Schedule" id="datepicker" class="form-control" style="width:100px" required="required"/>
								</td>
								<td>
									<input type="text" list="code" placeholder="Target" id="tags" class="form-control" style="width:100px" required="required"/>
								</td>
								<td>
									-
								</td>
								<td>
									-
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
								<td>
									0
								</td>
							</tr>
						';
                }
                ?>
					</tbody>
					<tfoot>
						<tr>
                            <td colspan="13">
                                <a class="btn btn-primary add_row loading_btn pull-left" onClick="clickME()" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing">
                                    Add Row
                                </a>
                                <script>
                                    $('.loading_btn').on('click', function()
                                    {
                                        var $this = $(this);
                                        $this.button('loading');
                                        setTimeout(function()
                                        {
                                           $this.button('reset');
                                        }, 500);
                                    });
                                </script>
                                <script>
                                    $(document).ready(function()
                                    {
                                        var inc = 1;
                                        $(".add_row").on('click',function()
                                        {
                                            inc=inc+1;
                                            $("#row2"+inc+"").show();
                                        });
                                    });
                                </script>
                                <span class="pull-right">
                                    <strong>Total :</strong>
                                </span>
                            </td>
                            <td>
                                <strong><?php echo str_replace(',', '.', number_format($total)); ?></strong>
                            </td>

                        </tr>
                        <tr>
                            <td colspan="5">
                                <strong>Note : </strong>
                                <input type="text" class="form-control" />
                            </td>
                            <td colspan="9" valign="middle">
                                <input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save" style="margin-top:10px;">
                                <a href="<?php echo base_url(); ?>admin/transaction/workorder/<?php echo $menuid; ?>" class="btn btn-danger pull-right" style="margin:10px 5px 0 0;">Cancel</a>
                                <button type="reset" class="btn btn-default pull-right" style="margin:10px 5px 0 0;">Reset</button>
                            </td>
                        </tr>
					</tfoot>
				<?php
}
        }
    }

    public function insert_workorder($menuid)
    {
        // print_array($this->input->post());
        // exit;

        $id_image = $this->input->post('id_image');

        $id_workorder = $this->master_model->mst_last_id('ts_workorder');

        for ($i = 0; $i < count($id_image); $i++) {
            $j          = $i + 1;
            $uploadPost = $_FILES;
            if ($uploadPost['ImageUpload' . $j]['name'] != '') {
                $ID = $this->master_model->mst_last_id('ts_workorder_design');

                $Image      = $ID . '.' . substr($_FILES['ImageUpload' . $j]['name'], strrpos($_FILES['ImageUpload' . $j]['name'], '.') + 1);
                $Image_temp = $ID . '_temp.' . substr($_FILES['ImageUpload' . $j]['name'], strrpos($_FILES['ImageUpload' . $j]['name'], '.') + 1);

                $config['file_name']     = $ID . '_temp';
                $config['upload_path']   = './uploads/design/';
                $config['allowed_types'] = 'gif|jpg|png|';
                $config['max_size']      = '2000';
                $config['max_width']     = '1500';
                $config['max_height']    = '1500';
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('ImageUpload' . $j)) {
                    $data  = array('error' => $this->upload->display_errors('', ''));
                    $error = $data['error'];
                    echo '<script language="javascript">alert("' . $error . '!");window.history.go(-1);</script>';
                    exit();
                } else {
                    $fileImage_temp = './uploads/design/' . $Image_temp;
                    if (file_exists($fileImage_temp)) {unlink($fileImage_temp);}
                    $fileImage = './uploads/design/' . $Image;
                    if (file_exists($fileImage) && $Image != '') {unlink($fileImage);}
                    $config['file_name'] = $ID;

                    $this->upload->initialize($config);

                    $this->upload->do_upload('ImageUpload' . $j);
                }

                $data = array
                    (
                    'ID'           => $ID,
                    'id_workorder' => $id_workorder,
                    'image'        => $Image,
                    'sort'         => $ID,
                );
                $this->db->insert('ts_workorder_design', $data);
            }
        }

        $id_admin      = $this->session->userdata('id_admin');
        $schedule_date = $this->input->post('schedule_date');
        $target_date   = $this->input->post('target_date');

        $wo = $this->master_model->wo();

        if ($schedule_date == '') {
            $date_schedule = '0000-00-00';
        } else {
            $date_schedule = date('Y-m-d', strtotime($schedule_date));
        }

        if ($target_date == '') {
            $date_target = '0000-00-00';
        } else {
            $date_target = date('Y-m-d', strtotime($target_date));
        }
        $data_workorder = array
            (
            'ID'             => $id_workorder,
            'workorder_no'   => $wo,
            'date_schedule'  => $date_schedule,
            'date_target'    => $date_target,
            'product_code'   => $this->input->post('product_code'),
            'finish_good'    => $this->input->post('finish_good'),
            'sales_order_no' => $this->input->post('sales_order_no'),
            'supplier_code'  => $this->input->post('supplier_code'),
            'supplier_name'  => $this->input->post('supplier_name'),
            'target_pcs'     => $this->input->post('target_pcs'),
            'cost'           => $this->input->post('cost'),
            'finish'         => 0,
            'total_material' => 0,
            'total_labour'   => 0,
            'grandtotal'     => $this->input->post('cost'),
            'id_admin'       => $id_admin,
            'status'         => 'Pending',
            'note_material'  => $this->input->post('note_material'),
            'note_labour'    => $this->input->post('note_labour'),
            'sort'           => $id_workorder,
        );
        $this->db->insert('ts_workorder', $data_workorder);

        $code_material = $this->input->post('code_material');
        // $item_material = $this->input->post('item_material');
        $plan          = $this->input->post('plan');
        for ($a = 0; $a < count($code_material); $a++) {
            if ($code_material[$a] != '') {
                $id_material        = $this->master_model->mst_last_id('ts_workorder_material');
                $get_id_inventory   = $this->master_model->select_in('ms_inventory', 'code, ID', "WHERE code='$code_material[$a]'");
                $data_material = array
                    (
                    'ID'             => $id_material,
                    'id_workorder'   => $id_workorder,
                    'id_inventory'   => $get_id_inventory[0]->ID,
                    // 'name_inventory' => $item_material[$a],
                    'plan'           => $plan[$a],
                    'sort'           => $id_material,
                );
                $this->db->insert('ts_workorder_material', $data_material);

                // print_r($data_material);die;
            }
        }

        $code_labour          = $this->input->post('code_labour');
        $supplier_code_labour = $this->input->post('supplier_code_labour');
        $item_labour          = $this->input->post('item_labour');
        $schedule             = $this->input->post('schedule');
        $target               = $this->input->post('target');
        $price                = $this->input->post('price');

        for ($b = 0; $b < count($code_labour); $b++) {
            if ($schedule[$b] == '') {
                $schedule[$b] = '0000-00-00';
            } else {
                $schedule[$b] = date('Y-m-d', strtotime($schedule[$b]));
            }

            if ($target[$b] == '') {
                $target[$b] = '0000-00-00';
            } else {
                $target[$b] = date('Y-m-d', strtotime($target[$b]));
            }

            if ($price[$b] == '') {
                $price[$b] = '0';
            } else {
                $price[$b] = $price[$b];
            }

            if ($code_labour[$b] != '') {
                $id_labour   = $this->master_model->mst_last_id('ts_workorder_labour');
                $data_labour = array
                    (
                    'ID'             => $id_labour,
                    'id_workorder'   => $id_workorder,
                    'code_inventory' => $code_labour[$b],
                    'code_supplier'  => $supplier_code_labour[$b],
                    'name_inventory' => $item_labour[$b],
                    'schedule_date'  => $schedule[$b],
                    'target_date'    => $target[$b],
                    'price'          => $price[$b],
                    'sort'           => $id_labour,
                );
                $this->db->insert('ts_workorder_labour', $data_labour);
            }
        }

        $code = substr($this->input->post('finish_good'), 0, 10);

        //Set [on production] to website babykenaz
        // $curl = curl_init();
        //   curl_setopt_array($curl, array(
        //     CURLOPT_URL            => "https://babykenaz.com/api/product_models/status?code=$code&status=On%20Production",
        //     CURLOPT_RETURNTRANSFER => true,
        //     CURLOPT_TIMEOUT        => 30,
        //     CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        //     CURLOPT_CUSTOMREQUEST  => "GET",
        //     CURLOPT_HTTPHEADER     => array(
        //       "cache-control: no-cache"
        //     ),
        //   ));
        //   $response = curl_exec($curl);
        //   $err      = curl_error($curl);
        //   curl_close($curl);
        // $response = json_decode($response, true);
        //End set [on production] to website babykenaz

        redirect('admin/transaction/workorder/' . $menuid);
    }

    public function reopen_material($menuid, $id_workorder, $id_material)
    {
        $data_material = array
            (
            'status' => 'Process',
        );
        $this->db->where('ID', $id_material);
        $this->db->update('ts_workorder_material', $data_material);

        $data_inventory1 = $this->master_model->select_in('ts_workorder', 'ID, workorder_no', "WHERE ID=$id_workorder");
        $workorder_no    = $data_inventory1[0]->workorder_no;

        //$data_inventory=$this->master_model->select_in('ts_workorder_material','ID, code_inventory, name_inventory, actual,id_jurnal_workorder, price',"WHERE ID=$id_material");
        $data_inventory = $this->master_model->select_in('ts_workorder_material', 'ID, code_inventory, name_inventory, actual, price, id_jurnal_workorder', "WHERE ID=$id_material");

        $id_workorder_detail = $data_inventory[0]->ID;
        $code_inventory      = $data_inventory[0]->code_inventory;
        $id_jurnal1          = $data_inventory[0]->id_jurnal_workorder;

        $data_stock_detail = $this->master_model->select_in('ts_stock_detail', 'ID, id_purchase_invoice, qty_waste, price', "WHERE id_workorder_detail='$id_material'");

        $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/work_order/delete_work_order");
        curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/Warehouse_transfers/delete_warehouse_transfers");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            http_build_query(array('date' => date("d/m/Y"),
                // 'id_workorder' =>$id_workorder,

                'id'                          => $id_jurnal1,

            )));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $error_msg     = curl_error($ch);
        //       //print_r($error_msg);
        //       // curl_close($ch);
        //       //print_r($server_output);

        $this->session->set_flashdata('message', $server_output);
        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);
    }

    public function close_material_jurnal($menuid, $id_workorder, $id_material)
    {
        ini_set('display_errors', '1');
        ini_set('display_startup_errors', '1');
        error_reporting(E_ALL);
//echo "string";
        //new code
        $data_inventory1 = $this->master_model->select_in('ts_workorder', 'ID, workorder_no, product_code, finish_good, date_target', "WHERE ID=$id_workorder");
        $workorder_no    = $data_inventory1[0]->workorder_no;
        $product_code    = $data_inventory1[0]->product_code;
        $finish_good     = $data_inventory1[0]->finish_good;
        $date_target     = $data_inventory1[0]->date_target;
        $data_inventory  = $this->master_model->select_in('ts_workorder_material a left join ms_inventory b ON a.code_inventory = b.code', 'b.name, a.ID, a.code_inventory, a.name_inventory, a.actual, a.price, a.id_jurnal_workorder', "WHERE a.ID=$id_material");
        //end new code

        //$data_inventory=$this->master_model->select_in('ts_workorder_material','ID, code_inventory',"WHERE ID=$id_material");

        $id_workorder_detail = $data_inventory[0]->ID;
        $code_inventory      = $data_inventory[0]->code_inventory;
        //new code
        $price              = $data_inventory[0]->price;
        $name_inventory     = $data_inventory[0]->name;
        $actual             = $data_inventory[0]->actual;
        $id_jurnal_material = $data_inventory[0]->id_jurnal_workorder;
        //end code

        if ($id_jurnal_material != null) {
            // hapus transfer gudang
            $chd = curl_init();
            curl_setopt($chd, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/Warehouse_transfers/delete_warehouse_transfers");
            curl_setopt($chd, CURLOPT_POST, 1);
            curl_setopt($chd, CURLOPT_POSTFIELDS,
                http_build_query(array('date' => date("d/m/Y"),
                    'id'                          => $id_jurnal_material,
                )));
            // Receive server response ...
            curl_setopt($chd, CURLOPT_RETURNTRANSFER, true);
            $server_output = curl_exec($chd);
            $error_msg     = curl_error($chd);
        }

        //$data_stock_detail=$this->master_model->select_in('ts_stock_detail','ID, id_purchase_invoice, qty_waste, price',"WHERE id_workorder_detail='$id_material'");

        //new code
        $data_stock_detail  = $this->master_model->select_in('ts_stock_detail', 'ID, id_purchase_invoice, qty_waste, price, barcode', "WHERE id_workorder_detail='$id_material'");
        $stock_detail_price = $data_stock_detail[0]->price;
        //mencari data supplier /vendors
        $stock_id_purchase = $data_stock_detail[0]->id_purchase_invoice;
        $data_supplier_cek = $this->master_model->select_in('ts_purchase_invoice', 'supplier_code', "WHERE ID='$stock_id_purchase'");

        $nilai_supplier  = $this->master_model->select_in('ms_inventory', 'code, name, type', "WHERE code='$code_inventory'");
        $nilai_supplier1 = $nilai_supplier[0]->name;
        $nilai_supplier2 = $nilai_supplier[0]->type;

        $id_category = 931837;
        //end code

        //new code
        ///input data matrial add product ke jurnal
        $data_jurnal[] = array(
            'name'         => $name_inventory,
            'unit_name'    => $name_inventory,
            'sell_price'   => 0,
            'code'         => $code_inventory,
            'buy_price'    => $stock_detail_price,
            'desckripsi'   => $name_inventory,
            'code_product' => $code_inventory,
            'type'         => $nilai_supplier2,
            'id_category'  => $id_category,

            'ip_id'        => $_SERVER['SERVER_ADDR'],
            'auth_key'     => 'test',
            'password'     => 'dgasgadsg@dfgsdfgsdf3535353',

        );
        // echo "<pre>";
        // print_r($data_jurnal);
        // die;
        $response           = $this->jurnal->addProducts($data_jurnal);
        @$id_product_jurnal = $response[0]->data->product->id;
        $id_jurnal_product  = array
            (
            'id_product_jurnal' => $id_product_jurnal,
        );

        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $id_jurnal_product);
        //echo "<pre>";

        // print_r([$data_jurnal, $response, $id_product_jurnal]);
        //          die();

        // $data = array('date' => date("d/m/Y"),
        //                                        // 'id_workorder' =>$id_workorder,
        //                                        'workorder_no'=>$workorder_no,
        //                                        'code' => '/'.$code_inventory,
        //                                        'name_inventory' =>$name_inventory,
        //                                        'actual'=>$actual,
        //                                        'tags'=>$id_material,
        //                                        'memo'=>$id_workorder,
        //                                        'kode'=>$workorder_no.'/'.$code_inventory,
        //                                        'price'=>$price,

        //                                    );
        $data1 = array( //'date' => date("d/m/Y"),
            // 'id_workorder' =>$id_workorder,
            'date'          => $date_target,
            'memo'          => $workorder_no . ' / ' . $product_code . ' / ' . $finish_good,
            'warehouse_old' => 'Bahan Baku',
            'warehouse_new' => 'Gudang Produksi',
            'name_product'  => $name_inventory,
            'qty'           => $actual,
            'price'         => $price,

        );
        // print_r($data1);
        // die();
        // konversi ke wip dah tdk perlu
        //$responseInv = $this->jurnal->addWorkorder($data);
        $responseInv = $this->jurnal->transferWarehouseMaterial($data1);
        // echo "<pre>";
        // print_r($responseInv);
        //      die();
        if ($responseInv->success == true) {
            // ini sukses masuk jurnal
            $id5 = $responseInv->data->warehouse_transfer->id;
            //$id5 = $responseInv->data->stock_adjustment->id;

            $id_jurnal_workorder = array
                (
                'id_jurnal_workorder' => $id5,
            );
            $this->db->where('ID', $id_material);
            $this->db->update('ts_workorder_material', $id_jurnal_workorder);

            $this->session->set_flashdata('message', '<div class="alert alert-success">Successfully processed</div>');
        } else {
            // gagal masuk jurnal
            foreach ($responseInv->pesan as $key => $text) {
                $this->session->set_flashdata('message', '<div class="alert alert-danger">' . $text . '</div>');
            }
        }

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);

    }

    public function close_material($menuid, $id_workorder, $id_material)
    {
        $data_material = array
            (
            'status' => 'Close',
        );
        $this->db->where('ID', $id_material);
        $this->db->update('ts_workorder_material', $data_material);
        //new code
        $data_inventory1 = $this->master_model->select_in('ts_workorder', 'ID, workorder_no, product_code, finish_good', "WHERE ID=$id_workorder");
        $workorder_no    = $data_inventory1[0]->workorder_no;
        $product_code    = $data_inventory1[0]->product_code;
        $finish_good     = $data_inventory1[0]->finish_good;

        $data_inventory = $this->master_model->select_in('ts_workorder_material', 'ID, code_inventory, name_inventory, actual, price', "WHERE ID=$id_material");
        //end new code

        //$data_inventory=$this->master_model->select_in('ts_workorder_material','ID, code_inventory',"WHERE ID=$id_material");

        $id_workorder_detail = $data_inventory[0]->ID;
        $code_inventory      = $data_inventory[0]->code_inventory;
        //new code
        $price          = $data_inventory[0]->price;
        $name_inventory = $data_inventory[0]->name_inventory;
        $actual         = $data_inventory[0]->actual;
        //end code

        //$data_stock_detail=$this->master_model->select_in('ts_stock_detail','ID, id_purchase_invoice, qty_waste, price',"WHERE id_workorder_detail='$id_material'");

        //new code
        $data_stock_detail  = $this->master_model->select_in('ts_stock_detail', 'ID, id_purchase_invoice, qty_waste, price, barcode', "WHERE id_workorder_detail='$id_material'");
        $stock_detail_price = $data_stock_detail[0]->price;
        //mencari data supplier /vendors
        $stock_id_purchase = $data_stock_detail[0]->id_purchase_invoice;
        $data_supplier_cek = $this->master_model->select_in('ts_purchase_invoice', 'supplier_code', "WHERE ID='$stock_id_purchase'");

        $nilai_supplier  = $this->master_model->select_in('ms_inventory', 'code, name, type', "WHERE code='$code_inventory'");
        $nilai_supplier1 = $nilai_supplier[0]->name;
        $nilai_supplier2 = $nilai_supplier[0]->type;

        $id_category = 931837;
        //end code

        for ($a = 0; $a < count($data_stock_detail); $a++) {
            $id_before = $data_stock_detail[$a]->ID;
            //$id_purchase_invoice=$data_stock_detail[$a]->id_purchase_invoice;
            $barcode_before = $data_stock_detail[$a]->barcode;
            $price          = $data_stock_detail[$a]->price;
            $qty_waste      = $data_stock_detail[$a]->qty_waste;

            //echo $qty_waste;

            //if($qty_waste<>0.00)
            if ($qty_waste != 0.00) {
                $id_stock_detail          = $this->master_model->mst_last_id('ts_stock_detail');
                $data_insert_stock_detail = array
                    (
                    'ID'             => $id_stock_detail,
                    //'id_workorder_detail'=>$id_workorder_detail,
                    'code_inventory' => $code_inventory,
                    'id_before'      => $id_before,
                    'price'          => $price,
                    'in_qty'         => $qty_waste,
                    'barcode'        => $barcode_before,
                );
                $this->db->insert('ts_stock_detail', $data_insert_stock_detail);

                //new code
                $barcode_end   = $barcode_before . '-x';
                $data_material = array
                    (
                    'barcode' => $barcode_end,
                );
                //         print_r($data_material);
                // die();
                $this->db->where('ID', $id_before);
                $this->db->update('ts_stock_detail', $data_material);
                //end code
            }
        }

// redirect('admin/transaction/production_insert/'.$menuid.'/'.$id_workorder);
        //die;
        //new code
        ///input data matrial add product ke jurnal
        $data_jurnal[] = array(
            'name'         => $name_inventory,
            'unit_name'    => $name_inventory,
            'sell_price'   => 0,
            'code'         => $code_inventory,
            'buy_price'    => $stock_detail_price,
            'desckripsi'   => $name_inventory,
            'code_product' => $code_inventory,
            'type'         => $nilai_supplier2,
            'id_category'  => $id_category,

            'ip_id'        => $_SERVER['SERVER_ADDR'],
            'auth_key'     => 'test',
            'password'     => 'dgasgadsg@dfgsdfgsdf3535353',

        );
        // echo "<pre>";
        // print_r($data_jurnal);
        // die;
        $response           = $this->jurnal->addProducts($data_jurnal);
        @$id_product_jurnal = $response[0]->data->product->id;
        $id_jurnal_product  = array
            (
            'id_product_jurnal' => $id_product_jurnal,
        );

        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $id_jurnal_product);
        //echo "<pre>";

        // print_r([$data_jurnal, $response, $id_product_jurnal]);
        //          die();

        // $data = array('date' => date("d/m/Y"),
        //                                        // 'id_workorder' =>$id_workorder,
        //                                        'workorder_no'=>$workorder_no,
        //                                        'code' => '/'.$code_inventory,
        //                                        'name_inventory' =>$name_inventory,
        //                                        'actual'=>$actual,
        //                                        'tags'=>$id_material,
        //                                        'memo'=>$id_workorder,
        //                                        'kode'=>$workorder_no.'/'.$code_inventory,
        //                                        'price'=>$price,

        //                                    );
        $data1 = array('date' => date("d/m/Y"),
            // 'id_workorder' =>$id_workorder,
            'memo'                => $workorder_no . ' / ' . $product_code . ' / ' . $finish_good,
            'warehouse_old'       => 'Bahan Baku',
            'warehouse_new'       => 'Gudang Produksi',
            'name_product'        => $name_inventory,
            'qty'                 => $actual,
            'price'               => $price,

        );
        // print_r($data);
        // die();
        // konversi ke wip dah tdk perlu
        //$responseInv = $this->jurnal->addWorkorder($data);
        $responseInv = $this->jurnal->transferWarehouseMaterial($data1);
//         echo "<pre>";
        //         print_r($responseInv);
        //       die();
        if ($responseInv->success == true) {
            // ini sukses masuk jurnal
            $id5 = $responseInv->data->warehouse_transfer->id;
            //$id5 = $responseInv->data->stock_adjustment->id;

            $id_jurnal_workorder = array
                (
                'id_jurnal_workorder' => $id5,
            );
            $this->db->where('ID', $id_material);
            $this->db->update('ts_workorder_material', $id_jurnal_workorder);

            $this->session->set_flashdata('message', '<div class="alert alert-success">Successfully processed</div>');
        } else {
            // gagal masuk jurnal
            foreach ($responseInv->pesan as $key => $text) {
                $this->session->set_flashdata('message', '<div class="alert alert-success">' . $text . '</div>');
            }
        }

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);

    }

    public function delete_workorder($menuid, $ID)
    {
        $this->db->where('ID', $ID);
        $this->db->delete('ts_workorder');

        $this->db->where('id_workorder', $ID);
        $this->db->delete('ts_workorder_material');

        $this->db->where('id_workorder', $ID);
        $this->db->delete('ts_workorder_labour');

        $this->db->where('id_workorder', $ID);
        $this->db->delete('ts_workorder_design');

        $data_image = $this->master_model->select_in('ts_workorder_design', 'image', "WHERE id_workorder=$ID");

        for ($a = 0; $a < count($data_image); $a++) {
            $image = $data_image[$a]->image;

            $fileImage = './uploads/design/' . $image;
            if (file_exists($fileImage) && $image != '') {unlink($fileImage);}
        }

        redirect('admin/transaction/workorder/' . $menuid);
    }

    public function delete_stock($menuid, $ID)
    {
        $get_purchase_no = $this->master_model->select_in('ts_purchase_invoice', 'purchase_no', "WHERE ID=$ID");
        $purchase_no     = $get_purchase_no[0]->purchase_no;

        $get_id_purchase = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$purchase_no'");
        $id_purchase     = $get_id_purchase[0]->ID;

        $data_purchase_invoice = $this->master_model->select_in('ts_purchase_invoice', 'ID, id_jurnal_invoice', "WHERE ID='$ID'");
        $id_purchase_invoice   = $data_purchase_invoice[0]->ID;

        // print_r($id_jurnal_invoice);
        // die();
        $count_purchase_invoice = count($data_purchase_invoice);

        //echo "<pre>";
        // print_r([$ID, $purchase_no, $id_purchase, $data_purchase_invoice, $count_purchase_invoice]);
        // die();

        //delete kejurnal

        $id_jurnal_invoice = $data_purchase_invoice[0]->id_jurnal_invoice;
        //star new code
        $ch = curl_init();

        	curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/purchase_invoice/delete_workorder_labour");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            http_build_query(array('date' => date("d/m/Y"),
                'id'                          => $id_jurnal_invoice,
                'ip_id'        => $_SERVER['SERVER_ADDR'],
                'auth_key'     => 'test',
                'password'     => 'dgasgadsg@dfgsdfgsdf3535353',
            )));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $error_msg     = curl_error($ch);
        // print_r($error_msg);
        // die();
        /*
        $update_purchase=array
        (
        'status'=>'Pending',
        );
        $this->db->where('ID', $id_purchase);
        $this->db->update('ts_purchase', $update_purchase);
         */
        //update ts_purchase detail
        $data_update_ts_purchase_detail = [];
         //update ms_inventory
        $update_ms_inventory = [];
        //delete stock_log_detail
        $delete_stock_log_detail = [];
        $data_ts_stock_detail = $this->master_model->select_in('ts_stock_detail', 'ID, in_qty, id_purchase_detail, id_inventory', "WHERE id_purchase_invoice=$ID");
        foreach ($data_ts_stock_detail as $detail) {               
                $ID_ts_stock_detail   = $detail->id_purchase_detail;
                $code_inventory       = $detail->id_inventory;
                $ID_Log               = $detail->ID;

                $delete_stock_log_detail [] = $detail->ID;

             $data_purchase_detail = $this->master_model->select_in('ts_purchase_detail', 'ID, in_qty, id_inventory', "WHERE ID=$ID_ts_stock_detail");
            foreach ($data_purchase_detail as $detail1) {
                $in_qty_ts_stock_detail = $detail1->in_qty - $detail->in_qty;

                $update_ms_inventory [] = [ 'ID'          => $code_inventory,
                                            'stock_balance' => $detail1->in_qty - $detail->in_qty,
                                            ];

                if ($in_qty_ts_stock_detail == 000.00) {               
                    $status = 'Pending';                
                    } else {                   
                        $status = 'Process';                
                }

              $data_update_ts_purchase_detail[] = [ 'ID'       => $detail->id_purchase_detail,
                                                    'in_qty'   => $detail1->in_qty - $detail->in_qty,
                                                    'status'   => $status
                                                    //'qty'      => $detail1->in_qty
                                                 ];
            }
       }
     
        // echo "<pre>";
        // //echo $ID.' '.$id_purchase_detail .' '.$in_qty;
            //print_r([$data_update_ts_purchase_detail, $update_ms_inventory,$delete_stock_log_detail]);
        //     exit;
       
         //die();
        $this->db->trans_start();

        if (count($data_update_ts_purchase_detail) > 0) {
            $this->db->update_batch('ts_purchase_detail', $data_update_ts_purchase_detail, 'ID');
        }
         if (count($update_ms_inventory) > 0) {
            $this->db->update_batch('ms_inventory', $update_ms_inventory, 'ID');
        }

        if (count($delete_stock_log_detail) > 0) {
                 $this->db->where_in('id_stock_detail', $delete_stock_log_detail);
                 $this->db->delete('stock_log_detail');
            // foreach ($delete_stock_log_detail as $id_detail) {
            //     $this->db->where_in('id_stock_detail', $id_detail);
            //      $this->db->delete('stock_log_detail');
            // }
             //$this->db->delete_batch('stock_log_detail', $delete_stock_log_detail, 'id_stock_detail');
            // foreach ($delete_stock_log_detail as $id_detail) {
            //     $this->Ts_trip_detail->where('id_stock_detail', $id_detail)->delete();
            // }
        }

        $update_ts_purchase = array 
        		(
        			'status' => 'Process',
        		);

        $this->db->where('ID', $id_purchase);
	    $this->db->update('ts_purchase', $update_ts_purchase);

        $this->db->where('id_purchase_invoice', @$ID);
        $this->db->delete('ts_stock_detail');

        $this->db->where('ID', $ID);
        $this->db->delete('ts_purchase_invoice');

        $this->db->trans_complete();
        if($this->db->trans_status() === false)
                       {
                       $this->session->set_flashdata('message', '<div class="alert alert-danger">Delete Failed</div>');
                        redirect('admin/transaction/stock/' . $menuid);
                    } else {
                      
                       // $this->session->set_flashdata('message', 'Delete Data Stock Success');   
                        redirect('admin/transaction/stock/' . $menuid .'/added');
                          //redirect('admin/trip');
            } 

        //redirect('admin/transaction/stock/' . $menuid);
    }

    public function update_code_inventory($menuid)
    {
        $data_stock_detail = $this->master_model->update_stock_detail();

        for ($a = 0; $a < count($data_stock_detail); $a++) {
            $id_material     = $data_stock_detail[$a]->id_material;
            $id_stock_detail = $data_stock_detail[$a]->id_stock_detail;

            $data_update = array
                (
                'id_workorder_detail' => $id_material,
            );
            $this->db->where('ID', $id_stock_detail);
            $this->db->update('ts_stock_detail', $data_update);
        }

        //print_array($data_stock_detail);
        //exit;
    }

    public function insert_stock($menuid)
    {

        $qty_p   = [];
        $harga_p = [];
        $name_p  = [];
        // print_array($this->input->post());
        // exit;

        $id_admin = $this->session->userdata('id_admin');

        $date = strtotime($this->input->post('date'));
        $date = date('Y-m-d', $date);

        $purchase_no = $this->input->post('purchase');

        $stock_no            = $this->master_model->stock_no();
        $purchase_invoice_no = $this->master_model->purchase_invoice_no();

        $supplier_code    = $this->input->post('supplier_code');
        $get_payment_term_oc = $this->master_model->select_in('ts_purchase', 'payment_term, status', "WHERE purchase_no='$purchase_no'");
        // echo "<pre>";
        // print_r(get_payment_term_oc);
        // die();
        $get_payment_term = $this->master_model->select_in('ms_supplier', 'ID, payment_term, status', "WHERE code='$supplier_code'");
        $id_category      = 931837;
        $ID               = $this->master_model->mst_last_id('ts_purchase_invoice');
        //CARI NAMA product
        $ID1 = $this->master_model->select_in('ts_purchase', 'ID', "WHERE purchase_no='$purchase_no'");
        //id purchase
        $ID2 = $ID1[0]->ID;

        //new code masukan data supplier ke jurnal
        $data_supplier = array('display_name' => $this->input->post('supplier_code'),
            'associate_company'                   => $this->input->post('supplier'),
            'billing_address'                     => $this->input->post('supplier_code'),
            'address'                             => 'alamat masih kosong',
            'phone'                               => '08129834',
            'mobile'                              => '0210432',
            'email'                               => 'day@gmail.com',

            'disable_max_credit_limit'            => false,

            'start_balance'                       => '21-04-2016',
            'opening_balance'                     => 'dxdiag',
            'no_npwp'                             => '000',
            'source'                              => 'source',
            'tax_no'                              => 'tax-no-1',
            'other_detail'                        => 'others',
            'custom_id'                           => $ID,
        );
        // $this->jurnal->use_json = false;
        		$response = $this->jurnal->addVendors($data_supplier);
        

        //data header
        $data = array(
            'ID'                  => $ID,
            'stock_no'            => $stock_no,
            'purchase_invoice_no' => $purchase_invoice_no,
            'purchase_no'         => $purchase_no,
            'date_in'             => $date,
            'type'                => $this->input->post('type'),
            'id_supplier'         => $get_payment_term[0]->ID,
            // 'supplier_code'       => $this->input->post('supplier_code'),
            // 'supplier_name'       => $this->input->post('supplier'),
            'ref_no'              => $this->input->post('ref_no'),
            'due'                 => empty($get_payment_term_oc[0]->payment_term) ? null : $get_payment_term_oc[0]->payment_term,
            'id_admin'            => $id_admin,
            'note'                => $this->input->post('note'),
            'sort'                => $ID,
        );
        
        //nilai header
        //buat dapet berpa lama pembayar
        // $data_edit=$this->master_model->mst_data_edit('ts_purchase_invoice',$ID);
        //        $payment_term=$data_edit[0]->due;

        // echo "<pre>";
        // print_r([$_POST,$data]);
        // die();

       			$this->db->insert('ts_purchase_invoice', $data);

        $check = $this->input->post('check');

        $qty          = $this->input->post('qty');
        $in_qty_total = $this->input->post('in_qty_total');
        $id_detail    = $this->input->post('id_detail');
        $order_qty    = $this->input->post('order_qty');

        $ammount         = 0;
        $total_qty       = 0;
        $total_order_qty = 0;
        for ($c = 0; $c < count($id_detail); $c++) {
            $id_detail_2 = $id_detail[$c];

            $order_qty_2 = $order_qty[$c];

            $get_price      = $this->master_model->select_in('ts_purchase_detail a left join ms_inventory b ON a.id_inventory=b.ID', 'a.price,  b.ID as id_inventory, b.code as code_inventory, b.name as name_inventory, a.in_qty', "WHERE a.ID=$id_detail_2");
             $in_qty          = $get_price[0]->in_qty;
            $price          = $get_price[0]->price;
            $code_inventory = $get_price[0]->code_inventory;
            $name_inventory = $get_price[0]->name_inventory;
            $get_inventory1 = $this->master_model->select_in('ms_inventory', 'id_category,name, type, stock_balance', "WHERE code='$code_inventory'");
            $id_category1   = $get_inventory1[0]->id_category;
            $stock_balance1 = $get_inventory1[0]->stock_balance;
            $stock_name1    = $get_inventory1[0]->name;

            $type           = $get_inventory1[0]->type;

            $get_inventory2 = $this->master_model->select_in('ms_inventory_category', 'name', "WHERE ID=$id_category1");
            //echo '<pre>';
            //print_r($get_inventory1[0]->type);

            $qty_string = str_replace('<span>', '', str_replace('</span>', '', $qty[$c]));

            //$string = substr($qty_string, 0, -2);
            $exp = explode(', ', $qty_string);
            //$data_array=array($exp);
            //data buat ke jurnal

            $data_jurnal[] = array(
                'name'         => $name_inventory,
                'unit_name'    => $type,
                'sell_price'   => $price,
                'code'         => $code_inventory,
                'buy_price'    => 0,
                'desckripsi'   => $code_inventory,
                'code_product' => $code_inventory,
                'type'         => $type,
                'id_category'  => $id_category,

                'ip_id'        => $_SERVER['SERVER_ADDR'],
                'auth_key'     => 'test',
                'password'     => 'dgasgadsg@dfgsdfgsdf3535353',

            );

            //echo '<pre>';
            $qty_total = 0;
            // $qty_p = [];
            // $harga_p = [];
            // $name_p = [];
            for ($f = 0; $f < count($exp); $f++) {
                $qty_total = $qty_total + $exp[$f];

                //$total_price=$total_price+$price_total;

                $id_stock_detail = $this->master_model->mst_last_id('ts_stock_detail');
                $id_log_detail = $this->master_model->mst_last_id('stock_log_detail');
                // if ($check[$c] != 0) {
                 if ($qty[$c] != 0) {
                 	//echo "string";
                	$qty_bal = $stock_balance1 + $exp[$f];
                    //data product
                    $data_stock_detail = array
                        (
                        'ID'                  => $id_stock_detail,
                        'id_purchase_invoice' => $ID,
                        'id_purchase_detail'  => $id_detail[$c],
                        'id_inventory'        => $get_price[$f]->id_inventory,
                        //'code_inventory'      => $get_price[0]->code_inventory,
                        'in_qty'              => $exp[$f],
                        'price'               => $get_price[0]->price,
                        // 'id_category'=>$get_inventory1[0]->id_category,
                        // 'name'=>$get_inventory2[0]->name,
                        // 'type'=>$get_inventory1[0]->type,
                        // 'item'=>$get_inventory1[0]->name
                    );

                                $this->db->insert('ts_stock_detail', $data_stock_detail);

                    $data_log_detail = array
                        (
                        'ID'                 => $id_log_detail,
                        'tanggal'            => $date,
                        'type'               => 0,
                        //'code_inventory'     => $get_price[0]->code_inventory,
                        'id_inventory'       => $get_price[$f]->id_inventory,
                        'id_purchase_detail' => $id_detail_2,
                        'id_stock_detail'    => $id_stock_detail,
                        'qty_in'             => $exp[$f],
                        'qty_bal'            => $qty_bal,
                         //'id_category'=>$stock_name1,
                        // 'name'=>$get_inventory2[0]->name,
                        // 'type'=>$get_inventory1[0]->type,
                        // 'item'=>$get_inventory1[0]->name
                    );
                                	$this->db->insert('stock_log_detail', $data_log_detail);
        							$data_ms_inventory = array
        							(
        							   'stock_balance' => $qty_bal,
        							);
        	                        $this->db->where('code', $get_price[0]->code_inventory);
        	                        $this->db->update('ms_inventory', $data_ms_inventory);

                    // echo '<pre>';
                    // print_r([$data_stock_detail,$data_log_detail, $get_price[0]->code_inventory, $data_ms_inventory ]);
                }

                $ammount_1   = $qty_total * $get_price[0]->price;
                $qty_total_2 = $qty_total;
            }
            if ($qty_total > 0) {
                $qty_p[]   = $qty_total;
                $harga_p[] = $get_price[0]->price;
                $name_p[]  = $get_inventory1[0]->name;
            }

            $ammount         = $ammount + $ammount_1;
            $total_qty       = $total_qty + $qty_total_2;
            $total_order_qty = $total_order_qty + $order_qty_2;
        }

        // echo '<pre>';
        // print_r([$data, $data_supplier, $_POST]);
        // die();
        // echo '<pre>';
        // // $unit_name = $get_inventory1[0]->type;
        // // echo $unit_name;
       // print_r($ammount);
       // die();
        //dd($harga_p);
        // print_r($qty_p);
        // die();

        $data_purchase_invoice = array
            (
            'ammount' => $ammount,
        );
	        $this->db->where('ID', $ID);
	        $this->db->update('ts_purchase_invoice', $data_purchase_invoice);

        if ($total_order_qty == $total_qty) {
            $status_purchase = 'Close';
        } else {
            $status_purchase = 'Process';
        }

        $data_purchase = array
            (
            'status' => $status_purchase,
        );
		        $this->db->where('purchase_no', $purchase_no);
		        $this->db->update('ts_purchase', $data_purchase);
        // print_r($data_purchase);
        // die
        $order_qty = $this->input->post('order_qty');

        for ($a = 0; $a < count($check); $a++) {
        	
            // if ($order_qty[$a] == $in_qty_total[$a]) {
        	 if ($order_qty[$a] == $qty[$a]) {
                $status = 'Done';
            } elseif ($qty[$a] == 0) {
                $status = 'Pending';
            } else {
                $status = 'Process';
            }

            //if ($qty[$a] != '') {
            if ($id_detail[$a] != '') {
                $data_detail = array
                    (
                    'in_qty' => $qty[$a] + $in_qty,
                    'status' => $status,
                );
                    //echo "string";
                   
		                $this->db->where('ID', $id_detail[$a]);
		                $this->db->update('ts_purchase_detail', $data_detail);
            }

             // echo "<pre>";
             //  print_r([$in_qty, $data_detail, $id_detail[$a],  $check[$a]]);
        }

        //echo "<pre>";
        // print_r($qty_total);
        // die();
        	           $response = $this->jurnal->addProducts($data_jurnal);
        //buat ambil id product
        @$id_product_jurnal = $response[0]->data->product->id;
        $id_jurnal_product  = array
            (
            'id_product_jurnal' => $id_product_jurnal,
        );

			        $this->db->where('ID', $ID);
			        $this->db->update('ts_workorder', $id_jurnal_product);
        // echo "<pre>";

        // print_r([$data_jurnal, $response, $id_product_jurnal]);
        //          die();
        $jum_sukses = 0;
        $jum_gagal  = 0;
        foreach ($response as $key => $resjurnal) {
            if ($resjurnal->success == true) {
                // ini sukses masuk jurnal
                //$id = $response->data->product->id;
                $jum_sukses++;
            } else {
                // gagal masuk jurnal
                // $id = $response->pesan;
                $jum_gagal++;
            }
        }
        $this->session->set_flashdata('message', 'data produk berhasil masuk = ' . $jum_sukses . ' data gagal = ' . $jum_gagal);

        //input data invoice ke jurnal
        $data_jurnal_invoice = array(
            'id_detail'           => $this->input->post('id_detail'),
            'check'               => $check,
            'unit_name'           => $this->input->post('type'),
            'sell_price'          => $this->input->post('sort'),
            'code'                => $this->input->post('code'),
            'buy_price'           => $this->input->post('last_cost'),
            'desckripsi'          => $this->input->post('note'),
            //'code_product'        => $this->input->post('code'),
            'code_product'        => $code_inventory,
            'discont'             => '0',

            'stock_no'            => $stock_no,
            'ID'                  => $ID,

            'purchase_invoice_no' => $purchase_invoice_no,

            'qty'                 => $qty_p,
            'price'               => $harga_p,
            'name'                => $name_p,

            'purchase_no'         => $purchase_no,
            'date_in'             => $date,
            'supplier_name'       => $this->input->post('supplier'),
            'due'                 => $get_payment_term_oc[0]->payment_term,
            'note'                => $this->input->post('note'),
            'type'                => $this->input->post('type'),

            'supplier_code'       => $this->input->post('supplier_code'),
            'stock_no'            => $stock_no,
            'ref_no'              => $this->input->post('ref_no'),

            'id_admin'            => $id_admin,
            'sort'                => $ID,

            'status'              => $get_payment_term[0]->status,

        );
        // echo "<pre>";

        // print_r([$data_jurnal_invoice, $_POST()]);
        //          die();
        // if ($qty_total > 0) {
        if ($qty_p > 0) {
            $responseInv = $this->jurnal->addPurchaseInvoice_n($data_jurnal_invoice);
            if ($responseInv->success == true) {
                // ini sukses masuk jurnal
                $id3 = $responseInv->data->purchase_invoice->id;
                // echo $id3;
                // echo $ID;
                // die();
                $id_jurnal_po_invoice = array
                    (
                    'id_jurnal_invoice' => $id3,
                );
                // echo "<pre>";
                // $INV = $this->master_model->select_in('ts_purchase_invoice','*',"WHERE ID='$ID'");
                //     print_r($INV);
                $this->db->where('ID', $ID);
                $this->db->update('ts_purchase_invoice', $id_jurnal_po_invoice);
                //echo $id3;
                //mengecek query database model//&&******/////
                //print_r($this->db);
                ////////****&&&&****
                // echo $ID;
                // die();
                $this->session->set_flashdata('message', '<div class="alert alert-success">Successfully processed</div>');
            } else {
                // gagal masuk jurnal
                foreach ($responseInv->pesan as $key => $text) {
                    $this->session->set_flashdata('message', '<div class="alert alert-success">' . $text . '</div>');
                }
            }
        }
        //echo $ID;
        redirect('admin/transaction/stock/' . $menuid . '/added');
    }

    public function edit_stock($menuid, $ID)
    {
        // print_array($this->input->post());
        // exit;

        $check              = $this->input->post('check');
        $qty                = $this->input->post('qty');
        $real_qty           = $this->input->post('real_qty');
        $id_detail          = $this->input->post('id_detail');

        $in_qty             = $this->input->post('in_qty');

        $in_qty2            = $this->input->post('in_qty2');

        $in_id              = $this->input->post('in_id');

        $code_inventory     = $this->input->post('code_inventory');

        $id_detail_stock    = $this->input->post('id_detail_stock');
        $in_qty_total       = $this->input->post('in_qty_total');

        $data_detail_log      = [];
        $data_purchase_detail = [];
        $data_ms_inventory    = [];
        $ts_stock_detail      = [];

        for ($c = 0; $c < count($check); $c++) {
            if ($check[$c] != '') {

                // qty_delta = qty baru - qty lama
                $qtyDelta = $in_qty2[$c] - $in_qty[$c];

                $get_data_detail_log = $this->master_model->select_in('stock_log_detail', 'ID, qty_bal', "WHERE id_stock_detail=$in_id[$c]");

                $get_data_ms_inventory = $this->master_model->select_in('ms_inventory', 'ID, stock_balance', "WHERE code='$code_inventory[$c]'");

                $get_data_purchase = $this->master_model->select_in('ts_stock_detail', 'ts_stock_detail.id_purchase_invoice, ts_purchase_detail.ID, ts_purchase_detail.in_qty', "INNER JOIN ts_purchase_detail ON ts_purchase_detail.ID = ts_stock_detail.id_purchase_detail WHERE ts_stock_detail.ID=$in_id[$c]");
                // print_array($get_data_purchase);
                // exit; 

                $data_detail_log[] = [
                    'ID'        => $get_data_detail_log[0]->ID,
                    'qty_in'    => $in_qty2[$c],
                    'qty_delta' => $in_qty2[$c] - $in_qty[$c],
                    'qty_bal'   => $get_data_detail_log[0]->qty_bal + $qtyDelta,
                ];
                // print_array($qtyDelta);
                // exit;
                
                $data_purchase_detail[] = [
                    'ID'     => $get_data_purchase[0]->ID,
                    'in_qty' => $get_data_purchase[0]->in_qty + $qtyDelta,
                ];

                $data_ms_inventory[] = [
                    'ID'            => $get_data_ms_inventory[0]->ID,
                    'stock_balance' => $get_data_ms_inventory[0]->stock_balance + $qtyDelta,
                ];

                $data_ts_stock_detail[] = [
                    'ID'        => $in_id[$c],
                    'in_qty'    => $in_qty2[$c],
                ];
                
            }

        }

        // print_array($data_ms_inventory);
        // exit;  

        //exit;
        $this->db->trans_start();
        if (count($data_purchase_detail) > 0) {
            $this->db->update_batch('ts_purchase_detail', $data_purchase_detail, 'ID');
        }

        if (count($data_detail_log) > 0) {
            $this->db->update_batch('stock_log_detail', $data_detail_log, 'ID');
        }

        if (count($data_ms_inventory) > 0) {
            $this->db->update_batch('ms_inventory', $data_ms_inventory, 'ID');
        }

        if (count($data_ts_stock_detail) > 0) {
            $this->db->update_batch('ts_stock_detail', $data_ts_stock_detail, 'ID');
        }
    
        $this->db->trans_complete();
        
        if($this->db->trans_status() === false)
        {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Update Failed</div>');
            redirect('admin/transaction/stock_edit/' . $menuid . '/' . $ID);
        } else {

            // $this->session->set_flashdata('message', 'Update Stock Success');   
            redirect('admin/transaction/purchase/' . $menuid . '/added');

            redirect('admin/transaction/stock/' . $menuid . '/added');
        }
    }

    public function edit_stock2($menuid, $ID)
    {
        print_array($this->input->post());
        exit;

        $check              = $this->input->post('check');
        $qty                = $this->input->post('qty');
        $real_qty           = $this->input->post('real_qty');
        $id_detail          = $this->input->post('id_detail');

        $in_qty             = $this->input->post('in_qty');

        $in_qty2            = $this->input->post('in_qty2');

        $in_id              = $this->input->post('in_id');

        $code_inventory     = $this->input->post('code_inventory');

        $id_detail_stock    = $this->input->post('id_detail_stock');
        $in_qty_total       = $this->input->post('in_qty_total');

        $ammount = 0;
        for ($c = 0; $c < count($check); $c++) {
            if ($check[$c] != '') {
                $id_detail_2 = $id_detail[$c];
                $get_price   = $this->master_model->select_in('ts_purchase_detail', 'price', "WHERE ID=$id_detail_2");

                $in_id_string = str_replace('undefined', '', str_replace('<span>', '', str_replace('</span>', '', $in_id[$c])));
                $in_id_string = explode(', ', $in_id_string);

                $in_qty_string = str_replace('undefined', '', str_replace('<span>', '', str_replace('</span>', '', $in_qty[$c])));
                $in_qty_string = explode(', ', $in_qty_string);

                //print_array($in_qty_string);
                //exit;

                $qty_string = str_replace('<span>', '', str_replace('</span>', '', $qty[$c]));
                $exp        = explode(', ', $qty_string);

                $data_stock_detail2 = $this->master_model->select_in('ts_stock_detail', 'ID', "WHERE id_purchase_invoice=$ID AND id_purchase_detail=$id_detail[$c]");

                for ($q = 0; $q < count($in_id_string); $q++) {
                    if ($in_qty_string[$q] == 100000) {
                        //echo'Delete';
                        //exit;
                        $this->db->where('ID', $in_id_string[$q]);
                        $this->db->delete('ts_stock_detail');
                    }
                }

                $qty_total = 0;
                for ($f = 0; $f < count($exp); $f++) {
                    $qty_total = $qty_total + $exp[$f];

                    $ID_detail_stock_2 = $data_stock_detail2[$f]->ID;

                    //print_array($ID_detail_stock_2);
                    //exit;

                    if ($ID_detail_stock_2 == $in_id_string[$f]) {
                        echo 'Update <br/>';
                    } else {
                        echo 'Insert <br/>';
                    }

                    if ($in_id_string[$f] == 100000) {
                        //echo'Tambah Baru';
                        //exit;
                        $id_stock_detail   = $this->master_model->mst_last_id('ts_stock_detail');
                        $data_stock_detail = array
                            (
                            'ID'                  => $id_stock_detail,
                            'id_purchase_invoice' => $ID,
                            'id_purchase_detail'  => $id_detail[$c],
                            'in_qty'              => $exp[$f],
                            'price'               => $get_price[0]->price,
                        );
                        $this->db->insert('ts_stock_detail', $data_stock_detail);
                    } else {
                        //echo'Update';
                        //exit;
                        $data_stock_detail = array
                            (
                            'in_qty' => $exp[$f],
                        );
                        $this->db->where('ID', $in_id_string[$f]);
                        $this->db->update('ts_stock_detail', $data_stock_detail);
                    }

                    $ammount_1 = $qty_total * $get_price[0]->price;
                }
            }

            $ammount = $ammount + $ammount_1;
        }

        //exit;

        $data_purchase_invoice = array
            (
            'ammount' => $ammount,
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_purchase_invoice', $data_purchase_invoice);

        for ($a = 0; $a < count($check); $a++) {
            if ($check[$a] != '') {
                $data_detail = array
                    (
                    'in_qty' => $in_qty_total[$a],
                );
                $this->db->where('ID', $id_detail[$a]);
                $this->db->update('ts_purchase_detail', $data_detail);
            }
        }

        redirect('admin/transaction/stock/' . $menuid);
    }

    public function edit_stock_process($menuid, $id_purchase, $id_purchase_detail)
    {
        // print_array($this->input->post());
        // exit;

        $in_id     = $this->input->post('in_id');
        $qty       = $this->input->post('qty');
        $old_qty   = $this->input->post('old_qty');
        $code      = $this->input->post('code_inventory');

        //$data_stock_detail=$this->master_model->select_in('ts_stock_detail','ID',"WHERE id_purchase_invoice=$id_purchase AND id_purchase_detail=$id_purchase_detail");
        //$id_stock_detail=$data_stock_detail[0]->ID;
         $data_update_stock_log = [];
         $data_update_ts_purchase_detail = [];
         $data_update_ts_stock_detail = [];
         $data_update_ms_inventory    = [];
        for ($a = 0; $a < count($in_id); $a++) {
            if ($qty[$a] != 0) {

                $data_update_ms_inventory[] = [
                                                    'code'           => $code[$a],
                                                    'stock_balance'  => $old_qty[$a] + $qty[$a],
                                                 ];


                $data_update_ts_stock_detail[] = [
                                                    'ID'      => $in_id[$a],
                                                    'in_qty'  => $qty[$a],
                                                 ];

                $data_update_ts_purchase_detail[] = [
                                                        'ID'     => $id_purchase_detail,
                                                        'in_qty' => $old_qty[$a] + $qty[$a],
                                                    ];
                $data_update_stock_log[] = array
                    (
                    'ID'     => $in_id[$a],
                    'qty_in' => $qty[$a],
                    'qty_bal'=> $old_qty[$a] + $qty[$a],
                );
                // $this->db->where('ID', $in_id[$a]);
                // $this->db->update('ts_stock_detail', $data_update);
            }
        }
        // echo "<pre>";
        // print_r($data_update_ts_stock_detail);
        // die();
        $this->db->trans_start();
        if (count($data_update_ms_inventory) > 0) {
            $this->db->update_batch('ms_inventory', $data_update_ms_inventory, 'code');
        }

        if (count($data_update_ts_stock_detail) > 0) {
            $this->db->update_batch('ts_stock_detail', $data_update_ts_stock_detail, 'ID');
        }

        if (count($data_update_ts_purchase_detail) > 0) {
            $this->db->update_batch('ts_purchase_detail', $data_update_ts_purchase_detail, 'ID');
        }

        if (count($data_update_stock_log) > 0) {
            $this->db->update_batch('stock_log_detail', $data_update_stock_log, 'ID');
        }

       $this->db->trans_complete();
            if($this->db->trans_status() === false)
            {
                $this->session->set_flashdata('message', '<div class="alert alert-danger">Update Failed</div>');
                redirect('admin/transaction/edit_stock/' . $menuid . '/' . $id_purchase);
            } else {

                $this->session->set_flashdata('message', 'Update Stock Success');   

                redirect('admin/transaction/edit_stock/' . $menuid . '/' . $id_purchase);
            } 

        // redirect('admin/transaction/edit_stock/' . $menuid . '/' . $id_purchase);
    }

    public function update_stock($menuid, $ID)
    {
        $data = array(
            'code'          => $this->input->post('code'),
            'name'          => $this->input->post('name'),
            'category'      => $this->input->post('category'),
            'type'          => $this->input->post('type'),
            'barcode'       => $this->input->post('barcode'),
            'unit'          => $this->input->post('unit'),
            'volume'        => $this->input->post('w') . ' x ' . $this->input->post('d') . ' x ' . $this->input->post('h'),
            'bruto'         => $this->input->post('bruto'),
            'net'           => $this->input->post('net'),
            'last_cost'     => $this->input->post('last_cost'),
            'stock_value'   => $this->input->post('stock'),
            'stock_balance' => $this->input->post('balance'),
            'average_cost'  => $this->input->post('average'),
            'note'          => $this->input->post('note'),
        );
        $this->db->where('ID', $ID);
        $this->db->update('ms_inventory', $data);

        redirect('admin/transaction/stock/' . $menuid);
    }

    public function laporan_wo($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        // $data['data_laporan'] = $this->master_model->select_in('c.workorder_no, a.* FROM `ts_stock_detail` a inner join ts_workorder_material b on a.id_workorder_detail = b.id inner join ts_workorder c on b.id_workorder = c.ID WHERE a.`id_workorder_detail` > 0 and b.status = "process" order by c.workorder_no ASC');

        $this->load->view('admin/transaction/laporan', $data);
    }

    public function get_data_workorder()
    {
        $query = "SELECT ts_workorder.*, DATE_FORMAT(ts_workorder.date_schedule,'%d %M %Y') as shedule_date, DATE_FORMAT(ts_workorder.date_target, '%d %M %Y') as target_date FROM ts_workorder";

        $search = array('ID', 'workorder_no', 'product_code', 'date_schedule', 'date_target', 'finish_good', 'sales_order_no', 'supplier_code', 'supplier_name', 'target_pcs', 'finish', 'total_material', 'total_labour', 'grandtotal', 'cost', 'id_admin', 'status', 'note_material', 'note_labour', 'note_spk', 'request', 'barcode', 'pack', 'total_barcode');
        $where  = null;
        //$where  = array('ts_stock.status'  => '0');
        header('Content-Type: application/json');
        echo $this->master_model->get_tables_query_workorder($query, $search, $where);
    }

    public function workorder($menuid, $offset = 0)
    {

        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $before_date = strtotime(date('Y-m-d'));
        $before      = strtotime('-30 day', $before_date);
        $before      = date('Y-m-d', $before);

        $after_date = strtotime(date('Y-m-d'));
        $after      = strtotime('+7 day', $after_date);
        $after      = date('Y-m-d', $after);

        //$this->load->library('pagination');
        //$uri_segment = 5;
        //$limit = 10;

        //$data['data_workorder']= $this->master_model->select_in('ts_workorder','*','ORDER BY workorder_no DESC limit '.$offset.',100');
        //WHERE date_schedule BETWEEN '$before' AND '$after'
        //$config['base_url'] = base_url().'admin/transaction/workorder/'.$menuid;
        //$config['per_page'] = $limit;
        //$config['uri_segment'] = $uri_segment;
        //$config['next_link'] = 'Next';
        //$config['prev_link'] = 'Prev';
        //$config['firs_link'] = 'First';
        //$config['last_link'] = 'Last';
        //$this->pagination->initialize($config);
        //$data['page'] = $this->pagination->create_link();
        //$data['data_workorder'] = $data_workorder;
        $data['data_workorder'] = $this->master_model->select_in('ts_workorder a', '*', "WHERE a.date_schedule >= date_add(date(now()),INTERVAL-30 day) and a.date_schedule <= date(now()) ORDER BY a.ID DESC");
        $this->load->view('admin/transaction/workorder_reve', $data);
    }

    public function workorder_old($menuid, $offset = 0)
    {

        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        //     $sql = "SELECT a.id_group, a.id_menu, b.name
        // FROM user_group_detail AS a, user AS b
        // WHERE a.id_menu = '$menuid'
        // AND b.ID = '$user_id'
        // AND b.id_group = a.id_group
        // AND a.read_flg = 1";
        // echo $sql;
        // die();

        $this->redirectNoAuthRead($user_id, $menuid);

        $before_date = strtotime(date('Y-m-d'));
        $before      = strtotime('-30 day', $before_date);
        $before      = date('Y-m-d', $before);

        $after_date = strtotime(date('Y-m-d'));
        $after      = strtotime('+7 day', $after_date);
        $after      = date('Y-m-d', $after);

        //$this->load->library('pagination');
        //$uri_segment = 5;
        //$limit = 10;

        //$data['data_workorder']= $this->master_model->select_in('ts_workorder','*','ORDER BY workorder_no DESC limit '.$offset.',100');
        //WHERE date_schedule BETWEEN '$before' AND '$after'
        //$config['base_url'] = base_url().'admin/transaction/workorder/'.$menuid;
        //$config['per_page'] = $limit;
        //$config['uri_segment'] = $uri_segment;
        //$config['next_link'] = 'Next';
        //$config['prev_link'] = 'Prev';
        //$config['firs_link'] = 'First';
        //$config['last_link'] = 'Last';
        //$this->pagination->initialize($config);
        //$data['page'] = $this->pagination->create_link();
        //$data['data_workorder'] = $data_workorder;
        $data['data_workorder'] = $this->master_model->select_in('ts_workorder a', '*', "WHERE a.date_schedule >= date_add(date(now()),INTERVAL-30 day) and a.date_schedule <= date(now()) ORDER BY a.ID DESC");
        $this->load->view('admin/transaction/workorder', $data);
    }

    public function search_workorder($menuid, $offset = 0)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $data['data_workorder'] = $this->master_model->select_in('ts_workorder a', '*', "WHERE a.workorder_no LIKE '%$cari%' OR a.finish_good LIKE '%$cari%'");

        $this->load->view('admin/transaction/workorder', $data);
        //redirect('admin/transaction/workorder',$data);
    }

    public function status_get_wo($before, $today, $menuid, $param)
    {
        $status = $this->input->post('status');

        if ($status == 'All') {
            $data_workorder = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$today' ORDER BY workorder_no DESC");
        } else {
            $data_workorder = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$today') ORDER BY workorder_no DESC");
        }

        $count_purchase = count($data_workorder);

        setlocale(LC_ALL, 'id_ID.UTF-8');

        echo '
			<table id="' . $param . '" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Work Order No</th>
                        <th>Schedule Date</th>
                        <th>
                        	Target Date
                        </th>
                        <!--<th>Customer</th>-->
                        <th>Barcode</th>
                        <th>Product</th>
                        <th>Image</th>
												<th>
													Create Barcode
												</th>
                        <th>Target Pcs</th>
                        <th>Done</th>
                        <th>Bad</th>
                        <th>
                        	Cost
                        </th>
                        <th>HPP</th>
												<th>
													Last Process
												</th>
                        <th>
                        	Status
                        </th>
                        <th>Edit</th>
                        <th>Delete</th>
                        <th>
                        	Print SPK
                        </th>
                    </tr>
                </thead>
                <tbody>
		';

        for ($a = 0; $a < count($data_workorder); $a++) {
            $b         = $a + 1;
            $ID        = $data_workorder[$a]->ID;
            $barcodeb  = $data_workorder[$a]->barcode;
            $barcodebb = substr(str_replace('%20', ' ', $data_workorder[$a]->finish_good), 0, 10);
            //new code
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL            => "https://babykenaz.com/api/product_models/show/$barcodebb",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT        => 30,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => "GET",
                CURLOPT_HTTPHEADER     => array(
                    "cache-control: no-cache",
                ),
            ));
            $response = curl_exec($curl);
            $err      = curl_error($curl);

            curl_close($curl);

            $response = json_decode($response, true); //because of true, it's in an array

            $image   = explode(',', $response['data']['image']);
            $imagesb = implode("", $image);
            echo '
					<tr>
						<td>
							' . $b . '
						</td>
						<td>
							<a href="' . base_url() . 'admin/transaction/production_insert/' . $menuid . '/' . $ID . '">
								' . $data_workorder[$a]->workorder_no . '
							</a>
						</td>
						<td>' . date('d M Y', strtotime($data_workorder[$a]->date_schedule)) . '</td>
						<td>' . date('d M Y', strtotime($data_workorder[$a]->date_target)) . '</td>

						<td>' . $data_workorder[$a]->product_code . '</td>
						<td>' . $data_workorder[$a]->finish_good . '</td>

                        <td>
                        	';
            if ($imagesb != '') {
                echo '<a href="#" alt="' . $data_workorder[$a]->ID . '" data="' . $data_workorder[$a]->ID . '" class="edit text-green" data-toggle="modal" data-target="#edit-modal">';
                echo '<img width="59px" height="35px" class="card-img-top img-preview" src="https://babykenaz.com/assets/img/uploads/product_models/' . $imagesb . '">
                            	</a>
                            	 ';}echo '
                        </td>

						<td style="text-align: center">
							<script>
								$(document).ready(function(e)
								{
									$(".barcode' . $b . '").click(function(){
										 var ID = $(this).attr("alt");
											 // alert(id_customer);
											$.ajax({
											 type: "POST",
											 dataType: "html",
											 url: "' . base_url() . 'admin/transaction/create_barcode_modal/' . $menuid . '/' . $data_workorder[$a]->finish_good . '",
											 data:"ID="+ID,
											 success: function(msg)
											 {
													$(".barcode-modal").html(msg);
											 }
											});
									});
								});
							</script>
							';
            $data_labour = $this->master_model->select_in('ts_workorder_labour', 'name_inventory, start_date, requested', "WHERE id_workorder = $ID ORDER BY ID ASC");

            $data_last_process = $this->master_model->select_in('ts_workorder_labour a LEFT JOIN ms_inventory b ON a.code_inventory = b.code', 'b.name AS name_inventory', "WHERE a.id_workorder = $ID AND a.requested <> 0 AND a.start_date <> '0000-00-00' ORDER BY a.ID DESC LIMIT 1");
            $name_inventory    = $data_last_process[0]->name_inventory;

            if ($data_workorder[$a]->barcode == '') {
                $text            = 'text-black';
                $display_barcode = '<i class="fa fa-barcode"></i>';
            } else {
                $text            = 'text-blue';
                $display_barcode = '
										<img src="' . base_url() . 'admin/transaction/create_barcode/' . $menuid . '/' . $data_workorder[$a]->barcode . '" width="100" height="35">
									';
            }

            if ($name_inventory != '') {
                echo '
											<a alt="' . $data_workorder[$a]->ID . '" class="barcode' . $b . ' ' . $text . '" data-toggle="modal" data-target="#barcode-modal" style="cursor: pointer">
												' . $display_barcode . '
											</a>
									';
            }
            echo '
						</td>


						<td>
                        	' . $data_workorder[$a]->target_pcs . '
                        </td>

                        <td>
                        	' . $data_workorder[$a]->finish . '
                        </td>

                        <td>
                        	';
            if ($data_workorder[$a]->status == 'Done') {
                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', 'start_date, end_date, bad', "WHERE id_workorder=$ID ORDER BY ID DESC LIMIT 1");

                if ($data_workorder_labour[0]->start_date == '0000-00-00' || $data_workorder_labour[0]->end_date == '0000-00-00') {
                    echo 0;
                } else {
                    echo $data_workorder_labour[0]->bad;
                }
            } else {
                echo '-';
            }
            echo '
                        </td>
						<td>' . money_format('%.2n', $data_workorder[$a]->grandtotal) . "\n" . '</td>
						<td>
							';
            if ($data_workorder[$a]->finish == 0) {
                echo money_format('%.2n', 0) . "\n";
            } else {
                echo money_format('%.2n', $data_workorder[$a]->grandtotal / $data_workorder[$a]->finish) . "\n";
            }
            echo '
						</td>
						<td>
						<script>
							$(document).ready(function(e)
							{
								$(".history_labour' . $b . '").click(function(){
									 var ID = $(this).attr("alt");
										 // alert(id_customer);
										$.ajax({
										 type: "POST",
										 dataType: "html",
										 url: "' . base_url() . 'admin/transaction/history_labour/' . $menuid . '/' . $data_workorder[$a]->workorder_no . '",
										 data:"ID="+ID,
										 success: function(msg){
												$(".last-process").html(msg);
										 }
										});
								});
										});
						</script>
							';
            //$data_last_process = $this->master_model->select_in('ts_workorder_labour', 'name_inventory', "WHERE id_workorder = $ID AND requested <> 0 AND start_date <> '0000-00-00' ORDER BY ID DESC LIMIT 1");

            //$name_inventory = $data_last_process[0]->name_inventory;

            if ($name_inventory == '') {
                $last_process = '<span class="text-red">Unprocess</span>';
            } else {
                $last_process = $data_last_process[0]->name_inventory;
            }
            echo '<a alt="' . $ID . '" class="history_labour' . $b . ' text-blue" style="cursor:pointer" data-toggle="modal" data-target="#last-process">' . ucfirst($last_process) . '</a>';
            echo '
						</td>
						<td style="text-align:center">
							';
            if ($data_workorder[$a]->status == 'Pending') {
                $font = 'text-red';
            } elseif ($data_workorder[$a]->status == 'Process') {
                $font = 'text-green';
            } elseif ($data_workorder[$a]->status == 'Done') {
                $font = 'text-aqua';
            }
            echo '
							<font class="' . $font . '">
								' . $data_workorder[$a]->status . '

								';
            if ($data_workorder[$a]->status == 'Process') {
                ?>
										<br/>
											<a href="<?php echo base_url(); ?>admin/transaction/done_process/<?php echo 'workorder/' . $menuid . '/' . $ID; ?>" class="label label-primary" onClick="return confirm('\Are you sure want to close this transaction?')">
												Close
											</a>
										<?php
} else {
                echo '';
            }
            echo '
							</font>
						</td>
						<td style="text-align:center">
						   <a href="' . base_url() . 'admin/transaction/production_insert/' . $menuid . '/' . $ID . '" class="text-green">
								<i class="fa fa-edit"></i>
							</a>
						</td>
						<td style="text-align:center">
							<a href="' . base_url() . 'admin/transaction/delete_workorder/' . $menuid . '/' . $ID . '" onclick="return confirm(\'Are you sure want to delete this transaction?\')"  class="text-red">
								<i class="fa fa-trash-o"></i>
							</a>
						</td>
						<td style="text-align:center">
                            	<script>
									$(document).ready(function(e)
									{
										$(".create_spk_' . $a . '").click(function()
										{
											window.location.assign("' . base_url() . 'admin/transaction/workorder_spk/' . $menuid . '/' . $ID . '");
										});
									});
								</script>
                            	<a class="text-orange create_spk_' . $a . '" style="cursor: pointer;">
							      	<i class="fa fa-fw fa-file-text-o"></i>
							    </a>
                            </td>
					</tr>
				';
        }

        echo '
			</tbody>
			</table>


			<script>

			  $(function ()
			  {
			    $("#' . $param . '").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
    }

    public function status_get_production($before, $today, $menuid, $param)
    {
        $status = $this->input->post('status');

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$today' ORDER BY workorder_no DESC");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$today') ORDER BY workorder_no DESC");
        }

        $count_purchase = count($data_production);

        echo '
			<table id="' . $param . '" class="table table-bordered table-striped">
			<thead>
                <tr>
                    <th>No.</th>
                    <th>WO Number</th>
                   	<th>Barcode</th>
                    <th>Product</th>
                    <th>Target Pcs</th>
                    <th>Finish</th>
                    <th>Status</th>
                    <th>Schedule</th>
                    <th>Target</th>
                    <!-- <th>Start Date</th>
                    <th>End Date</th> -->
                    <th>Edit</th>
                    <!--
                    <th>Delete</th>
                    -->
                </tr>
            </thead>

            <tbody class="production_update">
		';

        for ($a = 0; $a < count($data_production); $a++) {
            $b  = $a + 1;
            $ID = $data_production[$a]->ID;

            $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID");

            if ($data_workorder_labour[0]->start_date == '0000-00-00') {
                $start_date = '-';
            } else {
                $start_date = date('d M Y', strtotime($data_workorder_labour[0]->start_date));
            }

            if ($data_workorder_labour[0]->end_date == '0000-00-00') {
                $end_date = '-';
            } else {
                $end_date = date('d M Y', strtotime($data_workorder_labour[0]->end_date));
            }
            echo '
					<tr>
						<td>
							' . $b . '
						</td>
						<td>
							<a href="' . base_url() . 'admin/transaction/production_insert/' . $menuid . '/' . $ID . '" class="text-blue">
								' . $data_production[$a]->workorder_no . '
							</a>
						</td>
						<td>' . $data_production[$a]->product_code . '</td>
						<td>' . $data_production[$a]->finish_good . '</td>
						<td>' . $data_production[$a]->target_pcs . '</td>
						<td>' . $data_production[$a]->finish . '</td>
						<td>
							';
            if ($data_production[$a]->status == 'Pending') {
                $font = 'text-red';
            } elseif ($data_production[$a]->status == 'Process') {
                $font = 'text-green';
            } elseif ($data_production[$a]->status == 'Done') {
                $font = 'text-aqua';
            }
            echo '
							<font class="' . $font . '">
								' . $data_production[$a]->status . '

								';
            if ($data_production[$a]->status == 'Process') {
                ?>
											<a href="<?php echo base_url(); ?>admin/transaction/done_process/<?php echo 'production/' . $menuid . '/' . $ID; ?>" class="text-blue pull-right" onClick='return confirm("Are you sure want to close this transaction?")'>
												[Close]
											</a>
										<?php
} else {
                echo '';
            }
            echo '
							</font>
						</td>
						<td>' . date('d M Y', strtotime($data_production[$a]->date_schedule)) . '</td>
						<td>' . date('d M Y', strtotime($data_production[$a]->date_target)) . '</td>
						<!--<td>' . $start_date . '</td>
						<td>' . $end_date . '</td>-->
						<td style="text-align:center">
						   <a href="' . base_url() . 'admin/transaction/purchase/' . $menuid . '" class="edit text-green" style="cursor:pointer">
								<i class="fa fa-edit"></i>
							</a>
						</td>
					</tr>
				';
        }

        echo '
			</tbody>
			</table>


			<script>

			  $(function ()
			  {
			    $("#' . $param . '").DataTable(
			  	{
			  		"paging": true,
			  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
			  		"pageLength": 10,
			  		"searching": true,
			  		//"ajax": "data/arrays.txt",
			  		"deferRender": true,
			  	});
			  });
			</script>
		';
    }

    public function workorder_insert($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $this->load->view('admin/transaction/workorder_insert');
    }

    public function workorder_spk($menuid, $ID)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $this->load->view('admin/transaction/workorder_spk');
    }

    public function production($menuid)
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $today = date('Y-m-d');

        $before_date = strtotime(date('Y-m-d'));
        $before      = strtotime('-30 day', $before_date);
        $before      = date('Y-m-d', $before);

        $after_date = strtotime(date('Y-m-d'));
        $after      = strtotime('+7 day', $after_date);
        $after      = date('Y-m-d', $after);

        $jumlah_data = $this->master_model->jumlah_data_production();
        $this->load->library('pagination');
        $config['base_url']   = base_url() . 'admin/transaction/production/' . $menuid;
        $config['total_rows'] = $jumlah_data;
        $config['per_page']   = 10;
        $from                 = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_production'] = $this->master_model->data_production($config['per_page'], $from);

        //$data['data_production']= $this->master_model->select_in('ts_workorder','*',"ORDER BY workorder_no DESC"); //WHERE date_schedule BETWEEN '$before' AND '$after'
        $data['data_production'] = $this->master_model->select_in('ts_workorder a', '*', "WHERE a.date_schedule >= date_add(date(now()),INTERVAL-30 day) and a.date_schedule <= date(now()) ORDER BY a.workorder_no DESC");
        $this->load->view('admin/transaction/production', $data);
    }

    public function search_production($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $data['data_production'] = $this->master_model->select_in('ts_workorder a', 'a.*', "WHERE a.workorder_no LIKE '%$cari%' OR a.finish_good LIKE '%$cari%'");

        $this->load->view('admin/transaction/production', $data);
    }

    public function production_insert($menuid, $ID)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        // echo "string";
        // die();
        $this->load->view('admin/transaction/production_insert');
    }

    public function production_request($menuid, $ID)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $this->load->view('admin/transaction/production_request');
    }

    public function production_material($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $ID = $this->input->post('ID');

        $this->load->view('admin/transaction/production_material');
    }

    public function production_labour_pick($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        //print_array($data);
        //exit;

        $this->load->view('admin/transaction/production_labour_pick');
    }

    public function production_labour($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $this->load->view('admin/transaction/production_labour');
    }

    public function search_production_labour($menuid)
    {
        define("menuid", $menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        $cari = $this->input->post('cari');

        $data['data_workorder'] = $this->master_model->select_in('ts_workorder b ', 'b.*', "WHERE b.workorder_no LIKE '%$cari%' OR b.finish_good LIKE '%$cari%'");

        $this->load->view('admin/transaction/production_labour', $data);
        // $this->load->view('admin/transaction/production_labour');
    }

    public function insert_production_material($menuid, $id_workorder)
    {
        // print_array($this->input->post());
        // exit;

        $id_material = $this->input->post('id_material');

        $id_stock_detail = $this->input->post('id_stock_detail');

        $pick_material = $this->input->post('pick_material');
        $retur         = $this->input->post('retur');
        $used          = $this->input->post('used');
        $check         = $this->input->post('check');

        $strBaca      = "";
        $strBaca2     = "";
        $total_used   = 0;
        $price_before = 0;
        $subtotal     = 0;
        for ($a = 0; $a < count($pick_material); $a++) {
            $id_stock_detail_2 = $id_stock_detail[$a];

            $strBaca  = $strBaca . '' . $pick_material[$a] . ', ';
            $strBaca2 = $strBaca2 . '' . $retur[$a] . ', ';

            $total_used = $total_used + $used[$a];

            $get_price = $this->master_model->select_in('ts_stock_detail', 'price', "WHERE ID=$id_stock_detail_2");
            $price     = $get_price[0]->price;

            //echo $id_stock_detail_2.' <br>';
            //exit;

            //$total_price=$price_before+$price;
            $total_price = $used[$a] * $price;

            $subtotal = $subtotal + $total_price;

            //$gross_ammount = $subtotal+$gross_ammount;
        }

        //echo $gross_ammount;
        //exit;

        $avg_price = $subtotal / $total_used;
        //$gross_ammount = $total_price*$total_used;

        $string          = substr($strBaca, 0, strlen($strBaca) - 1);
        $pick_material_1 = $string;

        $string2 = substr($strBaca2, 0, strlen($strBaca2) - 1);
        $retur_1 = $string2;

        $data = array
            (
            'requested'     => $pick_material_1,
            'actual'        => $total_used,
            'retur'         => $retur_1,
            'price'         => $avg_price,
            'gross_ammount' => $subtotal,
            'status'        => 'Process',
        );
        //print_array($data);
        //exit;

        $this->db->where('ID', $id_material);
        $this->db->update('ts_workorder_material', $data);

        $retured = $this->input->post('retur');

        for ($s = 0; $s < count($id_stock_detail); $s++) {
            $get_wo_number = $this->master_model->select_in('ts_workorder', 'workorder_no', "WHERE ID=$id_workorder");
            $workorder_no  = $get_wo_number[0]->workorder_no;

            if ($check[$s] == 0) {
                $workorder_no        = '';
                $qty_use             = 0;
                $retur               = 0;
                $id_workorder_detail = 0;
            } elseif ($check[$s] == 1 and $used[$s] != 0)
            //}elseif($check[$s]==1)
            {
                $workorder_no        = $workorder_no;
                $qty_use             = $used[$s];
                $retur               = $retured[$s];
                $id_workorder_detail = $id_material;
            }

            $data_stock_detail = array
                (
                'id_workorder_detail' => $id_workorder_detail,
                'qty_use'             => $qty_use,
                'qty_waste'           => $retur,
            );
            $this->db->where('ID', $id_stock_detail[$s]);
            $this->db->update('ts_stock_detail', $data_stock_detail);
        }

        $data_material  = $this->master_model->select_in('ts_workorder_material', 'gross_ammount', "WHERE id_workorder=$id_workorder");
        $total_material = 0;
        for ($b = 0; $b < count($data_material); $b++) {
            $total_material = $total_material + $data_material[$b]->gross_ammount;
        }

        $data_labour  = $this->master_model->select_in('ts_workorder_labour', 'gross_ammount', "WHERE id_workorder=$id_workorder");
        $total_labour = 0;
        for ($c = 0; $c < count($data_labour); $c++) {
            $total_labour = $total_labour + $data_labour[$c]->gross_ammount;
        }

        $grand_total = $total_material + $total_labour;

        $data_workorder = array
            (
            'status'         => 'Process',
            'total_material' => $total_material,
            'grandtotal'     => $grand_total,
        );
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_workorder);

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);
    }

    public function insert_production($menuid, $id_workorder, $control = '')
    {
        // print_array($this->input->post());
        // exit;

        $id_image = $this->input->post('id_image');

        //$id_workorder=$this->master_model->mst_last_id('ts_workorder');

        for ($i = 0; $i < count($id_image); $i++) {
            $j          = $i + 1;
            $uploadPost = $_FILES;
            if ($uploadPost['ImageUpload' . $j]['name'] != '') {
                $ID = $this->master_model->mst_last_id('ts_workorder_design');

                $Image      = $ID . '.' . substr($_FILES['ImageUpload' . $j]['name'], strrpos($_FILES['ImageUpload' . $j]['name'], '.') + 1);
                $Image_temp = $ID . '_temp.' . substr($_FILES['ImageUpload' . $j]['name'], strrpos($_FILES['ImageUpload' . $j]['name'], '.') + 1);

                $config['file_name']     = $ID . '_temp';
                $config['upload_path']   = './uploads/design/';
                $config['allowed_types'] = 'gif|jpg|png|';
                $config['max_size']      = '2000';
                $config['max_width']     = '1500';
                $config['max_height']    = '1500';
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('ImageUpload' . $j)) {
                    $data  = array('error' => $this->upload->display_errors('', ''));
                    $error = $data['error'];
                    echo '<script language="javascript">alert("' . $error . '!");window.history.go(-1);</script>';
                    exit();
                } else {
                    $fileImage_temp = './uploads/design/' . $Image_temp;
                    if (file_exists($fileImage_temp)) {unlink($fileImage_temp);}
                    $fileImage = './uploads/design/' . $Image;
                    if (file_exists($fileImage) && $Image != '') {unlink($fileImage);}
                    $config['file_name'] = $ID;

                    $this->upload->initialize($config);

                    $this->upload->do_upload('ImageUpload' . $j);
                }

                $data = array
                    (
                    'ID'           => $ID,
                    'id_workorder' => $id_workorder,
                    'image'        => $Image,
                    'sort'         => $ID,
                );
                $this->db->insert('ts_workorder_design', $data);
            }
        }

        $code_material = $this->input->post('code_material');
        $item_material = $this->input->post('item_material');

        $plan = $this->input->post('plan');
        for ($a = 0; $a < count($code_material); $a++) {
            //$code_material = trim($code_material[$a]);
            if ($item_material[$a] == '') {
                $get_name_material = $this->master_model->select_in('ms_inventory', 'name', "WHERE code = '$code_material'");
                $item_material[$a] = $get_name_material[0]->name;
            } else {
                $item_material[$a] = $item_material[$a];
            }

            if ($code_material[$a] != '') {
                $id_material   = $this->master_model->mst_last_id('ts_workorder_material');
                $data_material = array
                    (
                    'ID'                 => $id_material,
                    'id_workorder'       => $id_workorder,
                    'code_inventory'     => $code_material[$a],
                    'name_inventory'     => $item_material[$a],
                    'plan'               => $plan[$a],
                    'sort'               => $id_material,
                    'status'             => 'Process',
                    'id_jurnal_material' => '0',
                );
                //echo "<pre>";
                $this->db->insert('ts_workorder_material', $data_material);
                //print_r($data_material);
            }
        }
        //die();

        $id_labour  = $this->input->post('id_labour');
        $start_date = $this->input->post('start_date');
        $end_date   = $this->input->post('end_date');
        $requested  = $this->input->post('requested');
        $done       = $this->input->post('done');
        $bad        = $this->input->post('bad');
        $price      = $this->input->post('price');

        $code_labour = $this->input->post('code_labour');
        $item_labour = $this->input->post('item_labour');
        $schedule    = $this->input->post('schedule');
        $target      = $this->input->post('target');

        $supplier_code_labour = $this->input->post('supplier_code_labour');

        $total_labour = 0;

        for ($b = 0; $b < count($code_labour); $b++) {
            if ($code_labour[$b] != '') {
                $check_id_wo_labour = $this->master_model->mst_check('ts_workorder_labour', 'ID', $id_labour[$b]);

                if ($schedule[$b] == '') {
                    $schedule[$b] = '0000-00-00';
                } else {
                    $schedule[$b] = date('Y-m-d', strtotime($schedule[$b]));
                }

                if ($target[$b] == '') {
                    $target[$b] = '0000-00-00';
                } else {
                    $target[$b] = date('Y-m-d', strtotime($target[$b]));
                }

                if ($start_date[$b] == '') {
                    //$start_date[$b]='0000-00-00';
                    $start_date[$b] = '';
                } else {
                    $start_date[$b] = date('Y-m-d', strtotime($start_date[$b]));
                }

                if ($end_date[$b] == '') {
                    //$end_date[$b]='0000-00-00';
                    $end_date[$b] = '';
                } else {
                    $end_date[$b] = date('Y-m-d', strtotime($end_date[$b]));
                }

                if ($check_id_wo_labour == false) {
                    $gross_ammount = 0 * $price[$b];

                    $id_labour_last = $this->master_model->mst_last_id('ts_workorder_labour');
                    $data_labour    = array
                        (
                        'ID'             => $id_labour_last,
                        'id_workorder'   => $id_workorder,
                        'code_inventory' => $code_labour[$b],
                        'code_supplier'  => $supplier_code_labour[$b],
                        'name_inventory' => $item_labour[$b],
                        'schedule_date'  => $schedule[$b],
                        'target_date'    => $target[$b],
                        'price'          => empty($price[$b]) ? null : $price[$b],
                        'sort'           => $id_labour_last,
                        'start_date'     => empty($start_date[$b]) ? null : $start_date[$b],
                        'end_date'       => empty($end_date[$b]) ? null : $end_date[$b],
                        // 'start_date'=>$start_date[$b],
                        // 'end_date'=>$end_date[$b],
                    );
                    $this->db->insert('ts_workorder_labour', $data_labour);
                    //echo "<pre>";
                    // print_r([$data_labour]);

                    $total_labour = $total_labour + $gross_ammount;
                } else {
                    //$total_labour=0;
                    //    if($done[$b]=='')
                    // {
                    //     $done[$b]='';
                    // }else
                    // {
                    //     $done[$b]=$done[$b];
                    // }
                    $gross_ammount = $done[$b] * $price[$b];

                    $data_labour = array
                        (
                        'start_date'    => $start_date[$b],
                        'end_date'      => $end_date[$b],
                        'requested'     => empty($requested[$b]) ? null : $requested[$b],
                        'done'          => $done[$b],
                        'bad'           => $bad[$b],
                        'price'         => str_replace(',', '.', $price[$b]) == '' ? 0 : str_replace(',', '.', $price[$b]),
                        'gross_ammount' => $gross_ammount,
                        'code_supplier' => $supplier_code_labour[$b],
                        'schedule_date' => $schedule[$b],
                        'target_date'   => $target[$b],
                    );

                    $this->db->where('ID', $id_labour[$b])->update('ts_workorder_labour', $data_labour);
                    // echo "<pre>";
                    //  print_r([$id_labour[$b],$data_labour]);

                    $total_labour = $total_labour + $gross_ammount;
                }
            }
        }

        //echo $total_labour;
        //exit;

        $check_wo_labour = $this->master_model->mst_check('ts_workorder_labour', 'id_workorder', $id_workorder);

        if ($check_wo_labour == false) {
            if ($control == 'production') {
                $controller = 'production_insert';
            } else {
                $controller = 'workorder';
            }
            $workorder_id = '/' . $id_workorder;
        } else {
            if ($control == 'production') {
                $controller = 'production';
            } else {
                $controller = 'workorder';
            }
            $workorder_id = '';
        }

        $data_material  = $this->master_model->select_in('ts_workorder_material', 'gross_ammount', "WHERE id_workorder=$id_workorder");
        $total_material = 0;
        for ($d = 0; $d < count($data_material); $d++) {
            $total_material = $total_material + $data_material[$d]->gross_ammount;
        }

        /*
        $data_labour=$this->master_model->select_in('ts_workorder_labour','gross_ammount',"WHERE id_workorder=$id_workorder");
        $total_labour=0;
        for($c=0; $c < count($data_labour); $c++)
        {
        $total_labour=$total_labour+$data_labour[$c]->gross_ammount;
        }
         */
        $cost = $this->input->post('cost');

        $grand_total = $total_material + $total_labour + $cost;

        $schedule_date = $this->input->post('schedule_date');
        $target_date   = $this->input->post('target_date');

        if ($schedule_date == '') {
            $today         = date('Y-m-d');
            $date_schedule = $today;
        } else {
            $date_schedule = date('Y-m-d', strtotime($schedule_date));
        }

        if ($target_date == '') {
            $required    = strtotime(date('Y-m-d'));
            $required    = strtotime('+30 day', $required);
            $required    = date('Y-m-d', $required);
            $date_target = $required;
        } else {
            $date_target = date('Y-m-d', strtotime($target_date));
        }
        $finish_goods   = $this->input->post('finish_good');
        $data_workorder = array
            (
            'sales_order_no' => $this->input->post('sales_order_no'),
            'date_schedule'  => $date_schedule,
            'date_target'    => $date_target,
            'finish_good'    => rtrim($finish_goods),
            'supplier_code'  => $this->input->post('supplier_code'),
            'supplier_name'  => $this->input->post('supplier_name'),
            'target_pcs'     => $this->input->post('target_pcs'),
            'finish'         => $this->input->post('finish'),
            'status'         => 'Process',
            'total_labour'   => $total_labour,
            'grandtotal'     => $grand_total,
            'note_material'  => $this->input->post('note_material'),
            'note_labour'    => $this->input->post('note_labour'),
            'note_spk'       => $this->input->post('note_spk'),
            'cost'           => $cost,
        );
        // echo "<pre>";
        // print_r([$data_workorder]);
        // die();
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_workorder);

        redirect('admin/transaction/' . $controller . '/' . $menuid . '' . $workorder_id);
    }

    public function delete_material($menuid, $id_workorder, $ID)
    {
        $this->db->where('ID', $ID);
        $this->db->delete('ts_workorder_material');

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);
    }

    public function delete_labour($menuid, $id_workorder, $ID)
    {
        $get_gross_amount_labour = $this->master_model->select_in('ts_workorder_labour', 'gross_ammount', "WHERE ID=$ID");
        $gross_ammount           = $get_gross_amount_labour[0]->gross_ammount;

        $get_total_workorder = $this->master_model->select_in('ts_workorder', 'total_labour, grandtotal', "WHERE ID=$id_workorder");
        $total_labour        = $get_total_workorder[0]->total_labour;
        $grandtotal          = $get_total_workorder[0]->grandtotal;

        $data_workorder = array
            (
            'total_labour' => $total_labour - $gross_ammount,
            'grandtotal'   => $grandtotal - $gross_ammount,
        );
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_workorder);

        $this->db->where('ID', $ID);
        $this->db->delete('ts_workorder_labour');

        /*
        $data_workorder_labour=array
        (
        'start_date' => '0000-00-00',
        'end_date' => '0000-00-00',
        'done' => '0',
        'price' => '0',
        'gross_ammount' => '0',
        );
         */
        //print_array($data_workorder_labour);
        //exit;

        //$this->db->where('ID', $ID);
        //$this->db->update('ts_workorder_labour', $data_workorder_labour);

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);
    }

    public function insert_production_labour($menuid)
    {
        //print_array($this->input->post());
        //exit;

        $id_labour  = $this->input->post('id_labour');
        $start_date = $this->input->post('start_date');
        $end_date   = $this->input->post('end_date');
        $requested  = $this->input->post('requested');
        $done       = $this->input->post('done');
        $bad        = $this->input->post('bad');
        $price      = $this->input->post('price');

        $total_labour = 0;
        for ($b = 0; $b < count($id_labour); $b++) {
            $ID            = $id_labour[$b];
            $gross_ammount = $done[$b] * $price[$b];

            if ($start_date[$b] == '') {
                $start_date[$b] == '';
            } else {
                $start_date[$b] = date('Y-m-d', strtotime($start_date[$b]));
            }

            if ($end_date[$b] == '') {
                $end_date[$b] == '';
            } else {
                $end_date[$b] = date('Y-m-d', strtotime($end_date[$b]));
            }

            if ($start_date[$b] != '' || $requested[$b] != 0) {
                $data_labour = array
                    (
                    'start_date'    => $start_date[$b],
                    'end_date'      => $end_date[$b],
                    'requested'     => $requested[$b],
                    'done'          => $done[$b],
                    'bad'           => $bad[$b],
                    'price'         => $price[$b],
                    'gross_ammount' => $gross_ammount,
                );

                //print_array($data_labour);
                //exit;

                $this->db->where('ID', $ID);
                $this->db->update('ts_workorder_labour', $data_labour);

                $total_labour = $total_labour + $gross_ammount;

                $get_id_workorder = $this->master_model->select_in('ts_workorder_labour', 'id_workorder', "WHERE ID=$ID");
                $id_workorder     = $get_id_workorder[0]->id_workorder;

                $get_total_labour  = $this->master_model->select_in('ts_workorder', 'total_labour', "WHERE ID=$id_workorder");
                $total_labour_real = $get_total_labour[0]->total_labour;

                $data_material  = $this->master_model->select_in('ts_workorder_material', 'gross_ammount', "WHERE id_workorder=$id_workorder");
                $total_material = 0;
                for ($d = 0; $d < count($data_material); $d++) {
                    $total_material = $total_material + $data_material[$d]->gross_ammount;
                }

                $grand_total = $total_material + $total_labour + $total_labour_real;

                $data_workorder = array
                    (
                    'finish'       => $done[$b],
                    'total_labour' => $total_labour + $total_labour_real,
                    'grandtotal'   => $grand_total,
                );
                $this->db->where('ID', $id_workorder);
                $this->db->update('ts_workorder', $data_workorder);
            }
        }

        redirect('admin/transaction/production_labour/' . $menuid);
    }

    public function change_internal($menuid)
    {
        $ID = $this->input->post('ID');

        $get_internal = $this->master_model->select_in('ts_workorder_labour', 'internal', "WHERE ID=$ID");
        $internal     = $get_internal[0]->internal;

        if ($internal == 0) {
            $this->db->where('ID', $ID);
            $this->db->set('internal', '1');
            $this->db->update('ts_workorder_labour');

            echo '<i class="fa fa-check-square-o" aria-hidden="true"></i>%1';
        } else {
            $this->db->where('ID', $ID);
            $this->db->set('internal', '0');
            $this->db->update('ts_workorder_labour');

            echo '<i class="fa fa-square-o" aria-hidden="true"></i>%0';
        }
    }

    public function change_date($menuid, $process)
    {
        if ($process == 'add') {
            $process = '+';
        } else {
            $process = '-';
        }

        $date  = strtotime($this->input->post('date'));
        $date  = strtotime($process . '1 day', $date);
        $today = date('m/d/Y', $date);

        echo $today;
    }

    public function change_labour($menuid, $process)
    {
        if ($process == 'add') {
            $process = '+';
        } else {
            $process = '-';
        }

        $date  = strtotime($this->input->post('date'));
        $date  = strtotime($process . '1 day', $date);
        $today = date('Y-m-d', $date);

        $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE (`schedule_date` = '$today' AND requested <> 0) OR (`schedule_date` < '$today' AND done = 0 AND requested <> 0) ORDER BY schedule_date ASC");

        $count = count($data_workorder_labour);

        echo '
		<table id="example2" class="table table-bordered table-striped">
				<thead>
						<tr>
								<th>No.</th>
								<th>WO Number</th>
								<th>Finish Good</th>
								<th>Description</th>
								<th>Supplier Name</th>
								<th>Schedule Date</th>
								<th>Target Date</th>
								<th>Start Date</th>
								<th>End Date</th>
								<th>Requested</th>
								<th>Done</th>
								<th>Bad</th>
								<th>@Cost</th>
								<th>Internal</th>
								<th>Total Labour</th>
						</tr>
				</thead>
				<tbody>
		';

        for ($b = 0; $b < count($data_workorder_labour); $b++) {
            $id_labour    = $data_workorder_labour[$b]->ID;
            $id_workorder = $data_workorder_labour[$b]->id_workorder;
            $internal     = $data_workorder_labour[$b]->internal;

            $c = $b + 1;
            $d = $c + 1;

            $f = $c + 40;
            $g = $c + 50;

            $h = $d + 40;

            $data_workorder = $this->master_model->select_in('ts_workorder', 'workorder_no, target_pcs, finish_good', "WHERE ID=$id_workorder");

            if ($data_workorder_labour[$b]->start_date == '0000-00-00') {
                $start_date = '';
            } else {
                $start_date = date('m/d/Y', strtotime($data_workorder_labour[$b]->start_date));
            }

            if ($data_workorder_labour[$b]->end_date == '0000-00-00') {
                $end_date = '';
            } else {
                $end_date = date('m/d/Y', strtotime($data_workorder_labour[$b]->end_date));
            }

            $code_supplier = $data_workorder_labour[$b]->code_supplier;

            $data_supplier = $this->master_model->select_in('ms_supplier', 'name', "WHERE code='$code_supplier'");

            echo '
					<tr>
						<td>
							' . $c . '
							<input type="hidden" name="id_labour[]" value="' . $id_labour . '">
						</td>
						<td>
							<a href="' . base_url() . 'admin/transaction/production_insert/33/' . $id_workorder . '">
								' . $data_workorder[0]->workorder_no . '
							</a>
						</td>
						<td>
                        	' . $data_workorder[0]->finish_good . '
                        </td>
						<td>
							' . $data_workorder_labour[$b]->name_inventory . '
						</td>
						<td>
                            ' . $data_supplier[0]->name . '
                            <input type="hidden" id="supplier_code_2' . $c . '" value="' . $data_workorder_labour[$b]->code_supplier . '">
                        </td>
						<td>
						   ' . date('d M Y', strtotime($data_workorder_labour[$b]->schedule_date)) . '
						</td>
						<td>
							' . date('d M Y', strtotime($data_workorder_labour[$b]->target_date)) . '
						</td>
						<td>
							<input type="text" name="start_date[]" placeholder="Start Date" id="datepicker' . $f . '" class="form-control" style="width:100px" value="' . $start_date . '"/>
						</td>
						<td>
							<input type="text" name="end_date[]" placeholder="End Date" id="datepicker' . $g . '" class="form-control" style="width:100px" value="' . $end_date . '"/>
						</td>
						';
            if ($data_workorder_labour[0]->requested == 0) {
                $display      = 'display:none';
                $finish       = 0;
                $disable_save = '';
            } else {
                $display      = 'display:block';
                $finish       = $data_workorder[0]->target_pcs;
                $disable_save = '';
            }

            echo '
									<td align="center">
										<script>
											$(function()
											{
												$(".requested' . $c . '").focusout(function()
												{
												   var done = $("#done' . $c . '").val();
												   var requested = $(this).val();

												   var bad=requested-done;

												   $( "#next_' . $b . '" ).show();

												   $(".requested_2_' . $h . '").html(done);
												   $(".requested_3_' . $h . '").val(done);

												   $(".bad' . $c . '").html(bad);
												   $("#bad' . $c . '").val(bad);

												   $("#done' . $c . '").focus();
												});
											});
										</script>
										<input type="text" name="requested[]" placeholder="Requested" class="form-control requested' . $c . '" style="width:50px" value="' . $data_workorder_labour[$b]->requested . '" id="requested' . $c . '" readonly="readonly"/>
									</td>

									<td align="center">
										<script>
											$(function()
											{
												$(".done' . $c . '").focusout(function()
												{
												   var requested = $("#requested' . $c . '").val();
												   var done = $(this).val();

												   var price = $("#price' . $c . '").val();

												   var bad=requested-done;

												   $( "#next_' . $h . '" ).show();

												   if(done > parseFloat(requested))
												   {
														var x = document.getElementById("snackbar")
														x.className = "show";
														x.innerHTML = "Done should not be greater than requested!";
														setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

														$(".requested_2_' . $h . '").html(requested);
													   $(".requested_3_' . $h . '").val(requested);

													   $(".bad' . $c . '").html(0);
													   $("#bad' . $c . '").val(0);

													   $("#done' . $c . '").val(requested);

													   //$("#done' . $d . '").val(done_bottm);
													   //$("#done' . $d . '").focus();


													   $(".target_pcs").html(requested);
													   $("#target_pcs").val(requested);
													   $(".finish").html(requested);
												   }else
												   {
													   $(".requested_2_' . $h . '").html(done);
													   $(".requested_3_' . $h . '").val(done);

													   $(".bad' . $c . '").html(bad);
													   $("#bad' . $c . '").val(bad);

													   $("#done' . $c . '").val(done);

													   //$("#done' . $d . '").val(done_bottm);
													   //$("#done' . $d . '").focus();


													   $(".target_pcs").html(done);
													   $("#target_pcs").val(done);
													   $(".finish").html(done);
												   }

												   $(".save").attr("disabled", true);
												});
											});
										</script>
										<script>
                                            $(function()
                                            {
                                                $("#pick_labour_' . $c . '").click(function()
                                                {
                                                   var ID = $(this).attr("alt");
                                                   var code_supplier = $("#supplier_code_2' . $c . '").val();
                                                   var date_in = ' . $today . ';
                                                   var requested = $("#requested' . $c . '").val();
                                                   var price = $("#price_' . $c . '").val();

                                                   var ID = ID+"--"+code_supplier+"--"+date_in+"--"+requested+"--"+price;

                                                   //alert(ID);
                                                   //return false;

                                                   $.ajax({
                                                        type: "POST",
                                                        dataType: "html",
                                                        url: "' . base_url() . 'admin/transaction/production_labour_pick/' . $menuid . '/' . $id_workorder . '",
                                                        data: "ID="+ID,
                                                        success: function(data)
                                                        {
                                                            $(".labour-content").html(data);
                                                        }
                                                    });
                                                });
                                            });
                                        </script>
										<div class="input-group">
	                                        <span alt="' . $id_labour . '"  class="input-group-addon" style="cursor:pointer; font-size:10px" id="pick_labour_' . $c . '" data-toggle="modal" data-target="#labour-modal">
	                                            <i class="fa fa-fw fa-plus"></i>
	                                        </span>
											<input type="text" name="done[]" placeholder="Done" class="form-control done' . $c . ' pull-left" style="width:50px" value="' . $data_workorder_labour[$b]->done . '" id="done' . $c . '"/>
										</div>
									</td>
								';
            echo '

						<td class="bad' . $c . '">
							';
            if ($start_date == '' || $end_date == '') {
                echo 0;
            } else {
                echo $data_workorder_labour[$b]->bad;
            }
            echo '
						</td>
						<td>
							<script>
								$(function()
								{
									$(".price_' . $c . '").focusout(function()
									{
										var price = $(this).val();
										var done = $("#done' . $c . '").val();

										$("#gross_ammount_' . $c . '").html(price*done);
									});
								});
							</script>
							<input type="text" name="price[]" placeholder="Cost" class="form-control price_' . $c . '" style="width:100px" id="price_' . $c . '" value="' . $data_workorder_labour[$b]->price . '"/>
						</td>
						<td align="center">
							<input type="hidden" name="bad[]" style="width:50px" value="' . $data_workorder_labour[$b]->bad . '" id="bad' . $c . '">
							<script>
								$(function()
								{
									$(".internal' . $c . '").click(function()
									{
										var ID = $(this).attr("alt");

										$.ajax({
											 type: "POST",
											 dataType: "html",
											 url: "' . base_url() . 'admin/transaction/change_internal/' . $menuid . '",
											 data:"ID="+ID,
											 success: function(msg)
											 {
												var x = document.getElementById("snackbar")
												x.className = "show";
												x.innerHTML = "Internal success change!";
												setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
												var internal = msg;
												var explode = internal.split("%");
												var icon  = explode[0];
												var inter  = explode[1];

												$("#change_icon' . $c . '").html(icon);
												$("#internal' . $c . '").val(inter);
											 }
										});
									});
								});
							</script>

							';
            if ($internal == 0) {
                $icon = '<i class="fa fa-square-o" aria-hidden="true"></i>';
            } else {
                $icon = '<i class="fa fa-check-square-o" aria-hidden="true"></i>';
            }
            echo '

							<a alt="' . $id_labour . '" class="text-blue internal' . $c . '" id="change_icon' . $c . '" style="cursor:pointer">
								' . $icon . '
							</a>

							<input type="hidden" name="internal[]" style="width:50px" value="' . $internal . '" id="internal' . $c . '">
						</td>

						<td align="right" style="font-weight:bold" id="gross_ammount_' . $c . '">
							' . $data_workorder_labour[$b]->gross_ammount . '
						</td>
					</tr>
				';
        }

        echo '
				</tbody>
				</table>


				<script>

				  $(function ()
				  {
				    $("#example2").DataTable(
				  	{
				  		"paging": true,
				  		"lengthMenu": [ 10, 20, 30, 40, 50 ],
				  		"pageLength": 10,
				  		"searching": true,
				  		//"ajax": "data/arrays.txt",
				  		"deferRender": true,
				  	});
				  });
				</script>
			';
    }

    public function done_process($modul, $menuid, $id_workorder)
    {
        //echo $id_workorder;
        //exit;

        //$data_workorder=$this->master_model->select_in('ts_workorder','workorder_no',"WHERE ID=$id_workorder");
        //$workorder_number=$data_workorder[0]->workorder_no;

        $data_workorder = $this->master_model->select_in('ts_workorder_material', 'ID, code_inventory', "WHERE id_workorder='$id_workorder'");
        //print_array($data_workorder);
        //exit;
        for ($d = 0; $d < count($data_workorder); $d++) {
            $id_workorder_detail = $data_workorder[$d]->ID;
            $code_inventory      = $data_workorder[$d]->code_inventory;

            $check_material_done = $this->master_model->mst_check_2('ts_workorder_material', "ID=$id_workorder_detail AND status='Close'");

            if ($check_material_done == false) {
                $data_update_workorder_material = array
                    (
                    'status' => 'Close',
                );
                $this->db->where('ID', $id_workorder_detail);
                $this->db->update('ts_workorder_material', $data_update_workorder_material);

                $data_stock_detail = $this->master_model->select_in('ts_stock_detail', 'ID, id_purchase_invoice, qty_waste, price', "WHERE id_workorder_detail='$id_workorder_detail' AND code_inventory='$code_inventory'");

                for ($a = 0; $a < count($data_stock_detail); $a++) {
                    $id_before           = $data_stock_detail[$a]->ID;
                    $id_purchase_invoice = $data_stock_detail[$a]->id_purchase_invoice;
                    $price               = $data_stock_detail[$a]->price;
                    $qty_waste           = $data_stock_detail[$a]->qty_waste;
                    $code_inventory      = $data_stock_detail[$a]->code_inventory;

                    $data_purchase_invoice = $this->master_model->select_in('ts_purchase_invoice', 'purchase_no', "WHERE ID=$id_purchase_invoice");
                    $purchase_no           = $data_purchase_invoice[0]->purchase_no;
                    $data_update_purchase  = array
                        (
                        'status' => 'Done',
                    );
                    $this->db->where('purchase_no', '$purchase_no');
                    $this->db->update('ts_purchase', $data_update_purchase);

                    if ($qty_waste != 0.00) {
                        $id_stock_detail          = $this->master_model->mst_last_id('ts_stock_detail');
                        $data_insert_stock_detail = array
                            (
                            'ID'             => $id_stock_detail,
                            //'id_workorder_detail'=>$id_workorder_detail,
                            'code_inventory' => $code_inventory,
                            'id_before'      => $id_before,
                            'price'          => $price,
                            'in_qty'         => $qty_waste,
                        );
                        $this->db->insert('ts_stock_detail', $data_insert_stock_detail);
                    }
                }
            }
        }

        $data_update_workorder = array
            (
            'status' => 'Done',
        );
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_update_workorder);

        redirect('admin/transaction/' . $modul . '/' . $menuid);
    }

    public function done_process_po($modul, $menuid, $id_purchase)
    {
        //echo $id_workorder;
        //exit;

        $data_update_purchase = array
            (
            'status' => 'Close',
        );
        $this->db->where('ID', $id_purchase);
        $this->db->update('ts_purchase', $data_update_purchase);

        /*
        $data_workorder=$this->master_model->select_in('ts_workorder','workorder_no',"WHERE ID=$id_workorder");
        $workorder_number=$data_workorder[0]->workorder_no;

        $data_stock_detail=$this->master_model->select_in('ts_stock_detail','ID, id_purchase_invoice, qty_waste, price',"WHERE wo_number='$workorder_number'");
        for($a=0; $a < count($data_stock_detail); $a++)
        {
        $id_before=$data_stock_detail[$a]->ID;
        $id_purchase_invoice=$data_stock_detail[$a]->id_purchase_invoice;
        $price=$data_stock_detail[$a]->price;
        $qty_waste=$data_stock_detail[$a]->qty_waste;

        $data_purchase_invoice=$this->master_model->select_in('ts_purchase_invoice','purchase_no',"WHERE ID=$id_purchase_invoice");
        $purchase_no=$data_purchase_invoice[0]->purchase_no;
        $data_update_purchase=array
        (
        'status'=>'Done',
        );
        $this->db->where('purchase_no', '$purchase_no');
        $this->db->update('ts_purchase', $data_update_purchase);

        $id_stock_detail=$this->master_model->mst_last_id('ts_stock_detail');
        $data_insert_stock_detail=array
        (
        'ID'=>$id_stock_detail,
        'id_before'=>$id_before,
        'price'=>$price,
        'in_qty'=>$qty_waste,
        );
        $this->db->insert('ts_stock_detail', $data_insert_stock_detail);
        }
         */

        redirect('admin/transaction/' . $modul . '/' . $menuid);
    }

    public function export_workorders($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after'");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/workorder/' . $menuid . '";
				</script>
			';
        } else {

            // merubah style border pada cell yang aktif (cell yang terisi)
            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            // melakukan pengaturan pada header kolom
            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            //membuat object baru bernama $objPHPExcel
            $objPHPExcel = new phpexcel();

            // data dibuat pada sheet pertama
            $objPHPExcel->setActiveSheetIndex(0);

            //style align
            $objPHPExcel->getActiveSheet()->setTitle('WORK ORDER STOCK CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'WORK ORDER STOCK CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status);

            for ($a = 0; $a < count($data_production); $a++) {
                $ID = $data_production[$a]->ID;

                $b     = $a + 1;
                $first = 4;

                $header = array('0' => 'A', '1' => 'B', '2' => 'C', '3' => 'D', '4' => 'E', '5' => 'F', '6' => 'G', '7' => 'H', '8' => 'I', '9' => 'J', '10' => 'K', '11' => 'L');

                $title = array('0' => 'No.', '1' => 'Workorder No.', '2' => 'Description', '3' => 'Schedule Date', '4' => 'Target Date', '5' => 'Start Date', '6' => 'End Date', '7' => 'Requested', '8' => 'Done', '9' => 'Bad', '10' => '@cost', '11' => 'Total Labour');

                //$data_workorder_labour_group=$this->master_model->select_in('ts_workorder_labour','*',"WHERE id_workorder=$ID");
                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID");
                $count_wo_labour       = count($data_workorder_labour);

                if ($a == 0) {
                    $c = $a + 4;
                } else {
                    $c = $c + $count_wo_labour;
                }

                $objPHPExcel->getActiveSheet()->setCellValue('A' . $c, 'WO Number : ' . $data_production[$a]->workorder_no . ' / Finish Good : ' . $data_production[$a]->finish_good . ' / Target Pcs : ' . $data_production[$a]->target_pcs . ' / Schedule Date : ' . date('d M Y', strtotime($data_production[$a]->date_schedule)) . ' / Target Date : ' . date('d M Y', strtotime($data_production[$a]->date_target)));

                $d = $c + 1;
                for ($h = 0; $h < count($header); $h++) {
                    $column = $header[$h] . $d;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $title[$h]);
                }

                $e = $d + 1;
                for ($g = 0; $g < count($data_workorder_labour_group); $g++) {
                    $h      = $g + 1;
                    $columg = $header[$h] . $e;
                    //$objPHPExcel->getActiveSheet()->setRowValue($columg, 'Test');
                }

                /*
                $e = $d + 1;
                for($w=0; $w < count($data_workorder_labour); $w++)
                {
                $b=$w+1;
                if($data_workorder_labour[$w]->start_date=='0000-00-00')
                {
                $start_date='';
                }else
                {
                $start_date=date('d M Y', strtotime($data_workorder_labour[$w]->start_date));
                }

                if($data_workorder_labour[$w]->end_date=='0000-00-00')
                {
                $end_date='';
                }else
                {
                $end_date=date('d M Y', strtotime($data_workorder_labour[$w]->end_date));
                }

                $isi[]= array('A' => $b, 'B' => $data_production[$a]->workorder_no, 'C' => $data_workorder_labour[$w]->name_inventory, 'D' => date('d M Y', strtotime($data_workorder_labour[$w]->schedule_date)), 'E' => date('d M Y', strtotime($data_workorder_labour[$w]->target_date)), 'F' => $start_date, 'G' => $end_date, 'H' => $data_workorder_labour[$w]->requested, 'I' => $data_workorder_labour[$w]->done, 'J' => $data_workorder_labour[$w]->bad, 'K' => $data_workorder_labour[$w]->price, 'L' => $data_workorder_labour[$w]->gross_ammount);
                }

                foreach($isi as $k => $v)
                {
                $col = $k + $e;

                foreach($v as $k1 => $v1)
                {
                $column = $k1.$col;
                $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);
                }
                }
                 */

                $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle('A' . $c . ':L' . $c)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
                $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(10);
                $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

                $objPHPExcel->getActiveSheet()->mergeCells('A1:L1');
                $objPHPExcel->getActiveSheet()->mergeCells('A2:L2');
                $objPHPExcel->getActiveSheet()->mergeCells('A' . $c . ':L' . $c);

                //set papersize
                $objPHPExcel->getActiveSheet()
                    ->getPageSetup()
                    ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
                $objPHPExcel->getActiveSheet()
                    ->getPageSetup()
                    ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

                $objPHPExcel->getActiveSheet()
                    ->getPageMargins()->setTop(0.25);
                $objPHPExcel->getActiveSheet()
                    ->getPageMargins()->setRight(0);
                $objPHPExcel->getActiveSheet()
                    ->getPageMargins()->setLeft(0);
                $objPHPExcel->getActiveSheet()
                    ->getPageMargins()->setBottom(0.25);

                $objPHPExcel->getActiveSheet()
                    ->setShowGridlines(true);
            }

            $tanggal  = date('d M Y H:i:s');
            $filename = 'WORKORDER ' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function export_wo78($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');
        // echo $status;
        // die;

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after'");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/workorder/' . $menuid . '";
				</script>
			';
        } else {
            header("Content-type: application/vnd-ms-excel");
            header("Content-Disposition: attachment; filename=WORK_ORDER_STOCK_CONTROL_REPORT78.xlsx");

            echo '
				<table>
				  <thead>
				  <tr>
				    <th>Firstname</th>
				    <th>Lastname</th>
				    <th>Age</th>
				  </tr>
				  </thead>
				  </table>
			';

        }
    }

    public function export_wo2()
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');
        // echo $status;
        // die;

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after'");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')");
        }

        $styleArray =
        array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array(
                        'argb' => '00000000',
                    ),
                ),
            ),
        );

        $objPHPExcel = new phpexcel();

        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->setTitle('WORK ORDER STOCK CONTROL REPORT');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        //set header kolom
        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'WORK ORDER STOCK CONTROL REPORT');
        $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status);

        $mulai_dari_no = 5;
        foreach ($data_production as $key => $produksi) {
            $header1 = 'WO header ' . $produksi->workorder_no;
            $header2 = 'MATERIAL';
            $header3 = 'LABOUR';

            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, $header1);
            $mulai_dari_no++;

            // ini data wo
            $border_header1_mulai = 'A' . $mulai_dari_no;
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, $header2);
            $mulai_dari_no++;

            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, 'NO');
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $mulai_dari_no, 'CODE');
            $mulai_dari_no++;

            $data_workorder_material = $this->master_model->select_in('ts_workorder_material', '*', "WHERE id_workorder=$produksi->ID");
            foreach ($data_workorder_material as $key2 => $wo) {
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, $key2 + 1);
                $objPHPExcel->getActiveSheet()->setCellValue('B' . $mulai_dari_no, $wo->code_inventory);
                $border_header1_akhir = 'B' . $mulai_dari_no;
                $mulai_dari_no++;
            }

            $objPHPExcel->getActiveSheet(0)->getStyle($border_header1_mulai . ':' . $border_header1_akhir)->applyFromArray($styleArray);
            $mulai_dari_no++;

            // ini data labor
            $border_header2_mulai = 'A' . $mulai_dari_no;
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, $header3);
            $mulai_dari_no++;

            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, 'NO');
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $mulai_dari_no, 'Description');
            $mulai_dari_no++;

            $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$produksi->ID ORDER BY ID ASC");
            foreach ($data_workorder_labour as $key3 => $labour) {
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, $key3 + 1);
                $objPHPExcel->getActiveSheet()->setCellValue('B' . $mulai_dari_no, $labour->name_inventory);
                $mulai_dari_no++;
            }
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $mulai_dari_no, 'TOTAL');
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $mulai_dari_no, 'ISI TOTAL');

            $border_header2_akhir = 'B' . $mulai_dari_no;

            $objPHPExcel->getActiveSheet(0)->getStyle($border_header2_mulai . ':' . $border_header2_akhir)->applyFromArray($styleArray);
            $mulai_dari_no++;
            $mulai_dari_no++;
        }

        $tanggal  = date('d M Y');
        $filename = 'TEST ' . $tanggal . '.xlsx';

        //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
        header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache

        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .XLSX Excel 2007 format
        $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->setPreCalculateFormulas(true);

        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
        exit;
    }

    public function export_wo($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');
        // echo $status;
        // die;

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after'");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/workorder/' . $menuid . '";
				</script>
			';
        } else {
            // header("Content-type: application/vnd-ms-excel");
            // header("Content-Disposition: attachment; filename=WORK_ORDER_STOCK_CONTROL_REPORT.xls");

            echo '
				<table>
					<thead>
						<tr>
							<th style="font-size:24px;" align="center">
								<strong>WORK ORDER STOCK CONTROL REPORT</strong>
							</th>
						<tr>
						<tr>
							<th align="center">
								Periode : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status . '
							</th>
						<tr>
					</thead>
					<tbody>
						';
            $count_labour = 0;
            for ($a = 0; $a < count($data_production); $a++) {
                $ID           = $data_production[$a]->ID;
                $workorder_no = $data_production[$a]->workorder_no;

                $b = $a + 1;

                echo '
									<tr>
										<td>
											<strong>WO </strong> : <em>' . $data_production[$a]->workorder_no . '</em> / <strong>Finish </strong> : <em>' . $data_production[$a]->finish_good . '</em> / <strong>Target </strong> : <em>' . $data_production[$a]->target_pcs . '</em> / <strong>Schedule </strong> : <em>' . date('d M Y', strtotime($data_production[$a]->date_schedule)) . '</em> / <strong>Target </strong> : <em>' . date('d M Y', strtotime($data_production[$a]->date_target)) . '</em>
										</td>
									</tr>

									<tr>
										<td colspan="11">
											<strong>MATERIAL</strong>
										</td>
									</tr>

									<tr>
										<td>
											<table border="1">
												<thead>
													<tr>
														<th>
															No.
														</th>
														<th>
															Code
														</th>
														<th colspan="3">
															Item
														</th>
														<th>
															Plan
														</th>
														<th colspan="2">
															Pick Material
														</th>
														<th>
															Used Material
														</th>
														<th>
															return Material
														</th>
														<th>
															Price
														</th>
														<th>
															Total Material
														</th>
													</tr>
												</thead>
												<tbody>
													';
                $data_workorder_material = $this->master_model->select_in('ts_workorder_material', '*', "WHERE id_workorder=$ID");

                $count_wo_material = count($data_workorder_material);

                for ($c = 0; $c < count($data_workorder_material); $c++) {
                    $d = $c + 1;

                    $id_material = $data_workorder_material[$c]->ID;

                    $code_inventory = $data_workorder_material[$c]->code_inventory;
                    $get_unit       = $this->master_model->select_in('ms_inventory', 'unit', "WHERE code='$code_inventory'");
                    $unit           = $get_unit[0]->unit;

                    $data_stock_detail = $this->master_model->data_stock_detail_2($id_material, $code_inventory);

                    // $data_stock_detail=$this->master_model->mst_left_join('a.in_qty, a.qty_use, a.qty_waste','ts_stock_detail','ts_purchase_detail',"ON a.id_purchase_detail = b.ID", "LEFT JOIN ts_purchase_invoice c ON a.id_purchase_invoice = c.ID", "WHERE (a.`id_workorder_detail` = '$id_material' or a.`id_workorder_detail` = '') AND b.code_inventory='$code_inventory' AND b.in_qty <> '' ORDER BY c.date_in DESC" );
                    echo '
																<tr>
																	<td>
																		' . $b . '
																	</td>
																	<td>
																	   ' . $data_workorder_material[$c]->code_inventory . '
																	</td>
																	<td colspan="3">
																		' . $data_workorder_material[$c]->name_inventory . '
																	</td>
																	<td>
																		' . $data_workorder_material[$c]->plan . '
																	</td>
																	<td colspan="2">
																		';
                    $pick_material       = '';
                    $total_pick_material = 0;
                    for ($in = 0; $in < count($data_stock_detail); $in++) {
                        if ($data_stock_detail[$in]->qty_use == 0) {
                            $pick_material = $pick_material . '';
                            $in_qty        = 0;
                        } else {
                            $pick_material = $pick_material . '' . $data_stock_detail[$in]->in_qty . ', ';
                            $in_qty        = $data_stock_detail[$in]->in_qty;
                        }

                        $total_pick_material = $total_pick_material + $in_qty;
                    }

                    $pick_material = substr($pick_material, 0, strlen($pick_material) - 1);
                    echo '
																		' . substr($pick_material, 0, -1) . ' = <strong>' . $total_pick_material . ' ' . $unit . '</strong>
																	</td>
																	<td>
																		' . $data_workorder_material[$c]->actual . ' ' . $unit . '
																	</td>

																	<td>
																		';
                    $return_material = '';
                    $total_qty_waste = 0;
                    for ($wa = 0; $wa < count($data_stock_detail); $wa++) {
                        if ($data_stock_detail[$wa]->qty_use == 0) {
                            $return_material = $return_material . '';
                            $qty_waste       = 0;
                        } else {
                            $return_material = $return_material . '' . $data_stock_detail[$wa]->qty_waste . ', ';
                            $qty_waste       = $data_stock_detail[$wa]->qty_waste;
                        }
                        $total_qty_waste = $total_qty_waste + $qty_waste;
                    }
                    $return_material = substr($return_material, 0, strlen($return_material) - 1);
                    echo '
																		' . substr($return_material, 0, -1) . ' = <strong>' . $total_qty_waste . ' ' . $unit . '</strong>
																	</td>

																	<td align="right">
																		' . money_format('%.2n', $data_workorder_material[$c]->price) . "\n" . '
																	</td>

																	<td align="right">
																		' . money_format('%.2n', $data_workorder_material[$c]->gross_ammount) . "\n" . '
																	</td>
																</tr>
															';
                }
                echo '

												</tbody
											</table>
										</td>
									</tr>

									<tr>
										<td colspan="11">
											<strong>LABOUR</strong>
										</td>
									</tr>

									<tr>
										<td>
											<table border="1">
												<thead>
													<tr>
														<th>
															No.
														</th>
														<th>
															Description
														</th>
														<th>
															Schedule Date
														</th>
														<th>
															Target Date
														</th>
														<th>
															Start Date
														</th>
														<th>
															End Date
														</th>
														<th>
															Supplier
														</th>
														<th>
															Requested
														</th>
														<th>
															Done
														</th>
														<th>
															Bad
														</th>
														<th>
															@cost
														</th>
														<th>
															Total Labour
														</th>
													</tr>
												</thead>
												<tbody>
													';
                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID ORDER BY ID ASC");
                $count_wo_labour       = count($data_workorder_labour);

                $count_labour = $count_labour + $count_wo_labour;

                if ($a == 0) {
                    $first = 8;
                } else {
                    $first = $count_labour + $count_wo_labour;
                }

                for ($c = 0; $c < count($data_workorder_labour); $c++) {
                    $d = $c + 1;

                    if ($a == 0) {
                        //$first=7;
                        $first_row = $first + $c;
                    } else {
                        //$first=7;
                        $first_row = $first + $c + 7;
                    }

                    //$last_row= 7 + $count_wo_labour;

                    $donex = 'H' . $first_row;
                    $costx = 'J' . $first_row;

                    if ($data_workorder_labour[$c]->start_date == '0000-00-00') {
                        $start_date = '';
                    } else {
                        $start_date = date('d M Y', strtotime($data_workorder_labour[$c]->start_date));
                    }

                    if ($data_workorder_labour[$c]->end_date == '0000-00-00') {
                        $end_date = '';
                    } else {
                        $end_date = date('d M Y', strtotime($data_workorder_labour[$c]->end_date));
                    }

                    $code_supplier = $data_workorder_labour[$c]->code_supplier;

                    $data_supplier = $this->master_model->select_in('ms_supplier', 'name', "WHERE code='$code_supplier'");
                    echo '
																<tr>
																	<td align="center">
																		' . $d . '
																	</td>
																	<td align="center">
																		' . $data_workorder_labour[$c]->name_inventory . '
																	</td>
																	<td align="center">
																		' . date('d M Y', strtotime($data_workorder_labour[$c]->schedule_date)) . '
																	</td>
																	<td align="center">
																		' . date('d M Y', strtotime($data_workorder_labour[$c]->target_date)) . '
																	</td>
																	<td align="center">
																		' . $start_date . '
																	</td>
																	<td align="center">
																		' . $end_date . '
																	</td>
																	<td>
																		' . $data_supplier[0]->name . '
																	</td>
																	<td>
																		' . $data_workorder_labour[$c]->requested . '
																	</td>
																	<td>
																		' . $data_workorder_labour[$c]->done . '
																	</td>
																	<td>
																		' . $data_workorder_labour[$c]->bad . '
																	</td>
																	<td>
																		' . $data_workorder_labour[$c]->price . '
																	</td>
																	<td>
																		' . $data_workorder_labour[$c]->gross_ammount . '
																	</td>
																</tr>
															';
                }
                echo '
													<tr>
														<td colspan="11" align="right">
															<strong>Total : </strong>
														</td>
														<td>
															<strong>' . $data_production[$a]->total_labour . '</strong>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
									<tr>
										<td>
										</td>
									</tr>
								';
            }
            echo '

					</tbody>
				</table>
			';

            $xls_to_convert = 'WORK_ORDER_STOCK_CONTROL_REPORT.xls';

            //------------------------------------------------------------------------------------

            // error_reporting(E_ALL);
            // ini_set('display_errors', TRUE);
            // ini_set('display_startup_errors', TRUE);
            // define('EOL',(PHP_SAPI == 'cli') ? PHP_EOL : '<br />');

            //These four lines are the entire script
            // require_once dirname(__FILE__) . '/PHPExcel/Classes/PHPExcel/IOFactory.php';
            // $objPHPExcel = PHPExcel_IOFactory::load(dirname(__FILE__) . '/' . $xls_to_convert);
            // $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            // $objWriter->save(str_replace('.xls', '.xlsx', $xls_to_convert));

            // echo 'File ' . str_replace('.xls', '.xlsx', $xls_to_convert) . ' created in ' , getcwd() , EOL;

        }
    }

    public function export_wo_reve($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');
        // echo "string";
        // die;

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after'");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/production/' . $menuid . '";
				</script>
			';
        } else {

            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            $objPHPExcel = new phpexcel();

            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setTitle('WORK ORDER STOCK CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A3')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->setCellValue('A7', 'No.');
            $objPHPExcel->getActiveSheet()->setCellValue('B7', 'Code.');
            $objPHPExcel->getActiveSheet()->setCellValue('C7', 'Item');
            $objPHPExcel->getActiveSheet()->setCellValue('D7', 'Plan');
            $objPHPExcel->getActiveSheet()->setCellValue('E7', 'Pick Material');
            $objPHPExcel->getActiveSheet()->setCellValue('F7', 'Used Material');
            $objPHPExcel->getActiveSheet()->setCellValue('G7', 'Return Material');
            $objPHPExcel->getActiveSheet()->setCellValue('H7', 'Price');
            $objPHPExcel->getActiveSheet()->setCellValue('I7', 'Total Material');
            // $objPHPExcel->getActiveSheet()->setCellValue('J7', 'HPP');
            // $objPHPExcel->getActiveSheet()->setCellValue('K7', 'Status');
            // $objPHPExcel->getActiveSheet()->setCellValue('L7', 'Last Process');

            for ($a = 0; $a < count($data_production); $a++) {
                $ID = $data_production[$a]->ID;

                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID");

                if ($data_workorder_labour[0]->start_date == '0000-00-00') {
                    $start_date = '-';
                } else {
                    $start_date = date('d M Y', strtotime($data_workorder_labour[0]->start_date));
                }

                if ($data_workorder_labour[0]->end_date == '0000-00-00') {
                    $end_date = '-';
                } else {
                    $end_date = date('d M Y', strtotime($data_workorder_labour[0]->end_date));
                }

                if ($data_production[$a]->finish == 0) {
                    $hpp = money_format('%.2n', 0) . "\n";
                } else {
                    $hpp = money_format('%.2n', $data_production[$a]->grandtotal / $data_production[$a]->finish) . "\n";
                }

                if ($data_production[$a]->status == 'Done') {
                    if ($data_workorder_labour[0]->start_date == '0000-00-00' || $data_workorder_labour[0]->end_date == '0000-00-00') {
                        $bad = 0;
                    } else {
                        $bad = $data_workorder_labour[0]->bad;
                    }
                } else {
                    $bad = '-';
                }

                $data_last_process = $this->master_model->select_in('ts_workorder_labour', 'name_inventory', "WHERE id_workorder = $ID AND requested <> 0 AND start_date <> '0000-00-00' ORDER BY ID DESC LIMIT 1");

                $name_inventory = $data_last_process[0]->name_inventory;

                if ($name_inventory == '') {
                    $last_process = 'Unprocess';
                } else {
                    $last_process = $data_last_process[0]->name_inventory;
                }

                $b = $a + 1;

                $isi[] = array('A' => $b, 'B' => $data_production[$a]->workorder_no, 'C' => date('d M Y', strtotime($data_production[$a]->date_schedule)), 'D' => date('d M Y', strtotime($data_production[$a]->date_target)), 'E' => $data_production[$a]->supplier_name, 'F' => $data_production[$a]->finish_good, 'G' => $data_production[$a]->finish, 'H' => $bad, 'I' => $data_production[$a]->grandtotal, 'J' => $hpp, 'K' => $data_production[$a]->status, 'L' => ucfirst($last_process));
            }

            $objPHPExcel->getActiveSheet()->getStyle('A4:K5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('A4:K5')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

            //set merge kolom
            $objPHPExcel->getActiveSheet()->mergeCells('A1:L1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:L2');
            $objPHPExcel->getActiveSheet()->mergeCells('A5:l5');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:l6');
            //$objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
            $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
            $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
            $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
            $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
            $objPHPExcel->getActiveSheet()->mergeCells('J4:J5');
            $objPHPExcel->getActiveSheet()->mergeCells('K4:K5');
            $objPHPExcel->getActiveSheet()->mergeCells('L4:L5');

            //set papersize
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setTop(0.25);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setRight(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setLeft(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setBottom(0.25);
            $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

            //set header kolom
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'WORK ORDER STOCK CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status);

            // melakukan pengisian data
            foreach ($isi as $k => $v) {
                $col = $k + 8;

                foreach ($v as $k1 => $v1) {
                    $column = $k1 . $col;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

                    $done = '=SUM(G7:G' . $col . ')';
                    $bad  = '=SUM(H7:H' . $col . ')';
                    $cost = '=SUM(I7:I' . $col . ')';
                    $hpp  = '=SUM(J7:J' . $col . ')';

                    //$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
                }
            }
            $tco = $col + 1;

            $objPHPExcel->getActiveSheet()->setCellValue('G' . $tco, $done);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $tco, $bad);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $tco, $cost);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $tco, $hpp);

            $objWorksheet = $objPHPExcel->getActiveSheet(0);
            $objWorksheet->getStyle('A4:' . $column)->applyFromArray($styleArray);

            $objWorksheet->getStyle('D6:D' . $col)->getNumberFormat()->setFormatCode('#,##0');
            $objWorksheet->getStyle('D' . $tco)->getNumberFormat()->setFormatCode('#,##0');
            $objPHPExcel->getActiveSheet()->getStyle('A7:A' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B7:B' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C7:C' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('D7:D' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('E7:E' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('I7:I' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B7:B' . $col)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('C' . $tco)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('D' . $tco)->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()
                ->getStyle('A7:A' . $col)
                ->getAlignment()
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setTextRotation(0);

            $tanggal  = date('d M Y');
            $filename = 'WORK ORDER STOCK CONTROL REPORT ' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->setPreCalculateFormulas(true);

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function export_wo_list($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');
        // echo "string";
        // die;

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after' ORDER BY ID DESC");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after')  ORDER BY ID DESC");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/production/' . $menuid . '";
				</script>
			';
        } else {

            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            $objPHPExcel = new phpexcel();

            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setTitle('WORK ORDER LIST CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
            $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Workorder No.');
            $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Schedule Date');
            $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Target Date');
            $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Customer');
            $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Barcode');
            $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Product');
            $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Done');
            $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Bad');
            $objPHPExcel->getActiveSheet()->setCellValue('J4', 'Cost');
            $objPHPExcel->getActiveSheet()->setCellValue('K4', 'HPP');
            $objPHPExcel->getActiveSheet()->setCellValue('L4', 'Status');
            $objPHPExcel->getActiveSheet()->setCellValue('M4', 'Last Process');

            for ($a = 0; $a < count($data_production); $a++) {
                $ID = $data_production[$a]->ID;

                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID");

                if ($data_workorder_labour[0]->start_date == '0000-00-00') {
                    $start_date = '-';
                } else {
                    $start_date = date('d M Y', strtotime($data_workorder_labour[0]->start_date));
                }

                if ($data_workorder_labour[0]->end_date == '0000-00-00') {
                    $end_date = '-';
                } else {
                    $end_date = date('d M Y', strtotime($data_workorder_labour[0]->end_date));
                }

                if ($data_production[$a]->finish == 0) {
                    $hpp = money_format('%.2n', 0) . "\n";
                } else {
                    $hpp = money_format('%.2n', $data_production[$a]->grandtotal / $data_production[$a]->finish) . "\n";
                }

                if ($data_production[$a]->status == 'Done') {
                    if ($data_workorder_labour[0]->start_date == '0000-00-00' || $data_workorder_labour[0]->end_date == '0000-00-00') {
                        $bad = 0;
                    } else {
                        $bad = $data_workorder_labour[0]->bad;
                    }
                } else {
                    $bad = '-';
                }

                $data_last_process = $this->master_model->select_in('ts_workorder_labour', 'name_inventory', "WHERE id_workorder = $ID AND requested <> 0 AND start_date <> '0000-00-00' ORDER BY ID DESC LIMIT 1");

                $name_inventory = $data_last_process[0]->name_inventory;

                if ($name_inventory == '') {
                    $last_process = 'Unprocess';
                } else {
                    $last_process = $data_last_process[0]->name_inventory;
                }

                $b = $a + 1;

                $isi[] = array('A' => $b, 'B' => $data_production[$a]->workorder_no, 'C' => date('d M Y', strtotime($data_production[$a]->date_schedule)), 'D' => date('d M Y', strtotime($data_production[$a]->date_target)), 'E' => $data_production[$a]->supplier_name, 'F' => $data_production[$a]->product_code, 'G' => $data_production[$a]->finish_good, 'H' => $data_production[$a]->finish, 'I' => $bad, 'J' => $data_production[$a]->grandtotal, 'K' => $hpp, 'L' => $data_production[$a]->status, 'M' => ucfirst($last_process));
            }

            $objPHPExcel->getActiveSheet()->getStyle('A4:M5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('A4:M5')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);

            //set merge kolom
            $objPHPExcel->getActiveSheet()->mergeCells('A1:L1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:L2');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
            $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
            $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
            $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
            $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
            $objPHPExcel->getActiveSheet()->mergeCells('J4:J5');
            $objPHPExcel->getActiveSheet()->mergeCells('K4:K5');
            $objPHPExcel->getActiveSheet()->mergeCells('L4:L5');
            $objPHPExcel->getActiveSheet()->mergeCells('M4:M5');

            //set papersize
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setTop(0.25);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setRight(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setLeft(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setBottom(0.25);
            $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

            //set header kolom
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'WORK ORDER LIST CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status);

            // melakukan pengisian data
            foreach ($isi as $k => $v) {
                $col = $k + 6;

                foreach ($v as $k1 => $v1) {
                    $column = $k1 . $col;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

                    $done = '=SUM(H6:H' . $col . ')';
                    $bad  = '=SUM(I6:I' . $col . ')';
                    $cost = '=SUM(J6:J' . $col . ')';
                    $hpp  = '=SUM(K6:K' . $col . ')';

                    //$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
                }
            }
            $tco = $col + 1;

            $objPHPExcel->getActiveSheet()->setCellValue('H' . $tco, $done);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $tco, $bad);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $tco, $cost);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $tco, $hpp);

            $objWorksheet = $objPHPExcel->getActiveSheet(0);
            $objWorksheet->getStyle('A4:' . $column)->applyFromArray($styleArray);

            $objWorksheet->getStyle('D6:D' . $col)->getNumberFormat()->setFormatCode('#,##0');
            $objWorksheet->getStyle('D' . $tco)->getNumberFormat()->setFormatCode('#,##0');
            $objPHPExcel->getActiveSheet()->getStyle('A6:A' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C6:C' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('D6:D' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('E6:E' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('I6:I' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('C' . $tco)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('D' . $tco)->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()
                ->getStyle('A6:A' . $col)
                ->getAlignment()
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setTextRotation(0);

            $tanggal  = date('d M Y');
            $filename = 'WORK ORDER LIST CONTROL REPORT' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->setPreCalculateFormulas(true);

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function export_production($menuid)
    {
        $before = $this->input->get('before');
        $after  = $this->input->get('after');
        $status = $this->input->get('status');

        if ($status == 'All') {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE date_schedule BETWEEN '$before' AND '$after' ORDER BY workorder_no DESC");
        } else {
            $data_production = $this->master_model->select_in('ts_workorder', '*', "WHERE status='$status' AND (date_schedule BETWEEN '$before' AND '$after') ORDER BY workorder_no DESC");
        }

        $count_purchase = count($data_production);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or status!!")
					window.location.href="' . base_url() . 'admin/transaction/production/' . $menuid . '";
				</script>
			';
        } else {

            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            $objPHPExcel = new phpexcel();

            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setTitle('PRODUCTION CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
            $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Workorder No.');
            $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Barcode');
            $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Product');
            $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Target Pcs');
            $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Finish');
            $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Status');
            $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Schedule');
            $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Target');
            /*$objPHPExcel->getActiveSheet()->setCellValue('I4', 'Start Date');
            $objPHPExcel->getActiveSheet()->setCellValue('J4', 'End Date');*/

            for ($a = 0; $a < count($data_production); $a++) {
                $ID = $data_production[$a]->ID;

                $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE id_workorder=$ID");

                if ($data_workorder_labour[0]->start_date == '0000-00-00') {
                    $start_date = '-';
                } else {
                    $start_date = date('d M Y', strtotime($data_workorder_labour[0]->start_date));
                }

                if ($data_workorder_labour[0]->end_date == '0000-00-00') {
                    $end_date = '-';
                } else {
                    $end_date = date('d M Y', strtotime($data_workorder_labour[0]->end_date));
                }

                $b = $a + 1;

                $isi[] = array('A' => $b, 'B' => $data_production[$a]->workorder_no, 'C' => $data_production[$a]->product_code, 'D' => $data_production[$a]->finish_good, 'E' => $data_production[$a]->target_pcs, 'F' => $data_production[$a]->finish, 'G' => $data_production[$a]->status, 'H' => date('d M Y', strtotime($data_production[$a]->date_schedule)), 'I' => date('d M Y', strtotime($data_production[$a]->date_target)));
            }

            $objPHPExcel->getActiveSheet()->getStyle('A4:H5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('E')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('F')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('A4:H5')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);

            //set merge kolom
            $objPHPExcel->getActiveSheet()->mergeCells('A1:H1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:H2');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
            $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
            $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
            $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
            $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
            $objPHPExcel->getActiveSheet()->mergeCells('J4:J5');

            //set papersize
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setTop(0.25);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setRight(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setLeft(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setBottom(0.25);
            $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

            //set header kolom
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'PRODUCTION CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($after)) . ', Status : ' . $status);

            // melakukan pengisian data
            foreach ($isi as $k => $v) {
                $col = $k + 6;

                foreach ($v as $k1 => $v1) {
                    $column = $k1 . $col;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

                    $subtotal = '=I' . $col . '*K' . $col;

                    $target = '=SUM(E6:E' . $col . ')';
                    $finish = '=SUM(F6:F' . $col . ')';

                    //$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
                }
            }
            $tco = $col + 1;

            $objPHPExcel->getActiveSheet()->setCellValue('E' . $tco, $target);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $tco, $finish);

            $objWorksheet = $objPHPExcel->getActiveSheet(0);
            $objWorksheet->getStyle('A4:' . $column)->applyFromArray($styleArray);

            $objWorksheet->getStyle('E6:F' . $col)->getNumberFormat()->setFormatCode('#,##0');
            $objWorksheet->getStyle('E' . $tco)->getNumberFormat()->setFormatCode('#,##0');

            $objPHPExcel->getActiveSheet()->getStyle('A6:A' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C6:C' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('D6:D' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('E6:E' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('F6:F' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('G6:G' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('H6:H' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('I6:I' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('J6:J' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('D' . $tco)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('E' . $tco)->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()
                ->getStyle('A6:A' . $col)
                ->getAlignment()
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setTextRotation(0);

            $tanggal  = date('d M Y');
            $filename = 'PRODUCTION CONTROL REPORT ' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->setPreCalculateFormulas(true);

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function export_wo_labour($menuid)
    {
        $today = $this->input->get('date_today');

        $data_workorder_labour = $this->master_model->select_in('ts_workorder_labour', '*', "WHERE (`schedule_date` = '$today'  AND requested <> 0) OR (`schedule_date` < '$today' AND done = 0 AND requested <> 0) ORDER BY schedule_date ASC");

        $count_wo_labour = count($data_workorder_labour);

        if ($count_wo_labour == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date!!")
					window.location.href="' . base_url() . 'admin/transaction/production_labour/' . $menuid . '";
				</script>
			';
        } else {
            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            $objPHPExcel = new phpexcel();

            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setTitle('PRODUCTION LABOUR REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            for ($a = 0; $a < count($data_workorder_labour); $a++) {
                $id_labour    = $data_workorder_labour[$a]->ID;
                $id_workorder = $data_workorder_labour[$a]->id_workorder;
                $internal     = $data_workorder_labour[$a]->internal;

                if ($internal == 1) {
                    $internal = 'Yes';
                } else {
                    $internal = 'No';
                }

                $b = $a + 1;

                $data_workorder = $this->master_model->select_in('ts_workorder', 'workorder_no, target_pcs', "WHERE ID=$id_workorder");

                if ($data_workorder_labour[$a]->start_date == '0000-00-00') {
                    $start_date = '';
                } else {
                    $start_date = date('m/d/Y', strtotime($data_workorder_labour[$a]->start_date));
                }

                if ($data_workorder_labour[$a]->end_date == '0000-00-00') {
                    $end_date = '';
                } else {
                    $end_date = date('m/d/Y', strtotime($data_workorder_labour[$a]->end_date));
                }

                $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
                $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Workorder No.');
                $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Description');
                $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Schedule Date');
                $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Target Date');
                $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Start Date');
                $objPHPExcel->getActiveSheet()->setCellValue('G4', 'End Date');
                $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Requested');
                $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Done');
                $objPHPExcel->getActiveSheet()->setCellValue('J4', 'Bad');
                $objPHPExcel->getActiveSheet()->setCellValue('K4', '@Cost');
                $objPHPExcel->getActiveSheet()->setCellValue('L4', 'Internal');
                $objPHPExcel->getActiveSheet()->setCellValue('M4', 'Total Labour');

                $isi[] = array('A' => $b, 'B' => $data_workorder[0]->workorder_no, 'C' => $data_workorder_labour[$a]->name_inventory, 'D' => date('d M Y', strtotime($data_workorder_labour[$a]->schedule_date)), 'E' => date('d M Y', strtotime($data_workorder_labour[$a]->target_date)), 'F' => $start_date, 'G' => $end_date, 'H' => $data_workorder_labour[$a]->requested, 'I' => $data_workorder_labour[$a]->done, 'J' => $data_workorder_labour[$a]->bad, 'K' => $data_workorder_labour[$a]->price, 'L' => $internal, 'M' => $data_workorder_labour[$a]->gross_ammount);
            }

            $objPHPExcel->getActiveSheet()->getStyle('A4:M5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('E')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('F')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('A4:M5')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);

            //set merge kolom
            $objPHPExcel->getActiveSheet()->mergeCells('A1:M1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:M2');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
            $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
            $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
            $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
            $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
            $objPHPExcel->getActiveSheet()->mergeCells('J4:J5');
            $objPHPExcel->getActiveSheet()->mergeCells('K4:K5');
            $objPHPExcel->getActiveSheet()->mergeCells('L4:L5');
            $objPHPExcel->getActiveSheet()->mergeCells('M4:M5');

            //set papersize
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setTop(0.25);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setRight(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setLeft(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setBottom(0.25);
            $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

            //set header kolom
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'PRODUCTION LABOUR REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($today)));

            // melakukan pengisian data
            foreach ($isi as $k => $v) {
                $col = $k + 6;

                foreach ($v as $k1 => $v1) {
                    $column = $k1 . $col;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

                    $subtotal = '=I' . $col . '*K' . $col;

                    $requested    = '=SUM(H6:H' . $col . ')';
                    $done         = '=SUM(I6:I' . $col . ')';
                    $bad          = '=SUM(J6:J' . $col . ')';
                    $cost         = '=SUM(K6:K' . $col . ')';
                    $total_labour = '=SUM(M6:M' . $col . ')';

                    $objPHPExcel->getActiveSheet()->setCellValue('M' . $col, $subtotal);
                }
            }
            $tco = $col + 1;

            $objPHPExcel->getActiveSheet()->setCellValue('H' . $tco, $requested);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $tco, $done);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $tco, $bad);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $tco, $cost);
            $objPHPExcel->getActiveSheet()->setCellValue('M' . $tco, $total_labour);

            $objWorksheet = $objPHPExcel->getActiveSheet(0);
            $objWorksheet->getStyle('A4:' . $column)->applyFromArray($styleArray);

            $objWorksheet->getStyle('D6:D' . $col)->getNumberFormat()->setFormatCode('#,##0');
            $objWorksheet->getStyle('D' . $tco)->getNumberFormat()->setFormatCode('#,##0');
            $objPHPExcel->getActiveSheet()->getStyle('A6:A' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C6:C' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('D6:D' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('E6:E' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('I6:I' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('C' . $tco)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('D' . $tco)->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()
                ->getStyle('A6:A' . $col)
                ->getAlignment()
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setTextRotation(0);

            $tanggal  = date('d M Y');
            $filename = 'PRODUCTION LABOUR REPORT ' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->setPreCalculateFormulas(true);

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function export_purchase($menuid, $before, $today, $search)
    {
        if ($search == '') {
            $data_purchase = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE date_in BETWEEN '$before' AND '$today' ORDER BY ID DESC");
        } else {
            $data_purchase = $this->master_model->select_in('ts_purchase_invoice', '*', "WHERE supplier_code LIKE '%$search%' OR supplier_name LIKE '%$search%' ORDER BY ID DESC");
        }

        $count_purchase = count($data_purchase);

        if ($count_purchase == 0) {
            echo '
				<script language="javascript">
					window.alert("No transaction data to export on that date or supplier!!")
					window.location.href="' . base_url() . 'admin/transaction/purchase_invoice/' . $menuid . '";
				</script>
			';
        } else {

            $styleArray =
            array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array(
                            'argb' => '00000000',
                        ),
                    ),
                ),
            );

            $fontHeader = array(
                'font'      => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                    'rotation'   => 0,

                ),
                'fill'      => array(
                    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'F7F7F8'),
                ),
            );

            $objPHPExcel = new phpexcel();

            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setTitle('PURCHASE INVOICE CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
            $objPHPExcel->getActiveSheet()->setCellValue('B4', 'Purchase Invoice');
            $objPHPExcel->getActiveSheet()->setCellValue('C4', 'Purchase Order');
            $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Date');
            $objPHPExcel->getActiveSheet()->setCellValue('E4', 'Supplier');
            $objPHPExcel->getActiveSheet()->setCellValue('F4', 'Amount');
            $objPHPExcel->getActiveSheet()->setCellValue('G4', 'Paid');
            $objPHPExcel->getActiveSheet()->setCellValue('H4', 'Due');
            $objPHPExcel->getActiveSheet()->setCellValue('I4', 'Admin');

            for ($a = 0; $a < count($data_purchase); $a++) {
                $b  = $a + 1;
                $ID = $data_purchase[$a]->ID;

                $purchase_no = $data_purchase[$a]->purchase_no;
                $id_admin    = $data_purchase[$a]->id_admin;
                $get_admin   = $this->master_model->select_in('user', 'name', "WHERE ID='$id_admin'");

                $supplier_code = $data_purchase[$a]->supplier_code;

                if ($data_purchase[$a]->status == 'Active') {
                    $text = 'class="text-blue"';
                } elseif ($data_purchase[$a]->status == 'Canceled') {
                    $text = 'class="text-red"';
                }

                $payment_term = $data_purchase[$a]->due;

                $date_in = strtotime($data_purchase[$a]->date_in);
                $due     = strtotime('+' . $payment_term . ' day', $date_in);
                $due     = date('d M Y', $due);

                $isi[] = array('A' => $b, 'B' => $data_purchase[$a]->purchase_invoice_no, 'C' => $data_purchase[$a]->purchase_no, 'D' => date('d M Y', strtotime($data_purchase[$a]->date_in)), 'E' => $data_purchase[$a]->supplier_name, 'F' => $data_purchase[$a]->ammount, 'G' => $data_purchase[$a]->paid, 'H' => $due, 'I' => $get_admin[0]->name);
            }

            $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('E')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('F')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('A4:I5')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);

            //set merge kolom
            $objPHPExcel->getActiveSheet()->mergeCells('A1:I1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:I2');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
            $objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
            $objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
            $objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
            $objPHPExcel->getActiveSheet()->mergeCells('I4:I5');

            //set papersize
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $objPHPExcel->getActiveSheet()
                ->getPageSetup()
                ->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setTop(0.25);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setRight(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setLeft(0);
            $objPHPExcel->getActiveSheet()
                ->getPageMargins()->setBottom(0.25);
            $objPHPExcel->getActiveSheet()
                ->setShowGridlines(true);

            //set header kolom
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'PURCHASE INVOICE CONTROL REPORT');
            $objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : ' . date('d M Y', strtotime($before)) . ' - ' . date('d M Y', strtotime($today)));

            // melakukan pengisian data
            foreach ($isi as $k => $v) {
                $col = $k + 6;

                foreach ($v as $k1 => $v1) {
                    $column = $k1 . $col;
                    $objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

                    $subtotal = '=I' . $col . '*K' . $col;

                    $amount_total = '=SUM(F6:F' . $col . ')';
                    $paid_total   = '=SUM(G6:G' . $col . ')';

                    //$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
                }
            }
            $tco = $col + 1;

            $objPHPExcel->getActiveSheet()->setCellValue('F' . $tco, $amount_total);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $tco, $paid_total);

            $objWorksheet = $objPHPExcel->getActiveSheet(0);
            $objWorksheet->getStyle('A4:' . $column)->applyFromArray($styleArray);

            $objWorksheet->getStyle('D6:E' . $col)->getNumberFormat()->setFormatCode('#,##0');
            $objWorksheet->getStyle('D' . $tco)->getNumberFormat()->setFormatCode('#,##0');

            $objPHPExcel->getActiveSheet()->getStyle('A6:A' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('C6:C' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('D6:D' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('E6:E' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('F6:F' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('G6:G' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('H6:H' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('I6:I' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('J6:J' . $col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $objPHPExcel->getActiveSheet()->getStyle('B6:B' . $col)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('C' . $tco)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle('D' . $tco)->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()
                ->getStyle('A6:A' . $col)
                ->getAlignment()
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setTextRotation(0);

            $tanggal  = date('d M Y');
            $filename = 'PURCHASE INVOICE CONTROL REPORT ' . $tanggal . '.xlsx';

            //$filename='just_some_random_name.xlsx'; //save our workbook as this file name
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
            header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache

            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->setPreCalculateFormulas(true);

            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
            exit;
        }
    }

    public function insert_wo_labour_detail($menuid, $id_workorder, $count_loop)
    //function insert_wo_labour_detail($menuid, $id_workorder)
    {

        // echo "string";
        // print_array($this->input->post());
        // exit;
        //$post="4--SST1--09/02/2021--300--100";
        $post = $this->input->post('ID');

        $explode             = explode('--', $post);
        $id_workorder_labour = $explode[0];
        $supplier            = $explode[1];
        $date_in             = $explode[2];
        $qty                 = $explode[3];
        $price               = $explode[4];

        $ID                           = $this->master_model->mst_last_id('ts_workorder_labour_detail');
        $data_workorder_labour_detail = array
            (
            'ID'                  => $ID,
            'id_workorder_labour' => $id_workorder_labour,
            'code_supplier'       => $supplier,
            'date_done'           => date('Y-m-d', strtotime($date_in)),
            'qty'                 => $qty,
            'price'               => $price,
            'subtotal'            => $qty * $price,
        );
        $this->db->insert('ts_workorder_labour_detail', $data_workorder_labour_detail);

        //new code
        $get_workorder_no   = $this->master_model->select_in('ts_workorder', 'workorder_no,finish_good', "WHERE ID=$id_workorder");
        $get_workorder_no1  = $get_workorder_no[0]->workorder_no;
        $get_workorder_fn   = $get_workorder_no[0]->finish_good;
        $get_workorder_code = $this->master_model->select_in('ts_workorder_labour', 'code_supplier,code_supplier,code_inventory,name_inventory,price', "WHERE ID=$id_workorder_labour");

        $get_workorder_codes = $get_workorder_code[0]->code_supplier;
        $get_workorder_code1 = $get_workorder_code[0]->code_inventory;
        $get_workorder_code2 = $get_workorder_code[0]->name_inventory;
        $get_workorder_code3 = $get_workorder_code[0]->price;

        $get_workorder_type  = $this->master_model->select_in('ms_inventory', 'id_category, name, type', "WHERE code = '$get_workorder_code1'");
        $get_workorder_type1 = $get_workorder_type[0]->id_category;
        $get_workorder_type2 = $get_workorder_type[0]->type;
        $get_workorder_type3 = $get_workorder_type[0]->name;

        $get_workorder_supplayer  = $this->master_model->select_in('ms_supplier', 'name, Status', "WHERE code = '$supplier'");
        $get_workorder_supplayer1 = $get_workorder_supplayer[0]->name;
        $get_workorder_status     = $get_workorder_supplayer[0]->Status;
        //print_r($get_workorder_supplayer1);

        $get_workorder_category = $this->master_model->select_in('ms_inventory_category', 'name', "WHERE ID = '$get_workorder_type1'");
        // echo '<pre>';
        $get_workorder_category1 = $get_workorder_category[0]->name;
        //end  new code

        $sum_subtotal_detail = $this->master_model->select_in('ts_workorder_labour_detail', 'SUM(subtotal) AS subtotal_detail, SUM(qty) AS qty_detail', "WHERE id_workorder_labour=$id_workorder_labour");
        $subtotal_detail     = $sum_subtotal_detail[0]->subtotal_detail;
        $qty_detail          = $sum_subtotal_detail[0]->qty_detail;

        $data_workorder_labour = array
            (
            'end_date'      => date('Y-m-d', strtotime($date_in)),
            'gross_ammount' => $subtotal_detail,
            'done'          => $qty,
        );
        $this->db->where('ID', $id_workorder_labour);
        $this->db->update('ts_workorder_labour', $data_workorder_labour);

        $sum_subtotal = $this->master_model->select_in('ts_workorder_labour', 'SUM(gross_ammount) AS subtotal', "WHERE id_workorder=$id_workorder");
        $subtotal     = $sum_subtotal[0]->subtotal;

        $sum_material      = $this->master_model->select_in('ts_workorder_material', 'SUM(gross_ammount) AS subtotal_material', "WHERE id_workorder=$id_workorder");
        $subtotal_material = $sum_material[0]->subtotal_material;

        $data_workorder = array
            (
            'total_labour' => $subtotal,
            'grandtotal'   => $subtotal + $subtotal_material,
            'last_process' => $get_workorder_code2,
        );
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_workorder);
        //new code
        $id_category   = 935844;
        $data_supplier = array('display_name' => $supplier,
            'associate_company'                   => $get_workorder_type3,
            'billing_address'                     => $supplier,
            'address'                             => 'alamat masih kosong',
            'phone'                               => '08129834',
            'mobile'                              => '0210432',
            'email'                               => 'day@gmail.com',

            'disable_max_credit_limit'            => false,

            'start_balance'                       => '21-04-2016',
            'opening_balance'                     => 'dxdiag',
            'no_npwp'                             => '000',
            'source'                              => 'source',
            'tax_no'                              => 'tax-no-1',
            'other_detail'                        => 'others',
            'custom_id'                           => $ID,
        );
        // $this->jurnal->use_json = false;
        $response = $this->jurnal->addVendors($data_supplier);

        $data_jurnal[] = array(
            'name'         => $get_workorder_type3,
            'unit_name'    => $get_workorder_type2,
            'sell_price'   => $get_workorder_code3,
            'code'         => $get_workorder_code1,
            'buy_price'    => 0,
            'desckripsi'   => $get_workorder_code1,
            'code_product' => $get_workorder_code1,
            'type'         => $get_workorder_type2,
            'id_category'  => $id_category,

            'ip_id'        => $_SERVER['SERVER_ADDR'],
            'auth_key'     => 'test',
            'password'     => 'dgasgadsg@dfgsdfgsdf3535353',

        );
        // print_r($data_jurnal);
        // die();
        $response1 = $this->jurnal->addProductsn($data_jurnal);
//         echo "<pre>";
        // print_r([$_POST, $explode, $id_workorder_labour, $supplier, $count_loop, $data_supplier, $response1, $data_jurnal]);
        //         die();

        $data = array(
            'id_detail'           => $id_workorder_labour,
            'unit_name'           => $get_workorder_supplayer1,
            'PPN'                 => $get_workorder_status,
            'sell_price'          => $qty * $price,
            'code'                => $get_workorder_code1,
            'buy_price'           => $subtotal,
            'desckripsi'          => $qty,
            'code_product'        => $get_workorder_code1,
            'discont'             => '0',

            'ID'                  => $ID,

            'purchase_invoice_no' => $get_workorder_no1 . '/' . $get_workorder_fn,

            'qty'                 => $qty,
            'price'               => $price,
            'name'                => $get_workorder_code2,
            'type'                => $get_workorder_type2,
            'date_in'             => date('Y-m-d', strtotime($date_in)),
            'purchase_no'         => $id_workorder_labour,

            'supplier_name'       => $get_workorder_code2,

            'note'                => $id_workorder_labour,

            'supplier_code'       => $supplier,
            'stock_no'            => $id_workorder_labour,
            'ref_no'              => $subtotal + $subtotal_material,

            'sort'                => $ID,

        );

        @$responseInv = $this->jurnal->addPurchaseInvoiceWorkorder_n($data);
//         echo "<pre>";
        // print_r([$_POST, $explode, $id_workorder_labour, $supplier, $count_loop, $data_supplier, $data, $responseInv]);
        //         die();
        if ($responseInv->success == true) {
            // ini sukses masuk jurnal
            $id5 = $responseInv->data->purchase_invoice->id;

            $id_jurnal_po_invoice_labour1 = array
                (
                'id_jurnal_workorder_labour' => $id5,
            );
            $this->db->where('ID', $ID);
            $this->db->update('ts_workorder_labour_detail', $id_jurnal_po_invoice_labour1);

            $this->session->set_flashdata('message', '<div class="alert alert-success">Successfully processed</div>');
        } else {
            // gagal masuk jurnal
            foreach ($responseInv->pesan as $key => $text) {
                $this->session->set_flashdata('message', '<div class="alert alert-danger">' . $text . '</div>');
            }
        }
        //end new code
        if ($count_loop == 'Yes') {
            $data_workorder = array
                (
                'finish' => $qty_detail,
            );
            $this->db->where('ID', $id_workorder);
            $this->db->update('ts_workorder', $data_workorder);
        }

        $this->load->view('admin/transaction/production_labour_pick');
    }

    public function delete_labour_detail($menuid, $id_workorder, $id_workorder_labour, $ID)
    {
        $get_subtotal_labour = $this->master_model->select_in('ts_workorder_labour', 'gross_ammount', "WHERE ID=$id_workorder_labour");
        $subtotal_labour     = $get_subtotal_labour[0]->gross_ammount;

        //echo $subtotal_labour;
        //exit;

        //$get_subtotal=$this->master_model->select_in('ts_workorder_labour_detail','subtotal',"WHERE ID=$ID");
        // new code
        $get_subtotal                = $this->master_model->select_in('ts_workorder_labour_detail', 'subtotal,id_jurnal_workorder_labour', "WHERE ID=$ID");
        $id_jurnal_workorder_labour1 = $get_subtotal[0]->id_jurnal_workorder_labour;
        // echo "<pre>";
        // print_r([$subtotal_labour, $id_jurnal_workorder_labour1]);
        // die();
        // end new code
        $subtotal = $get_subtotal[0]->subtotal;

        $gross_ammount = $subtotal_labour - $subtotal;

        $data_workorder_labour = array
            (
            'gross_ammount' => $gross_ammount,
        );
        $this->db->where('ID', $id_workorder_labour);
        $this->db->update('ts_workorder_labour', $data_workorder_labour);

        $sum_material      = $this->master_model->select_in('ts_workorder_material', 'SUM(gross_ammount) AS subtotal_material', "WHERE id_workorder=$id_workorder");
        $subtotal_material = $sum_material[0]->subtotal_material;

        $data_workorder = array
            (
            'total_labour' => $gross_ammount,
            'grandtotal'   => $subtotal_material + $gross_ammount,
        );
        $this->db->where('ID', $id_workorder);
        $this->db->update('ts_workorder', $data_workorder);
        //star new code
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/purchase_invoice/delete_workorder_labour");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            http_build_query(array('date' => date("d/m/Y"),

                'id'                          => $id_jurnal_workorder_labour1,
                'ip_id'                       => $_SERVER['SERVER_ADDR'],
                'auth_key'                    => 'test',
                'password'                    => 'dgasgadsg@dfgsdfgsdf3535353',

            )));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $error_msg     = curl_error($ch);
        $this->session->set_flashdata('message', '<div class="alert alert-success">Successfully Delete</div>');
        //end new code

        $this->db->where('ID', $ID);
        $this->db->delete('ts_workorder_labour_detail');

        $this->load->view('admin/transaction/production_labour_pick');
    }

    public function update_finish($menuid, $ID)
    {
        $done = $this->input->post('done');

        $update = array
            (
            'finish' => $done,
        );
        $this->db->where('ID', $ID);
        $this->db->update('ts_workorder', $update);
    }

    public function history_labour($menuid, $workorder_no)
    {
        $ID = $this->input->post('ID');

        $data_last_process = $this->master_model->select_in('ts_workorder_labour a LEFT JOIN ms_inventory b ON a.code_inventory = b.code', 'b. name AS name_inventory, a.start_date, a.requested', "WHERE a.id_workorder = $ID ORDER BY a.ID ASC");

        $last_process = $this->master_model->select_in('ts_workorder_labour a LEFT JOIN ms_inventory b ON a.code_inventory = b.code', 'b.name AS name_inventory', "WHERE a.id_workorder = $ID AND a.requested <> 0 AND a.start_date <> '0000-00-00' ORDER BY a.ID DESC LIMIT 1");
        //$last_process = $this->master_model->select_in('ts_workorder_labour', 'name_inventory', "WHERE id_workorder = $ID AND requested <> 0 AND start_date <> '0000-00-00' ORDER BY ID DESC LIMIT 1");
        echo '
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">History Labour ' . $workorder_no . '</h4>
			</div>
			<div class="modal-body">
				<table class="table table-bordered table-striped purchase_detail">
					<thead>
						<tr>
							<th>
								No
							</th>
							<th>
								Process Name
							</th>
							<th>
								Start Date
							</th>
							<th>
								Requested
							</th>
							<th>
								On Process
							</th>
						</tr>
					</thead>
					<tbody>
						';
        for ($a = 0; $a < count($data_last_process); $a++) {
            $b = $a + 1;

            $start_date = $data_last_process[$a]->start_date;
            if ($start_date == '0000-00-00') {
                $start_date = '<span class="text-red">Unprocess</span>';
            } else {
                $start_date = date('d M Y', strtotime($start_date));
            }

            $name_inventory    = $data_last_process[$a]->name_inventory;
            $name_last_process = $last_process[0]->name_inventory;

            if ($name_last_process == $name_inventory) {
                $on_process = '<i class="fa fa-check text-green"></i>';
            } else {
                $on_process = '';
            }

            echo '
									<tr>
										<td>
											' . $b . '
										</td>
										<td>
											' . ucfirst($data_last_process[$a]->name_inventory) . '
										</td>
										<td>
											' . $start_date . '
										</td>
										<td>
											' . $data_last_process[$a]->requested . '
										</td>
										<td>
											' . $on_process . '
										</td>
									</tr>
								';
        }
        echo '
					</tbody>
				</table>
			</div>
			<div class="modal-fotter">
			</div>
		';
    }

     public function download_barcode_new($ID, $menuid)
    {
         // $data['data_purchase'] = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code, b.status as statustype', "WHERE a.date_in >= date_add(date(now()),INTERVAL-30 day) and a.date_in <= date(now()) ORDER BY a.ID DESC");
        //end script


        // $data_barcode_pi = $this->master_model->select_in('ts_purchase_invoice','stock_no, purchase_invoice_no,date_in, supplier_name', "WHERE ID = '$menuid'");
        $data_barcode_pi = $this->master_model->select_in('ts_purchase_invoice a LEFT JOIN ms_supplier b ON a.id_supplier=b.ID', 'a.*, b.name as supplier_name, b.code as supplier_code, b.status as statustype', "WHERE a.ID = '$menuid'");
        $data_barcode_pi_no=$data_barcode_pi[0]->stock_no;
        $data_barcode_supplier=$data_barcode_pi[0]->supplier_name;
    
        $data_barcode = $this->master_model->select_in('ts_stock_detail','ID,id_purchase_detail, code_inventory, in_qty', "WHERE id_purchase_invoice = '$menuid' ORDER BY ID ASC");
    
            $isi = "";  
            $curr_code_inventory = "";
        
        for($q=0; $q < count($data_barcode); $q++)
         {  
            if ($curr_code_inventory <> $data_barcode[$q]->code_inventory)
            {
                if($q===0){ 
                    $isi= $isi . $data_barcode[$q]->code_inventory ."\r\n";
                } else {
                    $isi= $isi ."\r\n". "\r\n". $data_barcode[$q]->code_inventory;
                }
            }   
            $nilai_barcode =  $data_barcode[$q]->ID.'-'.$q.'-'.$data_barcode[$q]->id_purchase_detail.'-'.$data_barcode[$q]->in_qty;
//          echo $ID;
//          echo $isi;
//              echo "<pre>";
// print_r($data_barcode_supplier);
// die();
                
            $update_barcode=array
                (
                    'barcode' => $nilai_barcode,
                    
                );
                print_r($nilai_barcode);
                // $this->db->where('ID', $data_barcode[$q]->ID);
                // $this->db->update('ts_stock_detail', $update_barcode);
                //print_r($nilai_barcode);
                //

                if($q===0){
                    $isi= $isi .$nilai_barcode;

                }else{
                    $isi= $isi ."\r\n". $nilai_barcode;
                }

                
                $nama_file = 'Barcode ' .$data_barcode_pi_no.'-'.$data_barcode_supplier.'.txt';
            var_dump($isi);
                $curr_code_inventory = $data_barcode[$q]->code_inventory;
                
        }   

                force_download($nama_file, $isi);
    }

    public function download_barcode($ID, $menuid)
    {
        $data_barcode_pi       = $this->master_model->select_in('ts_purchase_invoice', 'stock_no, purchase_invoice_no,date_in, id_supplier', "WHERE ID = '$menuid'");
        $data_barcode_pi_no    = $data_barcode_pi[0]->stock_no;
        $data_barcode_supplier = $data_barcode_pi[0]->supplier_name;

        $data_barcode = $this->master_model->select_in_barcode($menuid);

        $isi                 = "";
        $curr_code_inventory = "";

        for ($q = 0; $q < count($data_barcode); $q++) {
            if ($curr_code_inventory != $data_barcode[$q]->code_inventory) {
                if ($q === 0) {
                    $isi = $isi . $data_barcode[$q]->code_inventory . "\r\n";
                } else {
                    $isi = $isi . "\r\n" . "\r\n" . $data_barcode[$q]->code_inventory;
                }
            }
            $nilai_barcode = $data_barcode[$q]->ID . '-' . $data_barcode[$q]->id_purchase_detail . '-' . $data_barcode[$q]->in_qty;
//              echo $ID;
            //              echo $isi;
            //                  echo "<pre>";
            // print_r($nilai_barcode);
            // die();

            $update_barcode = array
                (
                'barcode' => $nilai_barcode,

            );
            //print_r($nilai_barcode);
            $this->db->where('ID', $data_barcode[$q]->ID);
            $this->db->update('ts_stock_detail', $update_barcode);
            //print_r($nilai_barcode);
            //

            if ($q === 0) {
                $isi = $isi . $nilai_barcode;

            } else {
                $isi = $isi . "\r\n" . $nilai_barcode;
            }

            $nama_file = 'Barcode ' . $data_barcode_pi_no . '-' . $data_barcode_supplier . '.txt';
            //var_dump($isi);
            $curr_code_inventory = $data_barcode[$q]->code_inventory;

        }

        force_download($nama_file, $isi);
    }

    public function tum_img($menuid)
    {
        $ID = $this->input->post('ID');
        //echo $ID;
        //$ID = 506;
        $data_workorderi = $this->master_model->select_in('ts_workorder', 'target_pcs, finish_good, barcode, pack, total_barcode', "WHERE ID = '$ID'");
        $targetb         = $data_workorderi[0]->finish_good;
        $barcodeb        = substr(str_replace('%20', ' ', $targetb), 0, 10);

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL            => "https://babykenaz.com/api/product_models/show/$barcodeb",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 30,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => "GET",
            CURLOPT_HTTPHEADER     => array(
                "cache-control: no-cache",
            ),
        ));
        $response = curl_exec($curl);
        $err      = curl_error($curl);

        curl_close($curl);

        $response = json_decode($response, true); //because of true, it's in an array

        $image   = explode(',', $response['data']['image']);
        $imagesb = implode("", $image);
        // echo $imagesb;
        // die();
        echo '
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Image</h4>
			</div>

			<div class="modal-body">
			<div class="form-group">
			<div class="form-line">



			';?>

			<img width="100%" class="card-img-top img-preview" src="https://babykenaz.com/assets/img/uploads/product_models/<?php echo $imagesb; ?>">
		<?echo '</div>
				 </div>
				 </div>';

    }

    public function update_finish_modal($menuid, $finish_good)
    {
        $ID = $this->input->post('ID');
        //echo $finish_good;
        //$ID = 506;
        $data_workorder = $this->master_model->select_in('ts_workorder', 'ID, target_pcs, finish_good, product_code, barcode, pack, total_barcode', "WHERE ID = $ID");
        $target         = $data_workorder[0]->target_pcs;
        echo ' <form action="' . base_url() . 'admin/transaction/insert_update_finish/" method="POST">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				 <h4 class="modal-title">Update Name Finish Good [ ' . $data_workorder[0]->finish_good . ' ]</h4>
			</div>
				<div class="modal-body">
					';

        echo '
					<div class="form-group">
						<div class="form-line">
						<label>Code Product</label>
						<br>
						';
        if ($data_workorder[0]->barcode != '') {
            $barcode   = $data_workorder[0]->barcode;
            $ID        = $data_workorder[0]->ID;
            $read_only = 'readonly="readonly"';
        } else {
            //$barcode = substr(str_replace('%20', ' ', $finish_good), 0, 10);
            //$barcode = substr(str_replace('%20', ' ', $data_workorder[0]->finish_good), 0, 10);
            $barcode   = $data_workorder[0]->product_code;
            $ID        = $data_workorder[0]->ID;
            $read_only = 'readonly="readonly';
        }
        echo '
						<input type="text" name="barcode" class="header_barcode form-control" value="' . $barcode . '" ' . $read_only . '>
						<input type="hidden" name="id_product1" class="header_barcode form-control" value="' . $ID . '">
						</div>
					</div>

					<div class="form-group">
						<script>
							$(".additional").focusout(function()
							{
								var additional = $(this).val() == "" ? 0 : parseInt($(this).val());
								var target = $(".target").val() == "" ? 0 : parseInt($(".target").val());
								var pack = $(".pack").val() == "" ? 0 : parseInt($(".pack").val());
                                console.log("additional", additional)
                                console.log("target", target)
                                console.log("pack", pack)
								var total_pack = (pack == 0) ? 0 : (target/pack);
								var total_pack = total_pack+parseInt(additional);

								$(".total_pack").html(total_pack+" Barcode");
								$(".total_pack_value").val(total_pack);
							});
						</script>
						<div class="form-line">
						<label>Name Finish Good</label>
						<input type="text" class="form-control additional" name="finish_good" value="' . $data_workorder[0]->finish_good . '">
						</div>
					</div>


				</div>
				<div class="overlay" id="overlay" style="display: none;">
          <i class="fa fa-refresh fa-spin"></i>
        </div>
				<div class="modal-footer">
					<script>
						$("#ubah_finish").click(function()
						{
							//$("#overlay").show();
							alert(da);
							var product = "' . str_replace('/', '-url_dash-', $data_workorder[0]->finish_good) . '";
							var barcode = $(".header_barcode").val();
							var pack    = $(".pack").val();
							var total_pack = $(".total_pack_value").val();

							$.ajax({
									type: "POST",
									dataType: "html",
									url: "' . base_url() . 'admin/transaction/insert_update_finish/' . $menuid . '/' . $ID . '/' . $target . '/"+product+"/"+barcode,
									data:"barcode="+barcode,
									success: function(msg)
									{
										alert(msg);
										//return false;
										setTimeout(function()



										if(msg == "failed")
										{
											//alert("This labour not last process!");

											$("#overlay").hide();

											$("#triger_click").trigger("click");

											return false;
										}else {
										$("#overlay").hide();

											$("#triger_click").trigger("click");
											setTimeout(function() {
                                              window.location.href = "' . base_url() . 'admin/transaction/workorder/' . $menuid . '/";
                                             }, 1000);
											return true;
										}

									}
							});

						});
					</script>
					<input type="submit" class="btn btn-primary btn-fill pull-right" value="Update" id="ubah_finish">
					<button type="button" class="btn btn-default" data-dismiss="modal" id="triger_click" style="margin-right:5px;">Close</button>
				</div>
		</form>';
    }

    public function insert_update_finish($menuid, $ID, $target, $finish_good, $barcode)
    {

        $barcode     = $this->input->post('barcode');
        $finish_good = $this->input->post('finish_good');
        $id_product  = $this->input->post('id_product1');

        if ($barcode != null) {
            // $check_barcode = $this->master_model->mst_check('ts_workorder', 'barcode', $barcode);

            //     echo "<pre>";
            // echo "string";
            // print_r($finish_good);
            // die();
            $update_workorder = array
                (
                'finish_good' => $finish_good,
            );
            $this->db->where('product_code', $barcode);
            $this->db->update('ts_workorder', $update_workorder);
            //echo 'success';

            //new code
            ///input data matrial add product ke jurnal
            $data_jurnal[] = array(
                'code'        => $barcode,
                'finish_good' => $finish_good,
            );

            $response = $this->jurnal->updateProducts($data_jurnal);
            $this->session->set_flashdata('message', '<div class="alert alert-success">Update Finish Good Success</div>');
            redirect('admin/transaction/workorder/32');
            // echo $barcode;
            // echo "<pre>";
            // print_r($response);
            // die();
            // @$id_product_jurnal = $response[0]->data->product->id;

        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Update Finish Good failed</div>');
            redirect('admin/transaction/workorder/32');
            //echo 'failed';
        }
    }

    public function create_barcode_modal($menuid, $finish_good)
    {
        $ID = $this->input->post('ID');
        //echo $finish_good;
        //$ID = 506;
        $data_workorder = $this->master_model->select_in('ts_workorder', 'target_pcs, finish_good, product_code, barcode, pack, total_barcode', "WHERE ID = $ID");
        $target         = $data_workorder[0]->target_pcs;
        echo '
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				 <h4 class="modal-title">Create Barcode [' . $data_workorder[0]->finish_good . ']</h4>
			</div>
				<div class="modal-body">
					';
        if ($data_workorder[0]->barcode != '') {
            echo '
								<div class="form-group" style="text-align: center">
									<img src="' . base_url() . 'admin/transaction/create_barcode/' . $menuid . '/' . $data_workorder[0]->barcode . '" width="200" height="70">
								</div>
							';
        }
        echo '
					<div class="form-group">
						<div class="form-line">
						<label>Code Product</label>
						<br>
						';
        if ($data_workorder[0]->barcode != '') {
            $barcode   = $data_workorder[0]->barcode;
            $read_only = 'readonly="readonly"';
        } else {
            //$barcode = substr(str_replace('%20', ' ', $finish_good), 0, 10);
            //$barcode = substr(str_replace('%20', ' ', $data_workorder[0]->finish_good), 0, 10);
            $barcode   = $data_workorder[0]->product_code;
            $read_only = '';
        }
        echo '
						<input type="text" class="header_barcode form-control" value="' . $barcode . '" ' . $read_only . '>
						</div>
					</div>
					<div class="form-group">
					<div class="form-line">
						<label>Target Pcs</label>
						<br>
						' . $target . ' Pcs
						<input type="hidden" class="target" value="' . $data_workorder[0]->target_pcs . '">
						</div>
					</div>
					<div class="form-group">
						<script>
							$(".pack").focusout(function()
							{
								var pack = $(this).val();
								var target = $(".target").val();
								var additional = $(".additional").val();

								var total_pack = target/pack;
								var total_pack = total_pack+parseInt(additional);

								$(".total_pack").html(total_pack+" Barcode");
								$(".total_pack_value").val(total_pack);
							});
						</script>
						<div class="form-line>"
						<label>Fill Per Pack</label>
						<input type="text" name="pack" class="pack form-control" value="' . $data_workorder[0]->pack . '">
						</div>
					</div>
					<div class="form-group">
						<script>
							$(".additional").focusout(function()
							{
								var additional = $(this).val() == "" ? 0 : parseInt($(this).val());
								var target = $(".target").val() == "" ? 0 : parseInt($(".target").val());
								var pack = $(".pack").val() == "" ? 0 : parseInt($(".pack").val());
                                console.log("additional", additional)
                                console.log("target", target)
                                console.log("pack", pack)
								var total_pack = (pack == 0) ? 0 : (target/pack);
								var total_pack = total_pack+parseInt(additional);

								$(".total_pack").html(total_pack+" Barcode");
								$(".total_pack_value").val(total_pack);
							});
						</script>
						<div class="form-line">
						<label>Additional Barcode</label>
						<input type="text" class="form-control additional" value="0">
						</div>
					</div>

					<div class="form-group">
					<div class="form-line">
						<label>Total Barcode</label>
						<br>
						<span class="total_pack">' . $data_workorder[0]->total_barcode . ' Barcode</span>
						<input type="hidden" class="total_pack_value" value="' . $data_workorder[0]->total_barcode . '">
						</div>
					</div>

				</div>
				<div class="overlay" id="overlay" style="display: none;">
          <i class="fa fa-refresh fa-spin"></i>
        </div>
				<div class="modal-footer">
					<script>
						$("#save").click(function()
						{
							$("#overlay").show();

							var product = "' . str_replace('/', '-url_dash-', $data_workorder[0]->finish_good) . '";
							var barcode = $(".header_barcode").val();
							var pack    = $(".pack").val();
							var total_pack = $(".total_pack_value").val();

							$.ajax({
									type: "POST",
									dataType: "html",
									url: "' . base_url() . 'admin/transaction/insert_barcode_api/' . $menuid . '/' . $ID . '/' . $target . '/"+product+"/"+barcode+"/"+pack+"/"+total_pack,
									data:"barcode="+barcode,
									success: function(msg)
									{
										//alert(msg);
										//return false;
										setTimeout(function()
                    {
                       window.location.assign("' . base_url() . 'admin/transaction/set_barcode/' . $menuid . '/' . $ID . '/' . $target . '/"+product+"/"+barcode+"/"+pack+"/"+total_pack);
                    }, 100);

										if(msg == "failed")
										{
											//alert("This labour not last process!");

											$("#overlay").hide();

											$("#triger_click").trigger("click");

											return false;
										}else {
										$("#overlay").hide();

											$("#triger_click").trigger("click");
											setTimeout(function() {
                                              window.location.href = "' . base_url() . 'admin/transaction/workorder/' . $menuid . '/";
                                             }, 1000);
											return true;
										}

									}
							});

						});
					</script>
					<input type="submit" class="btn btn-primary btn-fill pull-right" value="Create" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" id="triger_click" style="margin-right:5px;">Close</button>
				</div>
		';
    }

    public function insert_barcode_api($menuid, $ID, $target, $finish_good, $barcode, $pack, $total_barcode)
    {
        $data_last_process = $this->master_model->select_in('ts_workorder_labour', 'code_supplier, start_date', "WHERE id_workorder = $ID ORDER BY ID DESC LIMIT 1");
        //AND requested <> 0 AND start_date <> '0000-00-00'
        $supplier_code = $data_last_process[0]->code_supplier;
        $start_date    = $data_last_process[0]->start_date;

        $data_supplier = $this->master_model->select_in('ms_supplier', 'name', "WHERE code = '$supplier_code'");
        $supplier_name = $data_supplier[0]->name;

        // echo $start_date;
        // exit;

        if ($start_date != '0000-00-00') {
            $check_barcode = $this->master_model->mst_check('ts_workorder', 'barcode', $barcode);

            // if($check_barcode == false)
            // {
            $user_id    = $this->session->userdata('UserID');
            $data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
            $admin      = $data_admin[0]->name;

            $update_workorder = array
                (
                'barcode'       => str_replace('%20', ' ', $barcode),
                'pack'          => $pack,
                'total_barcode' => $total_barcode,
            );
            $this->db->where('ID', $ID);
            $this->db->update('ts_workorder', $update_workorder);
            /*
            $product = json_encode($finish_good.'--'.$barcode.'--'.$target.'--'.$pack.'--'.$supplier_code.'--'.$supplier_name.'--Solusi Production '.$admin);
            $product = base64_encode($product);

            $insert        = "http://solusiprogram.net/soin/api/insert_stock?product=$product";
            $insertdata   = $this->grabURL($insert, true);
             */
            // }

            echo 'success';
        } else {
            echo 'failed';
        }
    }

    public function set_barcode($menuid, $ID, $target, $finish_good, $barcode, $pack, $total_barcode)
    {
        header('Content-type: text/plain');
        header('Content-Disposition: attachment; filename="Barcode ' . str_replace('%20', ' ', str_replace('-url_dash-', '/', $finish_good)) . '.txt"');

        for ($a = 0; $a < $total_barcode; $a++) {
            $numeric = $a + 1;

            if ($numeric < 10) {
                $leght = '000';
            } else if ($numeric >= 10 && $numeric < 100) {
                $leght = '00';
            } else if ($numeric >= 100 && $numeric < 1000) {
                $leght = '0';
            }

            if ($numeric == $total_barcode) {
                $break = "";
            } else {
                $break = "\r\n";
            }

            $finish_barcode = str_replace('%20', ' ', $barcode) . '-' . $leght . $numeric . $break;

            print $finish_barcode;
        }

    }

    public function delete_image($menuid, $id_workorder, $ID, $image)
    {
        $this->db->where('ID', $ID);
        $this->db->delete('ts_workorder_design');

        unlink('./uploads/design/' . $image);

        redirect('admin/transaction/production_insert/' . $menuid . '/' . $id_workorder);
    }

    public function grabURL($url, $encode = true)
    {
        $data = curl_init();
        curl_setopt($data, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($data, CURLOPT_URL, $url);
        $return = curl_exec($data);
        curl_close($data);
        if ($encode == true) {
            $return = json_decode($return);
        }

        return $return;
    }

    public function get_code_from_babykenaz($menuid)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL            => "https://babykenaz.com/api/product_models/find_by/status/request",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 30,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => "GET",
            CURLOPT_HTTPHEADER     => array(
                "cache-control: no-cache",
            ),
        ));
        $response = curl_exec($curl);
        $err      = curl_error($curl);

        curl_close($curl);

        $response = json_decode($response, true); //because of true, it's in an array
        $explode  = explode(',', $response['data']['code']);
        $name     = explode(',', $response['data']['name']);

        echo '
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">Code From Baby Kenaz Website</h4>
			</div>
			<div class="modal-body">
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>
								No.
							</th>
							<th>
								Code
							</th>
							<th>
								Name
							</th>
							<th>
								Select
							</th>
						</tr>
					</thead>
					<tbody>
							';
        for ($a = 0; $a < count($explode); $a++) {
            $b = $a + 1;
            echo '
										<tr>
											<td>' . $b . '</td>
											<td>
												<a alt="' . $explode[$a] . '" class="select-code" style="cursor: pointer" data-dismiss="modal">
													' . $explode[$a] . '
												</a>
											</td>
											<td>' . $name[$a] . '</td>
											<td align="center">
												<a alt="' . $explode[$a] . '" class="text-green select-code" style="cursor: pointer" data-dismiss="modal">
													<i class="fa fa-check-square-o"></i>
												</a>
												<script>
													$(".select-code").click(function()
													{
														var code = $(this).attr("alt");
														$(".finish-good").val(code);
														$(".finish-good").focus();
													});
												</script>
											</td>
										</tr>
									';
        }
        echo '
					</tbody>
				</table>
			</div>
		';
    }

    public function create_barcode($menuid, $code)
    {
        $this->load->library('zend');
        $this->zend->load('Zend/Barcode');

        Zend_Barcode::render('code128', 'image', array('text' => str_replace('%20', ' ', $code)), array());
    }

    public function import_material_by_txt($menuid, $clicks)
    {
        if (!empty($_FILES['file'])) {
            $path = "uploads/file/";
            $path = $path . basename($_FILES['file']['name']);
            if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                $rows = explode("\r\n", file_get_contents($path));

                if ($clicks < count($rows) + 1) {
                    $status = 'success';
                } else {
                    $status = 'failed';
                }

                $a = $clicks - 1;

                $code = trim($rows[$a]);

                $ifNotProcess = $master_model->select_in('ts_workorder_material', 'ID', "WHERE code_inventory = '$code' AND status = 'Process'");
                if (count($ifProcess) == 1) {
//Kalo statusnya prosess
                    $ifNotUsed = $master_model->select_in('ts_stock_detail', 'ID', "WHERE code_inventory = '$code' AND id_workorder_detail = 0");
                    if (count($ifNotUsed) == 1) {
//Kalo belum dipake
                        $json = array(
                            'barcode' => $rows[$a],
                        );
                    }
                } else {

                }

            } else {
                $json = array(
                    'barcode' => '',
                    'status'  => 'failed',
                );
            }
        }

        echo json_encode($json);
    }

    public function insert_cek_stock($menu)
    {
        // echo $menu;
        // echo "<pre>";
        // print_r($_FILES);
        // echo "</pre>";
        // ambil data file
        if (isset($_POST['import'])) {

            //$file = rand(1000,100000)."-".$_FILES['barcode']['name'];
            $namaFile      = $_FILES['barcode']['name'];
            $namaSementara = $_FILES['barcode']['tmp_name'];
            $file_size     = $_FILES['barcode']['size'];
            $file_type     = $_FILES['barcode']['type'];
            $folder        = "uploads/file/barcode/";

            $new_name = $folder . $namaFile;

            //$open = file_get_contents($namaFile);
            //echo fopen();
            //print_r (fopen($new_name, "r"));
            //echo "string";
            //die;
            $this->master_model->clear_h();

            if (empty($namaSementara)) {
                echo 'File tidak boleh kosong!';
            } else {

                // tentukan lokasi file akan dipindahkan
                $dirUpload = "uploads/file/barcode/";
                // pindahkan file
                $terupload = move_uploaded_file($namaSementara, $dirUpload . $namaFile);

                if ($terupload) {
                    // echo "Upload berhasil!<br/>";
                    // echo "Link: <a href='".$dirUpload.$namaFile."'>".$namaFile."</a>";

                    $code   = 'stock_opname';
                    $handle = fopen($new_name, "r") or die("file cannot open");
                    // echo $handle;
                    // die;
                    // $file_uploded = base_url().'uploads/file/barcode/'.$file;

                    if ($handle) {
                        while (($line = fgets($handle)) !== false) {
                            $lineArr = explode("\t", "$line");

                            $result = $this->master_model->insert_file_content($lineArr);
                        }
                        if (fclose($handle)) {
                            //echo "file ok";
                            //redirect(base_url());
                            $this->session->set_flashdata('message', '<div class="alert alert-success>Data berhasil Diinput</div>');
                            // redirect('admin/master/inventory_detail/30/30/'.$code);
                            redirect('admin/master/inventory_stock_opname/30/30');
                        }

                    } else {
                        $this->session->set_flashdata('message', '<div class="alert alert-danger>Data failed Diinput</div>');
                        redirect('admin/master/inventory_stock_opname/30/30');
                        //echo "file cannot open";
                    }

                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger>Data failed uploads</div>');
                    redirect('admin/master/inventory_stock_opname/30/30');
                    //echo "Upload Gagal!";
                }

                // $data_cek_barcode = $this->master_model->select_in('tbl_cek_barcode','barcode');
                // $data_opame_result = $this->master_model->select_in('ts_opame_result','id_barcode,barcode');
                // $a=[];
                // $b=[];
                // echo "<pre>";
                // //echo $data_opame_result['barcode'];
                // //print_r($data_opame_result);
                // foreach($data_opame_result as $dor){
                //     $a = $dor->barcode;
                // }
                //     // echo '<br>';
                //     foreach ($data_cek_barcode as $value) {
                //          $b = $value->barcode;

                //     }
                // if($a == $b){
                //             echo $b."<pre>";
                //         } else {
                //             echo "td";
                //         }

            }

        }

    }

    public function checkBarcode()
    {
        if (!empty($_FILES['file'])) {
            $path = "uploads/file/";
            $path = $path . basename($_FILES['file']['name']);

            if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                $rows = explode("\n", file_get_contents($path));

                $barcode = trim($rows[0]);

                $json = array(
                    'barcode' => $barcode,
                    'status'  => 'next',
                );
            }
        }

        echo json_encode($json);
    }

    public function nextCheckBarcode($clicks)
    {
        if (!empty($_FILES['file'])) {
            $path = "uploads/file/";
            $path = $path . basename($_FILES['file']['name']);

            if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                $rows = explode("\n", file_get_contents($path));

                if ($clicks < count($rows)) {
                    $status = 'next';
                } else {
                    $status = 'stop';
                }

                $barcode = trim($rows[$clicks]);

                $json = array(
                    'barcode' => $barcode,
                    'status'  => $status,
                    'rows'    => $rows,
                );
            }
        }

        echo json_encode($json);
    }

}
?>
