<?php

include('./application/controllers/authcontroller'.EXT);

class master extends Authcontroller

{

	public function __construct()

	{

		parent :: __construct();

		$this->load->model('admin/master_model');

		$this->load->library('upload');

		$this->load->library(array('PHPExcel','PHPExcel/IOFactory'));

    }

	public function inventory_category($menuid)
	{
		
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

       	$jumlah_data = $this->master_model->jumlah_data_inventory_category();
		$this->load->library('pagination');
		$config['base_url'] = base_url().'admin/master/inventory_category/'.$menuid;
		$config['total_rows'] = $jumlah_data;
		$config['per_page'] = 10;
		$from = $this->uri->segment(3);
		$this->pagination->initialize($config);		
		$data['data_inventory'] = $this->master_model->data_inventory_category($config['per_page'],$from);

		$data['data_inventory']= $this->master_model->mst_data('ms_inventory_category');
		$this->load->view('admin/master/inventory_category', $data);
	}

	public function insert_inventory_category($menuid)
	{
		if($this->input->post('publish')=='on')
		{
			$publish=1;
		}else
		{
			$publish=0;
		}


		$ID = $this->master_model->mst_last_id('ms_inventory_category');
		$data = array(
			'ID' => $ID,
			'name' => $this->input->post('name'),
			'note' => $this->input->post('note'),
			'sort' => $ID,
			'publish' => $publish,
		);
		$this->db->insert('ms_inventory_category', $data);

		redirect('admin/master/inventory_category/'.$menuid);
	}

	function publish_category_inventory($menuid, $ID, $publish)
	{
		if($publish==0)
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','1');
			$this->db->update('ms_inventory_category');
		}
		else
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','0');
			$this->db->update('ms_inventory_category');
		}
		redirect('admin/master/inventory_category/'.$menuid);
	}

	function edit_inventory_category($menuid)
	{
		$ID=$this->input->post('ID');
		$data_edit=$this->master_model->select_in('ms_inventory_category','*',"WHERE ID=$ID");

		if($data_edit[0]->publish==1)
		{
			$checked='checked="checked"';
		}else
		{
			$checked='';
		}
		echo'
			<div class="modal-header">
           		<button type="button" class="close" data-dismiss="modal">&times;</button>
           		<h4 class="modal-title">Edit Inventory Category</h4>
            </div>
			<form action="'.base_url().'admin/master/edit_process_inventory_category/'.$menuid.'/'.$ID.'" method="post" enctype="multipart/form-data">
				<div class="modal-body">
					<div class="form-group">
						<label>Name *</label>
						<input type="text" name="name" class="form-control" placeholder="Name" required="required" value="'.$data_edit[0]->name.'">
					</div>

					<div class="form-group">
						<label>Description</label>
						<textarea class="form-control" name="note" placeholder="Description">'.$data_edit[0]->note.'</textarea>
					</div>

					<div class="form-group">
						<label>Publish</label>
						<br />
						<input name="publish" type="checkbox" '.$checked.' />
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function edit_process_inventory_category($menuid, $ID)
	{
		if($this->input->post('publish')=='on')
		{
			$publish=1;
		}else
		{
			$publish=0;
		}

		$data = array(
			'name' => $this->input->post('name'),
			'note' => $this->input->post('note'),
			'publish' => $publish,
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_inventory_category', $data);

		redirect('admin/master/inventory_category/'.$menuid);
	}

	public function inventory($menuid, $id_category)
	{

		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $jumlah_data = $this->master_model->jumlah_data_inventory();
        $this->load->library('pagination');
        $config['base_url'] = base_url().'admin/master/inventory/'.$menuid.$id_category;
        $config['total_rows'] = $jumlah_data;
        $config['per_page'] = 10;
        $from = $this->uri->segment(3);
        $this->pagination->initialize($config);
        $data['data_inventory'] = $this->master_model->data_inventory($config['per_page'], $from);

		$data['data_inventory']= $this->master_model->select_in('ms_inventory','*',"WHERE id_category=$id_category");
		$this->load->view('admin/master/inventory', $data);
	}

	public function inventory_insert($menuid, $id_category='')
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

		$this->load->view('admin/master/inventory_insert');
	}

	public function insert_ss($menuid)
	{
		// $data_product=$this->master_model->select_in('opname_soin','barcode, finishgood');
		// for($b = 0; $b < count($data_product); $b++) {
		//     $data_product1 = $data_product[$b]->finishgood;
		//     $data_hpp=$this->master_model->select_in('ts_workorder','grandtotal, finish, barcode',"WHERE finish_good ='$data_product1'");
		//     for($a = 0; $a < count($data_hpp); $a++){
		//     	$data_barcode = $data_hpp[$a]->barcode;
		//     	$hpp = money_format('%.2n',$data_hpp[$a]->grandtotal/$data_hpp[$a]->finish);
		    	
		//     	$data_detail=array
		// 		(
		// 			'hpp'=>$hpp,
		// 		);
				
		// 		$this->db->where('barcode', $data_barcode);
		// 		$this->db->update('opname_soin', $data_detail);
		//     }
		//     // $hpp = $data_hpp[$b]->grandtotal/$data_hpp[$b]->finish;
		//     // print_r($hpp);
		//  }
		//  die();
		$product = $this->input->post('name');
		// echo $product;
		// die();
		$data_hpp=$this->master_model->select_in('ts_workorder','grandtotal, finish',"WHERE finish_good ='$product'");
		$hpp = money_format('%.2n',$data_hpp[0]->grandtotal/$data_hpp[0]->finish);
		print_r($hpp);
		die();
		       $data_detail=array
				(
					'hpp'=>$hpp,
				);
				
				$this->db->where('barcode', $data_barcode);
				$this->db->update('opname_soin', $data_detail);

		redirect('admin/master/inventory_category/'.$menuid);
	}

	public function insert_adjustment($menuid){
		
		
		$product = $this->input->post('name');
		
		$data_opname=$this->master_model->select_in('opname_soin','barcode, finishgood, qty, hpp',"WHERE finishgood ='$product'");
		$data_barcode   = $data_opname[0]->barcode;
		$data_finishgood= $data_opname[0]->finishgood;
		$data_qty        = $data_opname[0]->qty;
		$data_hpp       = $data_opname[0]->hpp;
		// echo $data_qt;
		// die();
		//NEW CODE			
			$harga1 = $data_qty*$data_hpp;
			$id_category2 = 935843;
			$type1='Finish Good';
			$id_detail2 = $id_detail;
			$id2          = $ID;
		echo $harga1;
		die();
			//END CODE NEW

			//new code
				$ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/products/add_products");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
                 http_build_query(array('name'       =>$data_finishgood,
             							'unit_name'  =>$type1,
             							'sell_price' =>$harga1,
             							'code'       =>$data_finishgood,
             							'buy_price'  =>$harga1,
             							'desckripsi' =>$data_finishgood,
             							'code_product'=>$data_barcode,

             							'type'       =>$type1, 
             							
             							'id_category' =>$id_category2,
             							

             						)));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output1 = curl_exec($ch);
        $error_msg = curl_error($ch);
        print_r($server_output1);
        echo '<pre>';
         if ($server_output1->success === false) {
       					echo "string";
			//end new code
			//
		 

	  }else {
	  	$ch = curl_init();

                        curl_setopt($ch, CURLOPT_URL, "https://solusiprogram.xyz/jurnal/api/api/work_order/add_stock");
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS,
                                 http_build_query(array('date'           => date("d/m/Y"),
                                                        'kode'           => $data_barcode,
                                                        'name_inventory' => $data_finishgood,
                                                        'actual'         => $data_qty,
                                                        'tags'           => $data_barcode,
                                                        'price'          => $harga1,

                                                    )));

                        // Receive server response ...
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        $server_output = curl_exec($ch);
                        $error_msg = curl_error($ch);
                    echo '<pre>';
                    print_r($server_output);
	  }
    }

	public function insert_inventory($menuid, $id_category='')

	{

		$ID = $this->master_model->mst_last_id('ms_inventory');

		if($id_category=='')
		{
			$id_category=$this->input->post('category');
		}else
		{
			$id_category=$id_category;
		}

		if($this->input->post('publish')=='on')
		{
			$publish=1;
		}else
		{
			$publish=0;
		}

		$data_jurnal = array(
                'name'              => $this->input->post('name'),
                'unit_name'          => $this->input->post('type'),
                'sell_price'         => $this->input->post('last_cost') == '' ? 0 : $this->input->post('last_cost'),
                'code'               => $this->input->post('code'),
                'buy_price'          => 0,
                'desckripsi'         => $this->input->post('code'),
                'code_product'       => $this->input->post('code'),
                'type'               => $this->input->post('type'),
                'id_category'        => $id_category,

                'ip_id'              => $_SERVER['SERVER_ADDR'],          
                'auth_key'            => 'test',
                'password'            => 'dgasgadsg@dfgsdfgsdf3535353',

            );

		$response = $this->jurnal->addProducts($data_jurnal);
           echo "<pre>";
          print_r($response);
          die();

		$data = array(

			'ID' => $ID,

			'code' => $this->input->post('code'),

			'name' => $this->input->post('name'),

			'id_category' => $id_category,

			'type' => $this->input->post('type'),

			'barcode' => $this->input->post('barcode'),

			'unit' => $this->input->post('unit'),

			'volume' => $this->input->post('w').' x '.$this->input->post('d').' x '.$this->input->post('h'),

			'bruto' => $this->input->post('bruto'),

			'net' => $this->input->post('net'),

			'last_cost' => $this->input->post('last_cost') == '' ? 0 : $this->input->post('last_cost'),

			'stock_value' => $this->input->post('stock'),

			'stock_balance' => $this->input->post('balance'),

			'average_cost' => $this->input->post('average'),

			'note' => $this->input->post('note'),

			'publish'=>$publish,

			'sort' => $ID,

		);

		$this->db->insert('ms_inventory', $data);

		redirect('admin/master/inventory/'.$menuid.'/'.$id_category);

	}

	function publish_inventory($menuid, $id_category, $ID, $publish)
	{
		if($publish==0)
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','1');
			$this->db->update('ms_inventory');
		}
		else
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','0');
			$this->db->update('ms_inventory');
		}
		redirect('admin/master/inventory/'.$menuid.'/'.$id_category);
	}

	public function delete_inventory_category($menuid)
	{
		$ID=$this->input->post('ID');

		$this->db->where('ID', $ID);
		$this->db->delete('ms_inventory_category');

		$this->db->where('id_category', $ID);
		$this->db->delete('ms_inventory');

		//redirect('admin/master/inventory_category/'.$menuid);

		$data['data_inventory']= $this->master_model->mst_data('ms_inventory_category');
		$this->load->view('admin/master/inventory_category_search', $data);
	}

	public function delete_inventory($menuid, $id_category, $ID)

	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_inventory');
		redirect('admin/master/inventory/'.$menuid.'/'.$id_category);
	}



	public function inventory_edit($menuid, $id_category, $ID)

	{
		$data['data_edit']=$this->master_model->mst_data_edit('ms_inventory',$ID);

		$this->load->view('admin/master/inventory_edit', $data);
	}



	public function update_inventory($menuid, $id_category, $ID)

	{
		if($this->input->post('publish')=='on')
		{
			$publish=1;
		}else
		{
			$publish=0;
		}

		$data = array(

			'code' => $this->input->post('code'),

			'name' => $this->input->post('name'),
			'type' => $this->input->post('type'),

			'barcode' => $this->input->post('barcode'),

			'unit' => $this->input->post('unit'),

			'volume' => $this->input->post('w').' x '.$this->input->post('d').' x '.$this->input->post('h'),

			'bruto' => $this->input->post('bruto'),

			'net' => $this->input->post('net'),

			'last_cost' => $this->input->post('last_cost'),

			'stock_value' => $this->input->post('stock'),

			'stock_balance' => $this->input->post('balance'),

			'average_cost' => $this->input->post('average'),

			'note' => $this->input->post('note'),
			'publish' => $publish,
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_inventory', $data);

		redirect('admin/master/inventory/'.$menuid.'/'.$id_category);
	}

	public function get_inventory($menuid)
	{
		$name=$this->input->get('name');

		if($name=='')
		{
			$data['data_inventory']= $this->master_model->mst_data('ms_inventory_category');
			$this->load->view('admin/master/inventory_category_search', $data);
		}else
		{
			$data['data_inventory']= $this->master_model->select_in('ms_inventory','*',"WHERE name LIKE '%$name%' OR code LIKE '%$name%'");
			$this->load->view('admin/master/inventory_search', $data);
		}
	}


	public function update_stock_and_price_inventory($code)
	{
		$data_inventory=$this->master_model->update_stock_and_price_inventory($code);

		$data_update=array
		(
			'stock_balance'=>$data_inventory[0]->qty_avail,
			'stock_value'=>$data_inventory[0]->total_price,
		);
		$this->db->where('code', $code);
		$this->db->update('ms_inventory', $data_update);
	}


	public function inventory_detail($menuid, $id_category, $code)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        if($code=='stock_opname')
        {
        	$this->load->library('pagination');

        	/*
	        $config = [
	            'base_url' => base_url('admin/master/inventory_detail/'.$menuid.'/'.$id_category.'/'.$code),
	            'per_page' => 10,
	            'total_rows' => $this->master_model->num_rows_stock_opname(),
	        ];
	        */

	        $config['full_tag_open']    = '<ul class="pagination">';
	        $config['full_tag_close']   = '</ul>';
	        $config['num_tag_open']     = '<li class="page-item">';
	        $config['num_tag_close']    = '</li>';
	        $config['cur_tag_open']     = '<li class="page-item active"><a class="page-link" href="#">';
	        $config['cur_tag_close']    = '</a></li>';
	        $config['next_tag_open']    = '<li class="page-item">';
	        $config['next_tagl_close']  = '</a></li>';
	        $config['prev_tag_open']    = '<li class="page-item">';
	        $config['prev_tagl_close']  = '</li>';
	        $config['first_tag_open']   = '<li class="page-item disabled">';
	        $config['first_tagl_close'] = '</li>';
	        $config['last_tag_open']    = '<li class="page-item">';
	        $config['last_tagl_close']  = '</a></li>';
	        $config['attributes']       = array('class' => 'page-link');
	        $this->pagination->initialize($config); // model function
	        $data['data_inventory']     = $this->master_model->stock_opname(); // list of seeker

        	//$data['data_inventory']= $this->master_model->stock_opname($limit, $offset);
        }elseif($code=='stock')
        {
        	$data['data_inventory']= $this->master_model->data_stock_detail($id_category, $code);
        }else
        {
        	$data['data_inventory']= $this->master_model->inventory_detail($code);
        }
        // echo $code;
        // echo '<pre>';
        // print_r([$data['data_inventory'], $code]);
        // die();
		$this->load->view('admin/master/inventory_detail', $data);
	}

	public function order_inventory_by_qty($menuid)
	{
		$code = 'stock_opname';
		$order = $this->input->post('order');
		if($order == '')
		{
			$order = 'ORDER BY a.code_inventory, a.ID ASC';
		}else {
			$order = $order;
		}

		$data_inventory = $this->master_model->stock_opname_by_qty($order);
		echo'
		<table id="example10" class="table table-bordered table-striped">
					<thead>
							<tr>
									<th>No.</th>
									<th>Barcode</th>
									<th>Source</th>
									';
											if($code=="stock_opname")
											{
													echo'
															<th>Code</th>
															<th>Name Material</th>
													';
											}else
											{
													echo'
															<th>Finish Good</th>
													';
											}
									echo'
									<th>In Qty</th>
									';
											if($code=='stock_opname')
											{
													echo'';
											}else
											{
													echo'
															<th>Qty Use</th>
															<th>Qty Left</th>
															<th>Qty Retur</th>
													';
											}
									echo'
									<th>Price</th>
									<th>Date</th>
									<th>Schedule Date</th>
							</tr>
					</thead>
					<tbody class="get_customer">
						';
							for($a=0; $a < count($data_inventory); $a++)
							{
									$b=$a+1;
									$ID = $data_inventory[$a]->id;
							echo'
							<tr>
									<td>
											'.$b.'
									</td>
										';
											if($code=='stock_opname')
											{
												if($data_inventory[$a]->barcode == '')
													{
															echo'
																	<td>
																			'.$data_inventory[$a]->barcode.'
																	</td>
															';
													}else
													{
															 echo'
																	<td>
																			'.$data_inventory[$a]->barcode.'
																	</td>
															';
													}


													if($data_inventory[$a]->purchase_invoice_no == '')
													{
															echo'
																	<td>
																			'.$data_inventory[$a]->workorder_bf.'
																	</td>
															';
													}else
													{
															 echo'
																	<td>
																			'.$data_inventory[$a]->purchase_invoice_no.'
																	</td>
															';
													}

													if($data_inventory[$a]->code_inventory=='')
													{
															echo'
																	<td>'.$data_inventory[$a]->code_inventory_material.'</td>
															';
													}else
													{
															echo'
																	<td>'.$data_inventory[$a]->code_inventory.'</td>
															';
													}

													echo'<td>'.$data_inventory[$a]->name.'</td>';
											}else
											{
													if($data_inventory[$a]->purchase_invoice_no=='')
													{
															echo'
																	<td>
																			'.$data_inventory[$a]->workorder_bf.'
																	</td>
															';
													}else
													{
															 echo'
																	<td>
																			'.$data_inventory[$a]->purchase_invoice_no.'
																	</td>
															';
													}

													echo'
															<td>
																	'.$data_inventory[$a]->finish_good.'
															</td>
													';
											}
									echo'
									<td>
											'.$data_inventory[$a]->in_qty.'
									</td>
									';
											if($code=='stock_opname')
											{
													echo'';
											}else
											{
													echo'
															<td>
																	'.$data_inventory[$a]->qty_use.'
															</td>

															<td>
																	'.$data_inventory[$a]->qty_waste.'
															</td>

															<td>
																	'.$data_inventory[$a]->qty_retur.'
															</td>
													';
											}
									echo'
									<td>
										'.money_format('%.2n', $data_inventory[$a]->price). "\n".'
									</td>
									<td>
										';
											if($data_inventory[$a]->date_in==0)
											{
													echo date('d M Y', strtotime($data_inventory[$a]->date_in_wo));
											}else
											{
													echo date('d M Y', strtotime($data_inventory[$a]->date_in));
											}
										echo'
									</td>
									<td>
											';
													if($data_inventory[$a]->date_schedule==0 || $data_inventory[$a]->date_schedule=='')
													{
															echo '-';
													}else
													{
															echo date('d M Y', strtotime($data_inventory[$a]->date_schedule));
													}
											echo'
									</td>
							</tr>
							';
						}
					echo'
					</tbody>
			</table>
			<script>
				$("#example10").DataTable(
				{
					"paging": true,
					"lengthMenu": [ 10, 20, 30, 40, 50 ],
					"pageLength": 10,
					"searching": true,
					"deferRender": true,
				});
			</script>
		';
	}


	public function inventory_stock($menuid, $id_category, $code)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);
        // echo $code;
        // echo '<pre>';
        // echo $id_category;
        // die();
        $data['data_inventory']= $this->master_model->data_stock_detail($id_category, $code);
        // echo '<pre>';
        // print_r($data['data_inventory']);
        // die();
		$this->load->view('admin/master/inventory_stock', $data);
	}

	public function inventory_stock_opname($menuid, $id_category='')
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $data['data_inventory']= $this->master_model->select_in('tbl_cek_barcode','barcode');
		$this->load->view('admin/master/stock_opname_insert',$data);
	}

	public function account($menuid)

	{

		define("menuid",$menuid);

        $user_id = $this->session->userdata('UserID');

        $this->redirectNoAuthRead($user_id, $menuid);



		$data['ms_account'] = $this->master_model->mst_data('ms_account');



		$this->load->view('admin/account/main', $data);

	}



	public function insert_account($menuid)

	{

		$ID = $this->master_model->mst_last_id('ms_account');

		$data = array(

			'ID' => $ID,

			'name' => $this->input->post('name'),

			'input_1' => $this->input->post('input_1'),

			'input_2' => $this->input->post('input_2'),

			'input_3' => $this->input->post('input_3'),

			'note' => $this->input->post('note'),

			'sort' => $ID,

			'publish' => 1,

		);

		$this->db->insert('ms_account', $data);

		redirect('admin/master/account/'.$menuid);

	}

	function publish_account($menuid, $ID, $publish)
	{
		if($publish==0)
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','1');
			$this->db->update('ms_account');
		}
		else
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','0');
			$this->db->update('ms_account');
		}
		redirect('admin/master/account/'.$menuid);
	}

	function edit_account($menuid)
	{
		$ID=$this->input->post('ID');
		$data_edit=$this->master_model->select_in('ms_account','*',"WHERE ID=$ID");
		echo'
			<div class="modal-header">
           		<button type="button" class="close" data-dismiss="modal">&times;</button>
           		<h4 class="modal-title">Edit Account</h4>
            </div>
                <form action="'.base_url().'admin/master/edit_account_process/'.$menuid.'/'.$ID.'" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
						<script type="text/javascript">
							$(document).ready(function()
							{
								exist2 = 0;
								$("#name").change(function (e)
								{
									var name = $(this).val();
									$("#name-result").show();
									$.ajax({
										 type:"POST",
										 url: "'.base_url().'admin/master/check_name_account/'.$menuid.'",
										 data:"name="+name,
										 success:function(msg)
										 {
											 if(msg == 1)
											 {
												 exist2 = 1;
												 $("#name-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Nama Account sudah digunakan</font>");
											 }else
											 {
												 exist2 = 0;
												 $("#name-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i> Nama Account belum digunakan</font>");
											 }
										 }
									});
								});

								$("#save").click(function()
								{
									if(exist2 == 1)
									{
										alert("Nomor Handphone Sudah Digunakan");
										return false;
									}else
									{
										return true;
									}
								});
							});
						</script>

                        <div class="form-group">
                        	<div class="form-line">
	                            <label>Account Name *</label>
	                            <span id="name-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
	                            <input type="text" name="name" id="name" class="form-control" placeholder="Account Name" required="required" value="'.$data_edit[0]->name.'">
	                        </div>
                        </div>

                        <div class="form-group">
                        	<div class="form-line">
	                            <label>Input 1</label>
	                            <input type="text" name="input_1" class="form-control" placeholder="Input 1" value="'.$data_edit[0]->input_1.'">
	                        </div>
                        </div>

						<div class="form-group">
							<div class="form-line">
	                            <label>Input 2</label>
	                            <input type="text" name="input_2" class="form-control phone" placeholder="Input 2" value="'.$data_edit[0]->input_2.'">
	                        </div>
                        </div>

                        <div class="form-group">
                        	<div class ="form-line">
	                            <label>Input 3</label>
	                            <input type="text" name="input_3" class="form-control phone" placeholder="Input 3" value="'.$data_edit[0]->input_3.'">
	                        </div>
                        </div>
                       	<div class="form-group">
                       		<div class="form-line">
                            <label>Deskripsi</label>
                            <textarea name="note" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                    	<div class="form-line">
	                		<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
	                    	<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
	                    </div>
                    </div>
                </form>
		';
	}

	public function edit_account_process($menuid, $ID)
	{
		$data = array(
			'name' => $this->input->post('name'),
			'input_1' => $this->input->post('input_1'),
			'input_2' => $this->input->post('input_2'),
			'input_3' => $this->input->post('input_3'),
			'note' => $this->input->post('note'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_account', $data);

		redirect('admin/master/account/'.$menuid);

	}

	public function delete_account($menuid, $ID)

	{

		$this->db->where('ID', $ID);

		$this->db->delete('ms_account');

		redirect('admin/master/account/'.$menuid);

	}


	function update_product($menuid, $id_category)

	{

		$ID          = $this->input->post('ID');

		$price       	= $this->input->post('price');



		for($a=0 ; $a < count($ID) ; $a++)

		{

			$this->master_model->mst_update('ms_product', "price='$price[$a]'", $ID[$a]);

		}

		redirect('admin/master/product/'.$menuid.'/'.$id_category);

	}



	function set_price($menuid, $id_category)

	{

		$price=$this->input->post('price');

		$sql = "UPDATE ms_product SET price=$price WHERE id_category=$id_category";

        $qry = $this->db->query($sql);

		redirect('admin/master/product/'.$menuid.'/'.$id_category);

	}



	function check_code()
	{
		$code = $this->input->post('code');
		//$cek = $this->master_model->cek_codes($code, 'ts_workorder');
		$cek = $this->master_model->cek_name($code, 'ts_workorder', 'product_code');
		if($cek)
		{
			echo '0';
		}else
		{
			echo '1';
		}
	}

	function check_name()
	{
		$code = $this->input->post('code');
		$cek = $this->master_model->cek_name($code, 'ts_workorder', 'finish_good');
		if($cek)
		{
			echo '0';
		}else
		{
			echo '1';
		}
	}

	function check_code_supplier()
	{
		$code = $this->input->post('code');
		$cek = $this->master_model->cek_code($code, 'ms_supplier');
		if($cek)
		{
			echo '1';
		}else
		{
			echo '0';
		}
	}





	function check_code_inventory()
	{
		$code = $this->input->post('code');
		$cek = $this->master_model->cek_code($code, 'ms_inventory');
		if($cek)
		{
			echo '1';
		}else
		{
			echo '0';
		}
	}



	public function check_email_supplier($menuid)

	{

		$email = $this->input->post('email');

		if($email=='')

		{

			echo '2';

		}else

		{

			$cek = $this->master_model->mst_check('ms_supplier','email',$email);

			if($cek)

			{

				echo '1';

			}else

			{

				echo '0';

			}

		}

	}



	public function check_phone_supplier($menuid)

	{

		$phone = $this->input->post('phone');

		if($phone=='')

		{

			echo '2';

		}else

		{

			$cek = $this->master_model->mst_check('ms_supplier','phone',$phone);

			if($cek)

			{

				echo '1';

			}else{

				echo '0';

			}

		}

	}



	public function check_name_account($menuid)

	{

		$name = $this->input->post('name');

		if($name=='')

		{

			echo '2';

		}else

		{

			$cek = $this->master_model->mst_check('ms_account','name',$name);

			if($cek)

			{

				echo '1';

			}else{

				echo '0';

			}

		}

	}



	function generate_by_phone()

	{

		$nohp = $this->input->post('nohp');

		$sql = "SELECT ID FROM ms_customer WHERE no_hp = '$nohp' ORDER BY name ASC";

        $qry = $this->db->query($sql);

		$num = $qry->num_rows();

	   if($num == 0)

	   {

		   $gen = $this->master_model->generateOTP(4);

		   echo $gen;

	   }else{

		   echo 'error';

	   }

	}

	public function supplier($menuid)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);


        $jumlah_data = $this->master_model->jumlah_data();
		$this->load->library('pagination');
		$config['base_url'] = base_url().'admin/master/supplier/'.$menuid;
		$config['total_rows'] = $jumlah_data;
		$config['per_page'] = 10;
		$from = $this->uri->segment(3);
		$this->pagination->initialize($config);		
		//$data['data_supplier'] = $this->master_model->data($config['per_page'],$from);

		$data['data_supplier']= $this->master_model->mst_data('ms_supplier',['per_page'],$from);
		$this->load->view('admin/supplier/main', $data);
	}

	public function customer($menuid)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);


        $jumlah_data = $this->master_model->jumlah_data();
		$this->load->library('pagination');
		$config['base_url'] = base_url().'admin/master/customer/'.$menuid;
		$config['total_rows'] = $jumlah_data;
		$config['per_page'] = 10;
		$from = $this->uri->segment(3);
		$this->pagination->initialize($config);		
		//$data['data_supplier'] = $this->master_model->data($config['per_page'],$from);

		$data['data_customer']= $this->master_model->mst_data('ms_customer',['per_page'],$from);
		$this->load->view('admin/customer/main', $data);
	}


	public function supplier_insert($menuid)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

		$this->load->view('admin/supplier/insert');
	}


	public function insert_supplier($menuid)

	{

		$ID = $this->master_model->mst_last_id('ms_supplier');

		$data = array(

			'ID' => $ID,

			'code' => $this->input->post('code'),

			'name' => $this->input->post('name'),

			'npwp' => $this->input->post('npwp'),

			'contact' => $this->input->post('contact'),

			'phone' => $this->input->post('phone'),

			'email' => $this->input->post('email'),

			'address' => $this->input->post('address'),
			'account' => $this->input->post('bank').'/'.$this->input->post('rekening').'/'.$this->input->post('account_name'),

			'no_registration' => empty($this->input->post('registration')) ? null : $this->input->post('registration'),
			

			'payment_term' => $this->input->post('payment'),

			'credit_limit' => empty($this->input->post('credit')) ? null : $this->input->post('credit'),

			'balance' => $this->input->post('balance'),

			'note' => $this->input->post('note'),

			'sort' => $ID,

			'publish' => 1,

		);

		$this->db->insert('ms_supplier', $data);

		redirect('admin/master/supplier/'.$menuid);

	}


	function publish_supplier($menuid, $ID, $publish)
	{
		if($publish==0)
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','1');
			$this->db->update('ms_supplier');
		}
		else
		{
			$this->db->where('ID', $ID);
			$this->db->set('publish','0');
			$this->db->update('ms_supplier');
		}
		redirect('admin/master/supplier/'.$menuid);
	}


	public function delete_supplier($menuid, $ID)

	{

		$this->db->where('ID', $ID);

		$this->db->delete('ms_supplier');

		redirect('admin/master/supplier/'.$menuid);

	}



	public function edit_supplier($menuid, $ID)

	{
		$data['data_edit']=$this->master_model->mst_data_edit('ms_supplier',$ID);
		$this->load->view('admin/supplier/edit', $data);
	}



	public function update_supplier($menuid, $ID)

	{
		$data = array(

			'code' => $this->input->post('code'),

			'name' => $this->input->post('name'),

			'npwp' => $this->input->post('npwp'),

			'contact' => $this->input->post('contact'),

			'phone' => $this->input->post('phone'),

			'email' => $this->input->post('email'),

			'address' => $this->input->post('address'),
			'account' => $this->input->post('bank').'/'.$this->input->post('rekening').'/'.$this->input->post('account_name'),

			'no_registration' => empty($this->input->post('registration')) ? null : $this->input->post('registration'),

			'payment_term' => $this->input->post('payment'),

			'credit_limit' => empty($this->input->post('credit')) ? null : $this->input->post('credit'),

			'balance' => $this->input->post('balance'),

			'note' => $this->input->post('note'),

		);

		$this->db->where('ID', $ID);

		$this->db->update('ms_supplier', $data);



		redirect('admin/master/supplier/'.$menuid);

	}



	function change_active($menuid, $ID, $publish)

	{

		if($publish==0)

		{

			$this->db->where('ID', $ID);

			$this->db->set('flag','1');

			$this->db->update('ms_promo');

		}

		else

		{

			$this->db->where('ID', $ID);

			$this->db->set('flag','0');

			$this->db->update('ms_promo');

		}

		redirect('admin/master/promo/'.$menuid);

	}



	public function config($menuid)

	{

 		$data['dataConfig'] = $this->master_model->select_in('config_global', '*', "WHERE ID=1");

		$this->load->view('admin/config_global', $data);

	}

	public function update_config_global($menuid)

	{

		$data = array(

			'name' => $this->input->post('name'),

			'address' => $this->input->post('address'),

			'phone' => $this->input->post('phone'),

			'news' => $this->input->post('news'),

			'flag' => $this->input->post('publish')

		);

		$this->db->where('ID', 1);

		$this->db->update('config_global', $data);

		redirect('admin/master/config/'.$menuid);

	}

	public function import_stock_opname($menuid)
	{
		
		$data = [];
		$fp = fopen($_FILES['file']['tmp_name'], 'rb');
	    while ( ($line = fgets($fp)) !== false) {
	      $barcode = $line;
		  $stock = $this->db->query("SELECT * FROM ts_stock_detail where barcode = '".trim($barcode)."'")->row();
		  if (empty($stock)) { // -> stock ngga ke temu
		  	$data[] = [
		  		'barcode' => trim($barcode),
		  		'code'    => $stock->code_inventory,
		  		'status'  => 2,
		  		'id_stock_detail' => null
		  	];
		  }else{ // -> stock ketemu
		  	$data[] = [
		  		'barcode' => $stock->barcode,
		  		'code'    => $stock->code_inventory,
		  		'status'  => 1,
		  		'id_stock_detail' => $stock->ID
		  	];
		  }
	    }
	    fclose($fp);
	    echo "<pre>";
	    print_r($data);
	    $this->master_model->clear_h();
	    // $this->db->insert('tbl_cek_barcode', $nl);
	    $this->db->insert_batch('tbl_cek_barcode', $data);
	}

	public function import_inventory($menuid)
	{
		define("menuid",$menuid);
        $user_id = $this->session->userdata('UserID');
        $this->redirectNoAuthRead($user_id, $menuid);

        $fileName = time().$_FILES['file']['name'];

        $config['upload_path'] = './assets/'; //buat folder dengan nama assets di root folder
        $config['file_name'] = $fileName;
        $config['allowed_types'] = 'xls|xlsx|csv';
        $config['max_size'] = 10000;

        $this->load->library('upload');
        $this->upload->initialize($config);

        if(! $this->upload->do_upload('file') )
        $this->upload->display_errors();

        $media = $this->upload->data('file');
        $inputFileName = './assets/'.$media['file_name'];

        try{
            $inputFileType = IOFactory::identify($inputFileName);
            $objReader = IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($inputFileName);
        }catch(Exception $e){
            die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
        }

        $sheet 			= $objPHPExcel->getSheet(0);
        $highestRow 	= $sheet->getHighestRow();
        $highestColumn 	= $sheet->getHighestColumn();

        $id_category=$this->master_model->mst_last_id('ms_inventory_category');
        for ($row = 2; $row <= $highestRow; $row++)
        {
            $rowData = $sheet->rangeToArray('A'.$row.':'.$highestColumn.$row, NULL, TRUE, FALSE);

			$check_data_category   = $this->master_model->check_data_category(trim($rowData[0][0]));

			//echo $check_data_category;
			//exit;

            if($check_data_category == true)
			{
				//echo 'Update Category';
				//exit;

				$id_category   = $this->master_model->check_data_category_2(trim($rowData[0][0]));
				$this->db->set('name', $rowData[0][0]);
				$this->db->where('ID', $id_category);
				$this->db->update('ms_inventory_category');

				$check_data_inventory   = $this->master_model->check_data_inventory(trim($rowData[0][1]), $id_category);

				if($check_data_inventory == true)
				{
					$ID   = $this->master_model->check_data_inventory_2(trim($rowData[0][1]));

					$this->db->set('code', $rowData[0][1]);
					$this->db->set('name', $rowData[0][2]);
					$this->db->where('ID', $ID);
					$this->db->update('ms_inventory');

				}else
				{
					$ID = $this->master_model->mst_last_id('ms_inventory');
					$data = array
					(
						'ID'	  		=> $ID,
						'id_category'	=> $id_category,
						'code'	  		=> $rowData[0][1],
						'name'	  		=> $rowData[0][2],
						'type'	  		=> 'Material',
						'unit'	  		=> $rowData[0][3],
	                    'publish' 		=> 1,
	                    'sort'    		=> $ID
					);

					$this->db->insert('ms_inventory', $data);
				}
			}else
			{
				//echo 'Insert Category';
				//exit;

				$id_category = $this->master_model->mst_last_id('ms_inventory_category');
				$data = array
				(
					'ID'	  => $id_category,
					'name'	  => $rowData[0][0],
                    'publish' => 1,
                    'sort'    => $id_category
				);

				$this->db->insert('ms_inventory_category', $data);


				$ID = $this->master_model->mst_last_id('ms_inventory');
				$data = array
				(
					'ID'	  		=> $ID,
					'id_category'	=> $id_category,
					'code'	  => $rowData[0][1],
					'name'	  => $rowData[0][2],
					'type'	  => 'Material',
					'unit'	  => $rowData[0][3],
                    'publish' => 1,
                    'sort'    => $ID
				);

				$this->db->insert('ms_inventory', $data);

			}


           	//print_array($row);

            delete_files($media['file_path']);
        }
        //exit;

        redirect('admin/master/inventory_category/'.$menuid);
    }



    public function import_stock_detail($menuid)
	{
        $fileName = time().$_FILES['file']['name'];

        $config['upload_path'] = './assets/'; //buat folder dengan nama assets di root folder
        $config['file_name'] = $fileName;
        $config['allowed_types'] = 'xls|xlsx|csv';
        $config['max_size'] = 10000;

        $this->load->library('upload');
        $this->upload->initialize($config);

        if(! $this->upload->do_upload('file') )
        $this->upload->display_errors();

        $media = $this->upload->data('file');
        $inputFileName = './assets/'.$media['file_name'];

        try{
            $inputFileType = IOFactory::identify($inputFileName);
            $objReader = IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($inputFileName);
        }catch(Exception $e){
            die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
        }

        $sheet 			= $objPHPExcel->getSheet(0);
        $highestRow 	= $sheet->getHighestRow();
        $highestColumn 	= $sheet->getHighestColumn();

        $po=$this->master_model->po();
        for ($row = 2; $row <= $highestRow; $row++)
        {
            $rowData = $sheet->rangeToArray('A'.$row.':'.$highestColumn.$row, NULL, TRUE, FALSE);

			/*
			$until=strtotime(date('Y-m-d'));
			$until=strtotime('+30 day', $until);
			$until=date('Y-m-d', $until);

            $id_purchase=$this->master_model->mst_last_id('ts_purchase');
            $data_purchase=array
            {
            	'ID'	 	    => $id_purchase,
				'purchase_no'   => $po,
                'date_in'   	=> date('Y-m-d'),
                'date_required'	=> $until,
                'supplier_code'	=> 'IR',
                'supplier_name'	=> 'Irfandi Rusdiansyah',
                'payment_term'	=> 30,
                'ship_via'		=> 'DKI JAKARTA',
                'id_admin'		=> 1,
                'status'		=> 'Process',
                'sort'			=> $id_purchase,
            }

            $this->db->insert('ts_purchase', $data_purchase);
			*/
            $id_purchase_detail=$this->master_model->mst_last_id('ts_purchase_detail');
            $data_purchase_detail=array
            (
            	'ID'	 	    => $id_purchase_detail,
				'id_purchase'   => 1,
                'code_inventory'=> $rowData[0][1],
                'name_inventory'=> $rowData[0][2],
                'qty'			=> $rowData[0][5],
                'price'			=> $rowData[0][4],
                'gross_ammount'	=> $rowData[0][4]*$rowData[0][5],
                'status'		=> 'Process',
                'sort'			=> $id_purchase_detail,
            );

            $this->db->insert('ts_purchase_detail', $data_purchase_detail);


			$id_stock_detail = $this->master_model->mst_last_id('ts_stock_detail');
			$data = array
			(
				'ID'	  => $id_stock_detail,
				'id_purchase_invoice'	  => 1,
				'id_purchase_detail'	  => $id_purchase_detail,
				'in_qty'  => $rowData[0][5],
                'price'   => $rowData[0][4],
			);


			$this->db->insert('ts_stock_detail', $data);


           	//print_array($row);

            delete_files($media['file_path']);
        }
        //exit;

        redirect('admin/transaction/stock/'.$menuid);
    }



    public function import_supplier($menuid)
	{
        $fileName = time().$_FILES['file']['name'];

        $config['upload_path'] = './assets/'; //buat folder dengan nama assets di root folder
        $config['file_name'] = $fileName;
        $config['allowed_types'] = 'xls|xlsx|csv';
        $config['max_size'] = 10000;

        $this->load->library('upload');
        $this->upload->initialize($config);

        if(! $this->upload->do_upload('file') )
        $this->upload->display_errors();

        $media = $this->upload->data('file');
        $inputFileName = './assets/'.$media['file_name'];

        try{
            $inputFileType = IOFactory::identify($inputFileName);
            $objReader = IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($inputFileName);
        }catch(Exception $e){
            die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
        }

        $sheet 			= $objPHPExcel->getSheet(0);
        $highestRow 	= $sheet->getHighestRow();
        $highestColumn 	= $sheet->getHighestColumn();

        $po=$this->master_model->po();
        for ($row = 2; $row <= $highestRow; $row++)
        {
            $rowData = $sheet->rangeToArray('A'.$row.':'.$highestColumn.$row, NULL, TRUE, FALSE);


            $ID=$this->master_model->mst_last_id('ms_supplier');
            $data_supplier=array
            (
            	'ID'	 		=> $ID,
				'code'   		=> $rowData[0][1],
                'name'			=> $rowData[0][2],
                'address'		=> $rowData[0][3],
                'address2'		=> $rowData[0][4],
                'contact'		=> $rowData[0][5],
                'phone'			=> $rowData[0][6],
                'fax'			=> $rowData[0][7],
                'email'			=> $rowData[0][8],
                'payment_term'  => $rowData[0][9],
                'account'	    => $rowData[0][10],
                'publish'		=> 1,
                'status'		=> 1,
                'sort'			=> $ID,
            );

            $this->db->insert('ms_supplier', $data_supplier);



           	//print_array($row);

            delete_files($media['file_path']);
        }
        //exit;

        redirect('admin/master/supplier/'.$menuid);
    }

    public function export_history($menuid, $id_category)
	{
		$code=$this->input->get('code');

		$data_inventory=$this->master_model->inventory_detail($code);

		$count_data_history=count($data_inventory);

		if($count_data_history == 0)
		{
			echo'
				<script language="javascript">
					window.alert("No transaction data to export on that date!!")
					window.location.href="'.base_url().'admin/master/inventory_detail/'.$menuid.'/'.$id_category.'/'.$code.'";
				</script>
			';
		}else
		{
			$styleArray =
				array(
					'borders' =>
				array(
				'allborders' =>
				 array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' =>
				array(
					'argb' => '00000000'
					),
				),
				),
			);

			$fontHeader = array(
				'font' => array(
					'bold' => true
				),
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
					'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'rotation'   => 0,

				),
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'F7F7F8')
				)
			);

			$objPHPExcel = new phpexcel();

			$objPHPExcel->setActiveSheetIndex(0);

			$objPHPExcel->getActiveSheet()->setTitle('INVENTORY HISTORY');
			$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
			$objPHPExcel->getActiveSheet()->setCellValue('B4', 'Source');
			$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Finish Good');
			$objPHPExcel->getActiveSheet()->setCellValue('D4', 'In Qty');
			$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Qty Use');
			$objPHPExcel->getActiveSheet()->setCellValue('F4', 'Qty Left');
			$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Qty Retur');
			$objPHPExcel->getActiveSheet()->setCellValue('H4', 'Price');
			$objPHPExcel->getActiveSheet()->setCellValue('I4', 'Date');
			$objPHPExcel->getActiveSheet()->setCellValue('J4', 'Schedule Date');

			for($a=0; $a < count($data_inventory); $a++)
			{
				$ID = $data_inventory[$a]->id;

				if($data_inventory[$a]->purchase_invoice_no=='')
                {
                    $source = $data_inventory[$a]->workorder_bf;
                }else
                {
                    $source = $data_inventory[$a]->purchase_invoice_no;
                }

                if($data_inventory[$a]->date_in==0)
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in_wo));
                }else
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in));
                }

                if($data_inventory[$a]->date_schedule==0 || $data_inventory[$a]->date_schedule=='')
                {
                    $schedule_date = '-';
                }else
                {
                    $schedule_date = date('d M Y', strtotime($data_inventory[$a]->date_schedule));
                }

				$isi[]= array('A' => $a+1, 'B' => $source, 'C' => $data_inventory[$a]->finish_good, 'D' => $data_inventory[$a]->in_qty, 'E' => $data_inventory[$a]->qty_use, 'F' => $data_inventory[$a]->qty_waste, 'G' => $data_inventory[$a]->qty_retur, 'H' => $data_inventory[$a]->price, 'I' => $date_in, 'J' => $schedule_date);
			}


			$objPHPExcel->getActiveSheet()->getStyle('A4:J5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A4:J5')->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(25);

			//set merge kolom
			$objPHPExcel->getActiveSheet()->mergeCells('A1:J1');
			$objPHPExcel->getActiveSheet()->mergeCells('A2:J2');
			$objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
			$objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
			$objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
			$objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
			$objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
			$objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
			$objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
			$objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
			$objPHPExcel->getActiveSheet()->mergeCells('I4:I5');
			$objPHPExcel->getActiveSheet()->mergeCells('J4:J5');

			//set papersize
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setTop(0.25);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setRight(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setLeft(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setBottom(0.25);
			$objPHPExcel->getActiveSheet()
				->setShowGridlines(true);

			//set header kolom
			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'INVENTORY HISTORY');
			$objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime(date('Y-m-d'))));


			// melakukan pengisian data
			foreach($isi as $k => $v)
			{
				$col = $k + 6;

				foreach($v as $k1 => $v1)
				{
					$column = $k1.$col;
					$objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

					$subtotal='=I'.$col.'*K'.$col;

					//$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
				}
			}
			$tco=$col+1;

			//$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

			$objWorksheet = $objPHPExcel->getActiveSheet(0);
			$objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

			$objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
			$objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
			$objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

			$objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()
			->getStyle('A6:A'.$col)
			->getAlignment()
			->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
			->setTextRotation(0);

			$tanggal = date('d M Y');
			$filename = 'INVENTORY HISTORY '.$tanggal.'.xlsx';

			//$filename='just_some_random_name.xlsx'; //save our workbook as this file name
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache

			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .XLSX Excel 2007 format
			$objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
			exit;
		}
	}



	public function export_stock_opname($menuid, $id_category)
	{
		$code  = $this->input->get('code');
		$order = $this->input->get('order');
		if($order == '')
		{
			$order = 'ORDER BY a.code_inventory, a.ID ASC';
		}else {
			$order = $order;
		}
// 		echo $order;
// 	die();	
		$data_inventory=$this->master_model->stock_opname_by_qty($order);

		$count_data_history=count($data_inventory);

		if($count_data_history == 0)
		{
			echo'
				<script language="javascript">
					window.alert("No transaction data to export on that date!!")
					window.location.href="'.base_url().'admin/master/inventory_detail/'.$menuid.'/'.$id_category.'/'.$code.'";
				</script>
			';
		}else
		{
			$styleArray =
				array(
					'borders' =>
				array(
				'allborders' =>
				 array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' =>
				array(
					'argb' => '00000000'
					),
				),
				),
			);

			$fontHeader = array(
				'font' => array(
					'bold' => true
				),
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
					'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'rotation'   => 0,

				),
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'F7F7F8')
				)
			);

			$objPHPExcel = new phpexcel();

			$objPHPExcel->setActiveSheetIndex(0);

			$objPHPExcel->getActiveSheet()->setTitle('STOCK OPNAME');
			$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
			$objPHPExcel->getActiveSheet()->setCellValue('B4', 'Barcode');
			$objPHPExcel->getActiveSheet()->setCellValue('C4', 'Code');
			$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Name Material');
			$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Qty Available');
			$objPHPExcel->getActiveSheet()->setCellValue('F4', 'Price');
			$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Date');
			$objPHPExcel->getActiveSheet()->setCellValue('H4', 'Schedule Date');

			for($a=0; $a < count($data_inventory); $a++)
			{
				$ID = $data_inventory[$a]->id;

				// if($data_inventory[$a]->purchase_invoice_no=='')
    //             {
    //                 $source = $data_inventory[$a]->workorder_bf;
    //             }else
    //             {
    //                 $source = $data_inventory[$a]->purchase_invoice_no;
    //             }
				$source = $data_inventory[$a]->barcode;
                if($data_inventory[$a]->code_inventory=='')
                {
                    $code = $data_inventory[$a]->code_inventory_material;
                }else
                {
                    $code = $data_inventory[$a]->code_inventory;
                }

                if($data_inventory[$a]->date_in==0)
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in_wo));
                }else
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in));
                }

                if($data_inventory[$a]->date_schedule==0 || $data_inventory[$a]->date_schedule=='')
                {
                    $schedule_date = '-';
                }else
                {
                    $schedule_date = date('d M Y', strtotime($data_inventory[$a]->date_schedule));
                }

				$isi[]= array('A' => $a+1, 'B' => $source, 'C' => $code, 'D' => $data_inventory[$a]->name, 'E' => $data_inventory[$a]->in_qty, 'F' => $data_inventory[$a]->price, 'G' => $date_in, 'H' => $schedule_date);
			}


			$objPHPExcel->getActiveSheet()->getStyle('A4:H5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A4:H5')->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);

			//set merge kolom
			$objPHPExcel->getActiveSheet()->mergeCells('A1:H1');
			$objPHPExcel->getActiveSheet()->mergeCells('A2:H2');
			$objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
			$objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
			$objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
			$objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
			$objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
			$objPHPExcel->getActiveSheet()->mergeCells('F4:F5');
			$objPHPExcel->getActiveSheet()->mergeCells('G4:G5');
			$objPHPExcel->getActiveSheet()->mergeCells('H4:H5');

			//set papersize
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setTop(0.25);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setRight(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setLeft(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setBottom(0.25);
			$objPHPExcel->getActiveSheet()
				->setShowGridlines(true);

			//set header kolom
			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'STOCK OPNAME');
			$objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime(date('Y-m-d'))));


			// melakukan pengisian data
			foreach($isi as $k => $v)
			{
				$col = $k + 6;

				foreach($v as $k1 => $v1)
				{
					$column = $k1.$col;
					$objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

					$subtotal='=I'.$col.'*K'.$col;

					//$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
				}
			}
			$tco=$col+1;

			//$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

			$objWorksheet = $objPHPExcel->getActiveSheet(0);
			$objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

			$objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
			$objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
			$objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

			$objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()
			->getStyle('A6:A'.$col)
			->getAlignment()
			->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
			->setTextRotation(0);

			$tanggal = date('d M Y');
			$filename = 'STOCK OPNAME '.$tanggal.'.xlsx';

			//$filename='just_some_random_name.xlsx'; //save our workbook as this file name
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache

			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .XLSX Excel 2007 format
			$objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
			exit;
		}
	}



	public function export_available($menuid, $id_category)
	{
		$code=$this->input->get('code');

		$data_inventory=$this->master_model->data_stock_detail($id_category, $code);

		$count_data_history=count($data_inventory);

		if($count_data_history == 0)
		{
			echo'
				<script language="javascript">
					window.alert("No transaction data to export on that date!!")
					window.location.href="'.base_url().'admin/master/inventory_stock/'.$menuid.'/'.$id_category.'/'.$code.'";
				</script>
			';
		}else
		{
			$styleArray =
				array(
					'borders' =>
				array(
				'allborders' =>
				 array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' =>
				array(
					'argb' => '00000000'
					),
				),
				),
			);

			$fontHeader = array(
				'font' => array(
					'bold' => true
				),
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
					'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'rotation'   => 0,

				),
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'F7F7F8')
				)
			);

			$objPHPExcel = new phpexcel();

			$objPHPExcel->setActiveSheetIndex(0);

			$objPHPExcel->getActiveSheet()->setTitle('AVAILABLE INVENTORY');
			$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('A2')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->setCellValue('A4', 'No.');
			$objPHPExcel->getActiveSheet()->setCellValue('B4', 'Source');
			$objPHPExcel->getActiveSheet()->setCellValue('C4', 'In Qty');
			$objPHPExcel->getActiveSheet()->setCellValue('D4', 'Qty Retur');
			$objPHPExcel->getActiveSheet()->setCellValue('E4', 'Price');
			$objPHPExcel->getActiveSheet()->setCellValue('F4', 'Date');

			for($a=0; $a < count($data_inventory); $a++)
			{
				$ID = $data_inventory[$a]->id;

				if($data_inventory[$a]->purchase_invoice_no=='')
                {
                    $source = $data_inventory[$a]->workorder_bf;
                }else
                {
                    $source = $data_inventory[$a]->purchase_invoice_no;
                }

                if($data_inventory[$a]->date_in==0)
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in_wo));
                }else
                {
                    $date_in = date('d M Y', strtotime($data_inventory[$a]->date_in));
                }

				$isi[]= array('A' => $a+1, 'B' => $source, 'C' => $data_inventory[$a]->in_qty, 'D' => $data_inventory[$a]->qty_retur, 'E' => $data_inventory[$a]->price, 'F' => $date_in);
			}


			$objPHPExcel->getActiveSheet()->getStyle('A4:J5')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(18)->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A4:F5')->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);

			//set merge kolom
			$objPHPExcel->getActiveSheet()->mergeCells('A1:F1');
			$objPHPExcel->getActiveSheet()->mergeCells('A2:F2');
			$objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
			$objPHPExcel->getActiveSheet()->mergeCells('B4:B5');
			$objPHPExcel->getActiveSheet()->mergeCells('C4:C5');
			$objPHPExcel->getActiveSheet()->mergeCells('D4:D5');
			$objPHPExcel->getActiveSheet()->mergeCells('E4:E5');
			$objPHPExcel->getActiveSheet()->mergeCells('F4:F5');

			//set papersize
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
			$objPHPExcel->getActiveSheet()
				->getPageSetup()
				->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);

			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setTop(0.25);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setRight(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setLeft(0);
			$objPHPExcel->getActiveSheet()
				->getPageMargins()->setBottom(0.25);
			$objPHPExcel->getActiveSheet()
				->setShowGridlines(true);

			//set header kolom
			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'AVAILABLE INVENTORY');
			$objPHPExcel->getActiveSheet()->setCellValue('A2', 'Period : '.date('d M Y', strtotime(date('Y-m-d'))));


			// melakukan pengisian data
			foreach($isi as $k => $v)
			{
				$col = $k + 6;

				foreach($v as $k1 => $v1)
				{
					$column = $k1.$col;
					$objPHPExcel->getActiveSheet()->setCellValue($column, $v1);

					$subtotal='=I'.$col.'*K'.$col;

					//$objPHPExcel->getActiveSheet()->setCellValue('M'.$col, $subtotal);
				}
			}
			$tco=$col+1;

			//$objPHPExcel->getActiveSheet()->setCellValue('G'.$tco, $subtotal);

			$objWorksheet = $objPHPExcel->getActiveSheet(0);
			$objWorksheet->getStyle('A4:'.$column)->applyFromArray($styleArray);

			$objWorksheet->getStyle('D6:D'.$col)->getNumberFormat()->setFormatCode('#,##0');
			$objWorksheet->getStyle('D'.$tco)->getNumberFormat()->setFormatCode('#,##0');
			$objPHPExcel->getActiveSheet()->getStyle('A6:A'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('C6:C'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);;

			$objPHPExcel->getActiveSheet()->getStyle('D6:D'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('E6:E'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('I6:I'.$col)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('B6:B'.$col)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('C'.$tco)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('D'.$tco)->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()
			->getStyle('A6:A'.$col)
			->getAlignment()
			->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER)
			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
			->setTextRotation(0);

			$tanggal = date('d M Y');
			$filename = 'AVAILABLE INVENTORY '.$tanggal.'.xlsx';

			//$filename='just_some_random_name.xlsx'; //save our workbook as this file name
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache

			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .XLSX Excel 2007 format
			$objWriter = IOFactory::createWriter($objPHPExcel, 'Excel2007');

			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
			exit;
		}
	}

}

?>
