<?php
class Jurnal
{
	public $errors = [];
	public $use_json = true;
    public function requestPOST($url, $data)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $error_msg     = curl_error($ch);

        $this->errors[] = $error_msg;
        if ($this->use_json) {
        	return json_decode($server_output);
        }else{
        	return ($server_output);
        }
    }

    public function getErrors()
    {
    	return $this->errors;
    }

     public function addVendors($data){
    	return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/vendors/add_vendors", $data);
    }

    public function addProducts($data){
    	$hasil = [];
    	foreach ($data as $key => $products) {
    		$hasil[] = $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/products/add_products", $products);
    	}

    	return $hasil;
    }

    public function addPurchaseInvoice($data){
    	return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/purchase_invoice/add_purchase_invoice", $data);
    }

    public function addPurchaseInvoiceWorkorder($data){
    	return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/purchase_invoice/add_purchase_invoice_workorder", $data);
    }

     public function addWorkorder($data){
    	return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/work_order/add_work_order", $data);
    }

    // public function addWorkorderIn($data){
    //     return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/work_order/add_workorder_stock_in", $data);
    // }

    public function addWorkorderIn($data){
        return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/products/convert_product", $data);
    }

    public function addWorkorderStockIn($data){
        return $this->requestPOST("https://solusiprogram.xyz/jurnal/api/api/purchase_invoice/add_purchase_invoice_workorder", $data);
    }

}
