<?php

/*

 * CKFinder

 * ========

 * http://ckfinder.com

 * Copyright (C) 2007-2010, CKSource - Frederico Knabben. All rights reserved.

 *

 * The software, this file and its contents are subject to the CKFinder

 * License. Please read the license.txt file before using, installing, copying,

 * modifying or distribute this file or part of its contents. The contents of

 * this file is part of the Source Code of CKFinder.

 */

if (!defined('IN_CKFINDER')) exit;



/**

 * @package CKFinder

 * @subpackage CommandHandlers

 * @copyright CKSource - Frederico Knabben

 */



/**

 * Include base XML command handler

 */

require_once CKFINDER_CONNECTOR_LIB_DIR . "/CommandHandler/XmlCommandHandlerBase.php";



/**

 * Handle DeleteFile command

 *

 * @package CKFinder

 * @subpackage CommandHandlers

 * @copyright CKSource - Frederico Knabben

 */

class CKFinder_Connector_CommandHandler_DeleteFile extends CKFinder_Connector_CommandHandler_XmlCommandHandlerBase

{

    /**

     * Command name

     *

     * @access private

     * @var string

     */

    private $command = "DeleteFile";





    /**

     * handle request and build XML

     * @access protected

     *

     */

    protected function buildXml()

    {

        if (empty($_POST['CKFinderCommand']) || $_POST['CKFinderCommand'] != 'true') {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_INVALID_REQUEST);

        }



        if (!$this->_currentFolder->checkAcl(CKFINDER_CONNECTOR_ACL_FILE_DELETE)) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_UNAUTHORIZED);

        }



        if (!isset($_GET["FileName"])) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_INVALID_NAME);

        }



        $fileName = CKFinder_Connector_Utils_FileSystem::convertToFilesystemEncoding($_GET["FileName"]);

        $_resourceTypeInfo = $this->_currentFolder->getResourceTypeConfig();



        if (!CKFinder_Connector_Utils_FileSystem::checkFileName($fileName) || $_resourceTypeInfo->checkIsHiddenFile($fileName)) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_INVALID_REQUEST);

        }



        if (!$_resourceTypeInfo->checkExtension($fileName, false)) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_INVALID_REQUEST);

        }



        $filePath = CKFinder_Connector_Utils_FileSystem::combinePaths($this->_currentFolder->getServerPath(), $fileName);



        $bDeleted = false;



        if (!file_exists($filePath)) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_FILE_NOT_FOUND);

        }



        if (!@unlink($filePath)) {

            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_ACCESS_DENIED);

        } else {

            $bDeleted = true;

        }



        if ($bDeleted) {

            $thumbPath = CKFinder_Connector_Utils_FileSystem::combinePaths($this->_currentFolder->getThumbsServerPath(), $fileName);



            @unlink($thumbPath);



            $oDeleteFileNode = new Ckfinder_Connector_Utils_XmlNode("DeletedFile");

            $this->_connectorNode->addChild($oDeleteFileNode);



            $oDeleteFileNode->addAttribute("name", $fileName);

        }

    }

}

