﻿/*

* Jssor.Core 16.0

* http://www.jssor.com/

* 

* TERMS OF USE - Jssor.Core

* 

* Copyright 2014 Jssor

*

* Permission is hereby granted, free of charge, to any person obtaining

* a copy of this software and associated documentation files (the

* "Software"), to deal in the Software without restriction, including

* without limitation the rights to use, copy, modify, merge, publish,

* distribute, sublicense, and/or sell copies of the Software, and to

* permit persons to whom the Software is furnished to do so, subject to

* the following conditions:

* 

* The above copyright notice and this permission notice shall be

* included in all copies or substantial portions of the Software.

* 

* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,

* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF

* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND

* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE

* LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION

* OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION

* WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



/*! Jssor */

$Jssor$ = window.$Jssor$ = window.$Jssor$ || {};





//$JssorDebug$

var $JssorDebug$ = new function () {



    this.$DebugMode = true;



    // Methods



    this.$Log = function (msg, important) {

        var console = window.console || {};

        var debug = this.$DebugMode;



        if (debug && console.log) {

            console.log(msg);

        } else if (debug && important) {

            alert(msg);

        }

    };



    this.$Error = function (msg, e) {

        var console = window.console || {};

        var debug = this.$DebugMode;



        if (debug && console.error) {

            console.error(msg);

        } else if (debug) {

            alert(msg);

        }



        if (debug) {

            // since we're debugging, fail fast by crashing

            throw e || new Error(msg);

        }

    };



    this.$Fail = function (msg) {

        throw new Error(msg);

    };



    this.$Assert = function (value, msg) {

        var debug = this.$DebugMode;

        if (debug) {

            if (!value)

                throw new Error("Assert failed " + msg || "");

        }

    };



    this.$Trace = function (msg) {

        var console = window.console || {};

        var debug = this.$DebugMode;



        if (debug && console.log) {

            console.log(msg);

        }

    };



    this.$Execute = function (func) {

        var debug = this.$DebugMode;

        if (debug)

            func();

    };



    this.$LiveStamp = function (obj, id) {

        var stamp = document.createElement("DIV");

        stamp.setAttribute("id", id);



        obj.$Live = stamp;

    };

};





//$JssorEventManager$

var $JssorEventManager$ = function () {

    var self = this;

    // Fields



    var listeners = {}; // dictionary of eventName --> array of handlers



    // Methods



    self.$On = self.addEventListener = function (eventName, handler) {

        if (typeof (handler) != "function") {

            return;

        }



        if (!listeners[eventName]) {

            listeners[eventName] = [];

        }



        listeners[eventName].push(handler);

    };



    self.$Off = self.removeEventListener = function (eventName, handler) {

        var handlers = listeners[eventName];



        if (typeof (handler) != "function") {

            return;

        } else if (!handlers) {

            return;

        }



        for (var i = 0; i < handlers.length; i++) {

            if (handler == handlers[i]) {

                handlers.splice(i, 1);

                return;

            }

        }

    };



    self.$ClearEventListeners = function (eventName) {

        if (listeners[eventName]) {

            delete listeners[eventName];

        }

    };



    self.$TriggerEvent = function (eventName) {

        var handlers = listeners[eventName];

        var args = [];



        if (!handlers) {

            return;

        }



        for (var i = 1; i < arguments.length; i++) {

            args.push(arguments[i]);

        }



        for (var i = 0; i < handlers.length; i++) {

            try {

                handlers[i].apply(window, args);

            } catch (e) {

                // handler threw an error, ignore, go on to next one

                $JssorDebug$.$Error(e.name + " while executing " + eventName +

                        " handler: " + e.message, e);

            }

        }

    };

};